package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.ObjetivoPlanoMelhoriaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ObjetivoPlanoMelhoriaDao extends CrudDaoDefaultImpl {

	public ObjetivoPlanoMelhoriaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idObjetivoPlanoMelhoria", "idObjetivoPlanoMelhoria", true, true, false, false));
		listFields.add(new Field("idPlanoMelhoria", "idPlanoMelhoria", false, false, false, false));
		listFields.add(new Field("tituloObjetivo", "tituloObjetivo", false, false, false, false));
		listFields.add(new Field("detalhamento", "detalhamentoObjetivo", false, false, false, false));
		listFields.add(new Field("resultadoEsperado", "resultadoEsperado", false, false, false, false));
		listFields.add(new Field("medicao", "medicaoObjetivo", false, false, false, false));
		listFields.add(new Field("responsavel", "responsavelObjetivo", false, false, false, false));
		listFields.add(new Field("criadoPor", "criadoPor", false, false, false, false));
		listFields.add(new Field("modificadoPor", "modificadoPor", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("ultModificacao", "ultModificacao", false, false, false, false));
		listFields.add(new Field("idrespobj", "idRespObj", false, false, false, false));
		listFields.add(new Field("idgruporespobj", "idGrupoRespObj", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "ObjetivoPlanoMelhoria";
	}

	@Override
	public Class getBean() {
		return ObjetivoPlanoMelhoriaDTO.class;
	}

	public List<ObjetivoPlanoMelhoriaDTO> findByIdPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idPlanoMelhoria", "=", parm));
		ordenacao.add(new Order("tituloObjetivo"));
		return (List<ObjetivoPlanoMelhoriaDTO>) super.findByCondition(condicao, ordenacao);
	}

	@Override
	public List<ObjetivoPlanoMelhoriaDTO> findByCondition(List condicao, List ordenacao) throws PersistenceException {
		List<ObjetivoPlanoMelhoriaDTO> lista = new ArrayList<>();
		lista.addAll(super.findByCondition(condicao, ordenacao));
		return lista;
	}

	public boolean hasVinculoComPlanoMelhoria(Integer idPlanoMelhoria) throws PersistenceException {
		return findByIdPlanoMelhoria(idPlanoMelhoria) != null && findByIdPlanoMelhoria(idPlanoMelhoria).size() > 0;
	}

	public void deleteByIdPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idPlanoMelhoria", "=", parm));
		super.deleteByCondition(condicao);
	}

	public List<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoria(Integer idPlanoMelhoria) throws PersistenceException {

		StringBuilder sql = new StringBuilder();

		List parametro = new ArrayList();

		List list = new ArrayList();

		sql.append("select idobjetivoplanomelhoria, tituloobjetivo, resultadoesperado, medicao, responsavel, idRespObj, idGrupoRespObj from " + getTableName() + " where idplanomelhoria = ? ");

		parametro.add(idPlanoMelhoria);

		list = this.execSQL(sql.toString(), parametro.toArray());
		List listaRetorno = new ArrayList();
		listaRetorno.add("idObjetivoPlanoMelhoria");
		listaRetorno.add("tituloObjetivo");
		listaRetorno.add("resultadoEsperado");
		listaRetorno.add("medicaoObjetivo");
		listaRetorno.add("responsavelObjetivo");
		listaRetorno.add("idRespObj");
		listaRetorno.add("idGrupoRespObj");

		if (list != null && !list.isEmpty()) {
			return this.listConvertion(ObjetivoPlanoMelhoriaDTO.class, list, listaRetorno);
		}

		return Collections.emptyList();
	}

	public List<IDto> listObjetivosPlanoMelhoriaAsIDto(Integer idPlanoMelhoria) throws Exception {
		Collection<ObjetivoPlanoMelhoriaDTO> lista = listObjetivosPlanoMelhoria(idPlanoMelhoria);
		List<IDto> listaResultado = new ArrayList<>();
		if (lista != null && lista.size() > 0)
			listaResultado.addAll(lista);
		return listaResultado;
	}

	@Override
	public void update(IDto obj) throws PersistenceException {
		ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDTO = (ObjetivoPlanoMelhoriaDTO) restore(obj);
		if (objetivoPlanoMelhoriaDTO != null) {
			((ObjetivoPlanoMelhoriaDTO) obj).setCriadoPor(objetivoPlanoMelhoriaDTO.getCriadoPor());
			((ObjetivoPlanoMelhoriaDTO) obj).setDataCriacao(objetivoPlanoMelhoriaDTO.getDataCriacao());
		}
		super.update(obj);
	}
}
