package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoAnexosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoAnexosDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoAnexosDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoAnexos";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoAnexos", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idAnexo", "idAnexoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeAnexo", "nomeAnexoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("descricaoAnexo", "descricaoAnexoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoAnexosDTO> getBean() {
		return OcorrenciaServicoAnexosDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoAnexosDTO> findOcorrenciaServicoAnexosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoAnexos"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = (List<OcorrenciaServicoAnexosDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoAnexos != null && !listaOcorrenciaServicoAnexos.isEmpty()) {
			return listaOcorrenciaServicoAnexos;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos anexos
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerated.OcorrenciaServicoAcoes
	 * @param ocorrenciaServicoDTO
	 * @param listaIdsAnexos
	 *            lista dos ids dos anexos em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link OcorrenciaServicoAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoAnexos(final OcorrenciaServicoDTO ocorrenciaServicoDTO, final List<Integer> listaIdsAnexos, final String acaoOcorrenciaServico) throws Exception {
		if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null && ocorrenciaServicoDTO.getCategoriaOcorrencia() != null) {
			Integer idOcorrenciaServico = ocorrenciaServicoDTO.getIdOcorrenciaServico();
			String categoriaOcorrenciaServico = ocorrenciaServicoDTO.getCategoriaOcorrencia();

			List<Object> listResultado = this.getListResultado(idOcorrenciaServico, categoriaOcorrenciaServico);

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idAnexoOcorrenciaServico");
			listRetorno.add("nomeAnexoOcorrenciaServico");
			listRetorno.add("descricaoAnexoOcorrenciaServico");

			List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = this.engine.listConvertion(OcorrenciaServicoAnexosDTO.class, listResultado, listRetorno);

			if (listaOcorrenciaServicoAnexos != null && !listaOcorrenciaServicoAnexos.isEmpty()) {
				for (OcorrenciaServicoAnexosDTO ocorrenciaServicoAnexosDTO : listaOcorrenciaServicoAnexos) {
					ocorrenciaServicoAnexosDTO.setIdOcorrenciaServico(idOcorrenciaServico);
					if (!acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) && !listaIdsAnexos.isEmpty()
							&& listaIdsAnexos.contains(ocorrenciaServicoAnexosDTO.getIdAnexoOcorrenciaServico())) {
						ocorrenciaServicoAnexosDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
					}
					this.create(ocorrenciaServicoAnexosDTO);
				}
			}
		}
	}

	@SuppressWarnings("unchecked")
	private List<Object> getListResultado(final Integer idOcorrenciaServico, final String categoriaOcorrenciaServico) throws PersistenceException {
		List<Object> result = new ArrayList<Object>();
		Integer idTabela = this.getIdTabelaControleAnexos(categoriaOcorrenciaServico);

		if (idTabela != null) {
			List<Object> listParametro = new ArrayList<Object>();
			listParametro.add(idOcorrenciaServico);
			listParametro.add(idTabela);
			StringBuilder sqlBuilder = this.getSqlBuilder(categoriaOcorrenciaServico);

			if (sqlBuilder != null) {
				result = this.execSQL(sqlBuilder.toString(), listParametro.toArray());
			}
		}

		return result;
	}

	private Integer getIdTabelaControleAnexos(String categoriaOcorrenciaServico) {
		Integer idTabela = null;
		
		if (OcorrenciaServicoCategorias.DETALHES_SERVICO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			idTabela = new Integer(ControleGEDDTO.TABELA_SERVICO_NEGOCIO);
		} else if (OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			idTabela = new Integer(ControleGEDDTO.TABELA_REQUISITOS_NIVEL_SERVICO);
		} else if (OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			idTabela = new Integer(ControleGEDDTO.TABELA_BUSINESS_CASE);
		} else if (OcorrenciaServicoCategorias.ESQUEMA_DADOS.getIdentificador().equals(categoriaOcorrenciaServico)) {
			idTabela = new Integer(ControleGEDDTO.TABELA_ESQUEMA_DADOS);
		}
		
		return idTabela;
	}

	private StringBuilder getSqlBuilder(String categoriaOcorrenciaServico) {
		if (OcorrenciaServicoCategorias.DETALHES_SERVICO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			return this.getSqlBuilderDetalhesServico();
		} else if (OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			return this.getSqlBuilderRequisitosNivelServico();
		} else if (OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador().equals(categoriaOcorrenciaServico)) {
			return this.getSqlBuilderCasoNegocio();
		} else if (OcorrenciaServicoCategorias.ESQUEMA_DADOS.getIdentificador().equals(categoriaOcorrenciaServico)) {
			return this.getSqlBuilderEsquemaDados();
		}

		return null;
	}

	private StringBuilder getSqlBuilderDetalhesServico() {
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		controleGed.idControleGed, ");
		sqlBuilder.append("		controleGed.nomeArquivo, ");
		sqlBuilder.append("		controleGed.descricaoArquivo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN controleGed controleGed ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = controleGed.id ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND controleGed.idTabela = ? ");
		sqlBuilder.append("	ORDER  BY controleGed.idControleGed ");

		return sqlBuilder;
	}

	private StringBuilder getSqlBuilderRequisitosNivelServico() {
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		controleGed.idControleGed, ");
		sqlBuilder.append("		controleGed.nomeArquivo, ");
		sqlBuilder.append("		controleGed.descricaoArquivo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN requisitosNivelServico requisitosNivelServico ");
		sqlBuilder.append("			ON requisitosNivelServico.idServicoNegocio = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN controleGed controleGed ");
		sqlBuilder.append("			ON requisitosNivelServico.idRequisitosNivelServico = controleGed.id ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND controleGed.idTabela = ? ");
		sqlBuilder.append("	ORDER  BY controleGed.idControleGed ");

		return sqlBuilder;
	}

	private StringBuilder getSqlBuilderCasoNegocio() {
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		controleGed.idControleGed, ");
		sqlBuilder.append("		controleGed.nomeArquivo, ");
		sqlBuilder.append("		controleGed.descricaoArquivo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN casoNegocio casoNegocio ");
		sqlBuilder.append("			ON casoNegocio.idServicoCasoNegocio = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN controleGed controleGed ");
		sqlBuilder.append("			ON casoNegocio.idCasoNegocio = controleGed.id ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND controleGed.idTabela = ? ");
		sqlBuilder.append("	ORDER  BY controleGed.idControleGed ");

		return sqlBuilder;
	}

	private StringBuilder getSqlBuilderEsquemaDados() {
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		controleGed.idControleGed, ");
		sqlBuilder.append("		controleGed.nomeArquivo, ");
		sqlBuilder.append("		controleGed.descricaoArquivo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN ocorrenciaServicoEsquemaDados ocorrenciaServicoEsquemaDados ");
		sqlBuilder.append("			ON ocorrenciaServico.idOcorrenciaServico = ocorrenciaServicoEsquemaDados.idOcorrenciaServico ");
		sqlBuilder.append("		INNER JOIN controleGed controleGed ");
		sqlBuilder.append("			ON ocorrenciaServicoEsquemaDados.idEsquemaDados = controleGed.id ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND controleGed.idTabela = ? ");
		sqlBuilder.append("	ORDER  BY controleGed.idControleGed ");

		return sqlBuilder;
	}

}
