package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoAplicacaoDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoAplicacaoDAO extends CrudDaoDefaultImpl{

	public OcorrenciaServicoAplicacaoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoAplicacao";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();
		
		listFields.add(new Field("id", "idOcorrenciaServicoAplicacao", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idAplicacao", "idAplicacaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeAplicacao", "nomeAplicacaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeResponsavelAplicacao", "nomeResponsavelAplicacaoOcorrenciaServico", false, false, false, false));
		
		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoAplicacaoDTO> getBean() {
		return OcorrenciaServicoAplicacaoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoAplicacaoDTO> findOcorrenciaServicoAplicacaoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoAplicacao"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoAplicacaoDTO> listaOcorrenciaServicoAplicacao = (List<OcorrenciaServicoAplicacaoDTO>) super.findByCondition(condicao, ordenacao);
		
		if(listaOcorrenciaServicoAplicacao != null && !listaOcorrenciaServicoAplicacao.isEmpty()) {
			return listaOcorrenciaServicoAplicacao;
		}
		
		return Collections.emptyList();
	}
	
	/**
	 * Cria a ocorrncia de servio das aplicaes
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do processo negcio em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoAplicacao(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();
		
		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		aplicacao.idAplicacao, ");
		sqlBuilder.append("		aplicacao.nome, ");
		sqlBuilder.append("		empregados.nome ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN aplicacaoServico aplicacaoServico ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = aplicacaoServico.idServico ");
		sqlBuilder.append("		INNER JOIN aplicacao aplicacao ");
		sqlBuilder.append("			ON aplicacaoServico.idAplicacao = aplicacao.idAplicacao ");
		sqlBuilder.append("		LEFT JOIN empregados empregados ");
		sqlBuilder.append("			ON aplicacao.idResponsavel = empregados.idEmpregado ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND aplicacao.dataFim IS NULL ");
		sqlBuilder.append("	ORDER  BY aplicacao.idAplicacao ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());
		
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAplicacaoOcorrenciaServico");
		listRetorno.add("nomeAplicacaoOcorrenciaServico");
		listRetorno.add("nomeResponsavelAplicacaoOcorrenciaServico");
		
		List<OcorrenciaServicoAplicacaoDTO> listaOcorrenciaServicoAplicacao = this.engine.listConvertion(OcorrenciaServicoAplicacaoDTO.class, listResultado, listRetorno);
		
		if(listaOcorrenciaServicoAplicacao != null && !listaOcorrenciaServicoAplicacao.isEmpty()) {
			for(OcorrenciaServicoAplicacaoDTO ocorrenciaServicoAplicacaoDTO : listaOcorrenciaServicoAplicacao) {
				ocorrenciaServicoAplicacaoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!listaIdsOcorrenciaServico.isEmpty() && !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoAplicacaoDTO.getIdAplicacaoOcorrenciaServico())) {
					ocorrenciaServicoAplicacaoDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				this.create(ocorrenciaServicoAplicacaoDTO);
			}
		}
		
		if (!listaIdsOcorrenciaServico.isEmpty() && AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)) {
			this.createOcorrenciaServicoAplicacaoDesvinculado(idOcorrenciaServico, listaIdsOcorrenciaServico.get(0));
		}
	}

	/**
	 * Cria a ocorrncia de servio da aplicao desvinculada
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param idAplicacaoDesvinculada
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoAplicacaoDesvinculado(final Integer idOcorrenciaServico, final Integer idAplicacaoDesvinculada) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		aplicacao.idAplicacao, ");
		sqlBuilder.append(" 	aplicacao.nome, ");
		sqlBuilder.append(" 	empregados.nome ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		aplicacao aplicacao ");
		sqlBuilder.append("		LEFT JOIN empregados empregados ");
		sqlBuilder.append("			ON aplicacao.idResponsavel = empregados.idEmpregado ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		aplicacao.idAplicacao = ? ");
		sqlBuilder.append("		AND aplicacao.dataFim IS NULL ");
		sqlBuilder.append("	ORDER  BY aplicacao.idAplicacao ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idAplicacaoDesvinculada);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAplicacaoOcorrenciaServico");
		listRetorno.add("nomeAplicacaoOcorrenciaServico");
		listRetorno.add("nomeResponsavelAplicacaoOcorrenciaServico");

		List<OcorrenciaServicoAplicacaoDTO> listaOcorrenciaServicoAplicacao = this.engine.listConvertion(OcorrenciaServicoAplicacaoDTO.class, listResultado,
				listRetorno);

		if (listaOcorrenciaServicoAplicacao != null && !listaOcorrenciaServicoAplicacao.isEmpty()) {
			OcorrenciaServicoAplicacaoDTO ocorrenciaServicoAplicacaoDesvinculada = listaOcorrenciaServicoAplicacao.iterator().next();
			ocorrenciaServicoAplicacaoDesvinculada.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoAplicacaoDesvinculada.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			this.create(ocorrenciaServicoAplicacaoDesvinculada);
		}
	}
}
