package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoAtributosFinanceirosDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoAtributosFinanceirosDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoAtributosFinanceirosDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoAtributosFinanceiros";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoAtributosFinanceiros", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idAtributosFinanceiros", "idAtributosFinanceirosOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("categoriaAtributosFinanceiros", "categoriaAtributosFinanceirosOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("tipoAtributosFinanceiros", "tipoAtributosFinanceirosOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("classificacaoAtributosFinan", "classificacaoAtributosFinanceirosOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("valorAtributosFinanceiros", "valorAtributosFinanceirosOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoAtributosFinanceirosDTO> getBean() {
		return OcorrenciaServicoAtributosFinanceirosDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoAtributosFinanceirosDTO> findOcorrenciaServicoAtributosFinanceirosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idOcorrenciaServicoAtributosFinanceiros"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoAtributosFinanceirosDTO> listaOcorrenciaServicoAtributosFinanceiros = (List<OcorrenciaServicoAtributosFinanceirosDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoAtributosFinanceiros != null && !listaOcorrenciaServicoAtributosFinanceiros.isEmpty()) {
			return listaOcorrenciaServicoAtributosFinanceiros;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos atributos financeiros
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do servio relacionado em que houve alguma ao
	 * @param atributosFinanceirosOcorrenciaServico
	 *            </br>
	 *            - acaoOcorrenciaServico (ver: {@link AuditoriaAcoes}) </br>
	 *            - Quando a ao for OcorrenciaServicoAcoes.Desvinculado deve
	 *            possuir todas as informaes do atributo financeiro
	 *            desvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoAtributosFinanceiros(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico,
			final AtributosFinanceirosDTO atributosFinanceirosOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		financeiroServico.idFinanceiroServico, ");
		sqlBuilder.append("		tipoFinanceiroServico.nomeTipo, ");
		sqlBuilder.append("		tipoFinanceiroServico.perfil, ");
		sqlBuilder.append("		financeiroServico.classificacao, ");
		sqlBuilder.append("		financeiroServico.valor ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico");
		sqlBuilder.append("		INNER JOIN financeiroServico financeiroServico");
		sqlBuilder.append("			ON financeiroServico.idServico = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN tipoFinanceiroServico tipoFinanceiroServico ");
		sqlBuilder.append("			ON tipoFinanceiroServico.idTipo = financeiroServico.idTipo ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		tipoFinanceiroServico.dataFim IS NULL ");
		sqlBuilder.append("		AND financeiroServico.dataFim IS NULL ");
		sqlBuilder.append("		AND ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("	ORDER BY tipoFinanceiroServico.nomeTipo ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("categoriaAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("tipoAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("classificacaoAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("valorAtributosFinanceirosOcorrenciaServico");

		List<OcorrenciaServicoAtributosFinanceirosDTO> listaOcorrenciaServicoAtributosFinanceiros = this.engine
				.listConvertion(OcorrenciaServicoAtributosFinanceirosDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoAtributosFinanceiros != null && !listaOcorrenciaServicoAtributosFinanceiros.isEmpty()) {
			for (OcorrenciaServicoAtributosFinanceirosDTO ocorrenciaServicoAtributosFinanceirosDTO : listaOcorrenciaServicoAtributosFinanceiros) {
				ocorrenciaServicoAtributosFinanceirosDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (atributosFinanceirosOcorrenciaServico != null && listaIdsOcorrenciaServico.contains(ocorrenciaServicoAtributosFinanceirosDTO.getIdAtributosFinanceirosOcorrenciaServico())) {
					ocorrenciaServicoAtributosFinanceirosDTO.setAcaoOcorrenciaServico(atributosFinanceirosOcorrenciaServico.getAcaoAtributosFinanceirosOcorrenciaServico());
				}
				this.create(ocorrenciaServicoAtributosFinanceirosDTO);
			}
		}

		if (atributosFinanceirosOcorrenciaServico != null
				&& AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(atributosFinanceirosOcorrenciaServico.getAcaoAtributosFinanceirosOcorrenciaServico())) {
			this.createOcorrenciaServicoAtributosFinanceirosDesvinculado(idOcorrenciaServico, atributosFinanceirosOcorrenciaServico);
		}
	}

	/**
	 * Cria a ocorrncia de servio do atributo financeiro desvinculado
	 * 
	 * @param idOcorrenciaServico
	 * @param atributosFinanceirosDTO
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoAtributosFinanceirosDesvinculado(final Integer idOcorrenciaServico, final AtributosFinanceirosDTO atributosFinanceirosDTO) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		financeiroServico.idFinanceiroServico, ");
		sqlBuilder.append("		tipoFinanceiroServico.nomeTipo, ");
		sqlBuilder.append("		tipoFinanceiroServico.perfil, ");
		sqlBuilder.append("		financeiroServico.classificacao, ");
		sqlBuilder.append("		financeiroServico.valor ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		financeiroServico financeiroServico");
		sqlBuilder.append("		INNER JOIN tipoFinanceiroServico tipoFinanceiroServico ");
		sqlBuilder.append("			ON tipoFinanceiroServico.idTipo = financeiroServico.idTipo ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		tipoFinanceiroServico.dataFim IS NULL ");
		sqlBuilder.append("		AND financeiroServico.idFinanceiroServico = ? ");
		sqlBuilder.append("	ORDER BY tipoFinanceiroServico.nomeTipo ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(atributosFinanceirosDTO.getIdFinanceiroServico());

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("categoriaAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("tipoAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("classificacaoAtributosFinanceirosOcorrenciaServico");
		listRetorno.add("valorAtributosFinanceirosOcorrenciaServico");

		List<OcorrenciaServicoAtributosFinanceirosDTO> listaOcorrenciaServicoAtributosFinanceirosDesvinculado = this.engine
				.listConvertion(OcorrenciaServicoAtributosFinanceirosDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoAtributosFinanceirosDesvinculado != null && !listaOcorrenciaServicoAtributosFinanceirosDesvinculado.isEmpty() && atributosFinanceirosDTO != null) {
			OcorrenciaServicoAtributosFinanceirosDTO ocorrenciaServicoAtributosFinanceirosDesvinculado = listaOcorrenciaServicoAtributosFinanceirosDesvinculado.iterator().next();
			ocorrenciaServicoAtributosFinanceirosDesvinculado.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoAtributosFinanceirosDesvinculado.setAcaoOcorrenciaServico(atributosFinanceirosDTO.getAcaoAtributosFinanceirosOcorrenciaServico());
			this.create(ocorrenciaServicoAtributosFinanceirosDesvinculado);
		}
	}

}
