package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoBaseConhecimentoDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoBaseConhecimentoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoBaseConhecim";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoBaseConhecimento", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idBaseConhecimento", "idBaseConhecimentoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeBaseConhecimento", "nomeBaseConhecimentoOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoBaseConhecimentoDTO> getBean() {
		return OcorrenciaServicoBaseConhecimentoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoBaseConhecimentoDTO> findOcorrenciaServicoBaseConhecimentoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoBaseConhecimento"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoBaseConhecimentoDTO> listaOcorrenciaServicoBaseConhecimento = (List<OcorrenciaServicoBaseConhecimentoDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoBaseConhecimento != null && !listaOcorrenciaServicoBaseConhecimento.isEmpty()) {
			return listaOcorrenciaServicoBaseConhecimento;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio da base de conhecimento
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do conhecimento em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoBaseConhecimento(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		baseConhecimento.idBaseConhecimento, ");
		sqlBuilder.append("		baseConhecimento.titulo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN servicoBaseConhecimento servicoBaseConhecimento ");
		sqlBuilder.append("			ON servicoBaseConhecimento.idServico = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN baseConhecimento baseConhecimento ");
		sqlBuilder.append("			ON baseConhecimento.idBaseConhecimento = servicoBaseConhecimento.idBaseConhecimento ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("	ORDER BY baseConhecimento.idBaseConhecimento ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idBaseConhecimentoOcorrenciaServico");
		listRetorno.add("nomeBaseConhecimentoOcorrenciaServico");

		List<OcorrenciaServicoBaseConhecimentoDTO> listaOcorrenciaServicoBaseConhecimento = this.engine
				.listConvertion(OcorrenciaServicoBaseConhecimentoDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoBaseConhecimento != null && !listaOcorrenciaServicoBaseConhecimento.isEmpty()) {
			for (OcorrenciaServicoBaseConhecimentoDTO ocorrenciaServicoBaseConhecimentoDTO : listaOcorrenciaServicoBaseConhecimento) {
				ocorrenciaServicoBaseConhecimentoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!listaIdsOcorrenciaServico.isEmpty() && !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoBaseConhecimentoDTO.getIdBaseConhecimentoOcorrenciaServico())) {
					ocorrenciaServicoBaseConhecimentoDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				this.create(ocorrenciaServicoBaseConhecimentoDTO);
			}
		}

		if (!listaIdsOcorrenciaServico.isEmpty() && AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)) {
			this.createOcorrenciaServicoBaseConhecimentoDesvinculado(idOcorrenciaServico, listaIdsOcorrenciaServico.get(0));
		}
	}

	/**
	 * Cria a ocorrncia de servio do conhecimento desvinculado
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param idBaseConhecimentoDesvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoBaseConhecimentoDesvinculado(final Integer idOcorrenciaServico, final Integer idBaseConhecimentoDesvinculado) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		baseConhecimento.idBaseConhecimento, ");
		sqlBuilder.append("		baseConhecimento.titulo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		baseConhecimento baseConhecimento ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		baseConhecimento.idBaseConhecimento = ? ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idBaseConhecimentoDesvinculado);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idBaseConhecimentoOcorrenciaServico");
		listRetorno.add("nomeBaseConhecimentoOcorrenciaServico");

		List<OcorrenciaServicoBaseConhecimentoDTO> listaOcorrenciaServicoBaseConhecimento = this.engine
				.listConvertion(OcorrenciaServicoBaseConhecimentoDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoBaseConhecimento != null && !listaOcorrenciaServicoBaseConhecimento.isEmpty()) {
			OcorrenciaServicoBaseConhecimentoDTO ocorrenciaServicoBaseConhecimentoDTO = listaOcorrenciaServicoBaseConhecimento.iterator().next();
			ocorrenciaServicoBaseConhecimentoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoBaseConhecimentoDTO.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			this.create(ocorrenciaServicoBaseConhecimentoDTO);
		}
	}

}
