package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoCapacidadeDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoCapacidadeDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoCapacidadeDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "ocorrenciaservicocapacidade";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idOcorrenciaServicoCapacidade", "idOcorrenciaServicoCapacidade", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nome", "nome", false, false, false, false));
		listFields.add(new Field("valor", "valor", false, false, false, false));
		return listFields;
	}

	@Override
	public Class<?> getBean() {
		return OcorrenciaServicoCapacidadeDTO.class;
	}

	public List<OcorrenciaServicoCapacidadeDTO> getCapacidadeByIdOcorrenciaServico(Integer idOcorrenciaServico) throws Exception {
		try {
			List<Condition> condicao = new ArrayList<Condition>();
			List<Order> ordenacao = new ArrayList<Order>();

			condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
			ordenacao.add(new Order("idOcorrenciaServicoCapacidade"));

			List<OcorrenciaServicoCapacidadeDTO> lista = (List<OcorrenciaServicoCapacidadeDTO>) super.findByCondition(condicao, ordenacao);

			if (lista != null && !lista.isEmpty()) {
				return lista;
			}

			return null;
		} catch (Exception e) {
			throw e;
		}
	}

}
