package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoCasoNegocioDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoCasoNegocioDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoCasoNegocioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoCasoNegocio";
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("id", "idOcorrenciaServicoCasoNegocio", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeCasoNegocio", "nomeCasoNegocio", false, false, false, false));
		listFields.add(new Field("descricaoSumarioExecutivo", "descricaoSumarioExecutivo", false, false, false, false));
		listFields.add(new Field("descricaoCenarios", "descricaoCenarios", false, false, false, false));
		listFields.add(new Field("descricaoProblemaOportunidade", "descricaoProblemaOportunidade", false, false, false, false));
		listFields.add(new Field("descricaoPropostaSolucao", "descricaoPropostaSolucao", false, false, false, false));
		listFields.add(new Field("descricaoAnaliseFinanceira", "descricaoAnaliseFinanceira", false, false, false, false));
		listFields.add(new Field("descricaoAnaliseRisco", "descricaoAnaliseRisco", false, false, false, false));
		listFields.add(new Field("descricaoStakeholderEntidade", "descricaoStakeholderEntidade", false, false, false, false));
		listFields.add(new Field("descricaoViabilidadeTecnica", "descricaoViabilidadeTecnica", false, false, false, false));
		listFields.add(new Field("descricaoConclusao", "descricaoConclusao", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoCasoNegocioDTO> getBean() {
		return OcorrenciaServicoCasoNegocioDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	@SuppressWarnings("unchecked")
	public OcorrenciaServicoCasoNegocioDTO findOcorrenciaServicoCasoNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idOcorrenciaServicoCasoNegocio"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoCasoNegocioDTO> listaOcorrenciaServicoCasoNegocio = (List<OcorrenciaServicoCasoNegocioDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoCasoNegocio != null && !listaOcorrenciaServicoCasoNegocio.isEmpty()) {
			return (OcorrenciaServicoCasoNegocioDTO) listaOcorrenciaServicoCasoNegocio.iterator().next();
		}

		return null;
	}
}
