package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoContratoDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

public class OcorrenciaServicoContratoDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoContratoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoContrato";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoContrato", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idContrato", "idContratoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("descricaoContrato", "descricaoContratoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("clienteContrato", "clienteContratoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("fornecedorContrato", "fornecedorContratoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoContratoDTO> getBean() {
		return OcorrenciaServicoContratoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoContratoDTO> findOcorrenciaServicoContratoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoContrato"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoContratoDTO> listaOcorrenciaServicoContrato = (List<OcorrenciaServicoContratoDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoContrato != null && !listaOcorrenciaServicoContrato.isEmpty()) {
			return listaOcorrenciaServicoContrato;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos contratos
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do processo negcio em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoContrato(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append(" SELECT ");
		sqlBuilder.append("		contratos.idContrato, ");
		sqlBuilder.append(" 	contratos.numero, ");
		sqlBuilder.append(" 	clientes.nomeRazaoSocial, ");
		sqlBuilder.append(" 	fornecedor.razaoSocial ");
		sqlBuilder.append(" FROM ");
		sqlBuilder.append(" 	ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append(" 	INNER JOIN servicoContrato servicoContrato ");
		sqlBuilder.append("     	ON ocorrenciaServico.idServico = servicoContrato.idServico ");
		sqlBuilder.append("     INNER JOIN contratos contratos ");
		sqlBuilder.append("     	ON contratos.idContrato = servicoContrato.idContrato ");
		sqlBuilder.append("     INNER JOIN clientes clientes ");
		sqlBuilder.append("     	ON clientes.idCliente = contratos.idCliente ");
		sqlBuilder.append("     INNER JOIN fornecedor fornecedor ");
		sqlBuilder.append("     	ON fornecedor.idFornecedor = contratos.idFornecedor ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append(" 	ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append(" 	AND (contratos.deleted IS NULL OR UPPER(contratos.deleted) <> UPPER('Y')) ");
		sqlBuilder.append(" 	AND (servicoContrato.deleted IS NULL OR UPPER(servicoContrato.deleted) <> UPPER('Y')) ");
		sqlBuilder.append(" 	AND (servicoContrato.dataFim IS NULL OR servicoContrato.dataFim > ?) ");
		sqlBuilder.append(" 	AND (contratos.dataFimContrato IS NULL OR contratos.dataFimContrato > ?) ");
		sqlBuilder.append(" 	AND UPPER(contratos.situacao) = UPPER('A') ");
		sqlBuilder.append(" ORDER  BY contratos.idContrato ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);
		listParametro.add(UtilDatas.getDataAtual());
		listParametro.add(UtilDatas.getDataAtual());

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idContratoOcorrenciaServico");
		listRetorno.add("descricaoContratoOcorrenciaServico");
		listRetorno.add("clienteContratoOcorrenciaServico");
		listRetorno.add("fornecedorContratoOcorrenciaServico");

		List<OcorrenciaServicoContratoDTO> listaOcorrenciaServicoContrato = this.engine.listConvertion(OcorrenciaServicoContratoDTO.class, listResultado,
				listRetorno);

		if (listaOcorrenciaServicoContrato != null && !listaOcorrenciaServicoContrato.isEmpty()) {
			for (OcorrenciaServicoContratoDTO ocorrenciaServicoContratoDTO : listaOcorrenciaServicoContrato) {
				ocorrenciaServicoContratoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!acaoOcorrenciaServico.equals(AuditoriaAcoes.DESVINCULADO.getIdentificador()) && !listaIdsOcorrenciaServico.isEmpty()
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoContratoDTO.getIdContratoOcorrenciaServico())) {
					ocorrenciaServicoContratoDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				this.create(ocorrenciaServicoContratoDTO);
			}
		}

		if (acaoOcorrenciaServico.equals(AuditoriaAcoes.DESVINCULADO.getIdentificador()) && !listaIdsOcorrenciaServico.isEmpty()) {
			createOcorrenciaServicoContratoDesvinculado(idOcorrenciaServico, listaIdsOcorrenciaServico.iterator().next());
		}

	}

	/**
	 * Cria a ocorrncia de servio dos contratos desvinculados
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param idServicoContrato
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoContratoDesvinculado(final Integer idOcorrenciaServico, Integer idServicoContrato) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append(" SELECT ");
		sqlBuilder.append("		contratos.idContrato, ");
		sqlBuilder.append(" 	contratos.numero, ");
		sqlBuilder.append(" 	clientes.nomeRazaoSocial, ");
		sqlBuilder.append(" 	fornecedor.razaoSocial ");
		sqlBuilder.append(" FROM ");
		sqlBuilder.append(" 	servicoContrato servicoContrato ");
		sqlBuilder.append("     INNER JOIN contratos contratos ");
		sqlBuilder.append("     	ON contratos.idContrato = servicoContrato.idContrato ");
		sqlBuilder.append("     INNER JOIN clientes clientes ");
		sqlBuilder.append("     	ON clientes.idCliente = contratos.idCliente ");
		sqlBuilder.append("     INNER JOIN fornecedor fornecedor ");
		sqlBuilder.append("     	ON fornecedor.idFornecedor = contratos.idFornecedor ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append(" 	servicoContrato.idServicoContrato = ? ");
		sqlBuilder.append(" ORDER  BY contratos.idContrato ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idServicoContrato);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idContratoOcorrenciaServico");
		listRetorno.add("descricaoContratoOcorrenciaServico");
		listRetorno.add("clienteContratoOcorrenciaServico");
		listRetorno.add("fornecedorContratoOcorrenciaServico");

		List<OcorrenciaServicoContratoDTO> listaOcorrenciaServicoContratoDesvinculado = this.engine.listConvertion(OcorrenciaServicoContratoDTO.class,
				listResultado, listRetorno);

		if (listaOcorrenciaServicoContratoDesvinculado != null && !listaOcorrenciaServicoContratoDesvinculado.isEmpty()) {
			OcorrenciaServicoContratoDTO ocorrenciaServicoContratoDesvinculado = listaOcorrenciaServicoContratoDesvinculado.iterator().next();
			ocorrenciaServicoContratoDesvinculado.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoContratoDesvinculado.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			this.create(ocorrenciaServicoContratoDesvinculado);
		}

	}
}
