package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioOcorrenciasServicoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServico";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", true, true, false, false));
		listFields.add(new Field("idServico", "idServico", false, false, false, false));
		listFields.add(new Field("nomeUsuario", "nomeUsuario", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("categoriaOcorrencia", "categoriaOcorrencia", false, false, false, false));
		listFields.add(new Field("tipoOcorrencia", "tipoOcorrencia", false, false, false, false));
		listFields.add(new Field("descricaoOcorrencia", "descricaoOcorrencia", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoDTO> getBean() {
		return OcorrenciaServicoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	@SuppressWarnings("unchecked")
	public Page<OcorrenciaServicoDTO> listOcorrenciasServico(GerenciamentoPortfolioOcorrenciasServicoDTO gerenciamentoPortfolioCadastroServicoDTO, Pageable pageable, Boolean isTotalizacao)
			throws PersistenceException {
		Page<OcorrenciaServicoDTO> taskPage;

		StringBuilder selectQueryPiece = new StringBuilder("SELECT ");
		selectQueryPiece.append("	ocorrenciaServico.idOcorrenciaServico, ");
		selectQueryPiece.append("	ocorrenciaServico.idServico, ");
		selectQueryPiece.append("	ocorrenciaServico.nomeUsuario, ");
		selectQueryPiece.append("	ocorrenciaServico.dataCriacao, ");
		selectQueryPiece.append("	ocorrenciaServico.categoriaOcorrencia, ");
		selectQueryPiece.append("	ocorrenciaServico.tipoOcorrencia, ");
		selectQueryPiece.append("	ocorrenciaServico.descricaoOcorrencia ");

		StringBuilder orderBy = new StringBuilder("ORDER BY ocorrenciaServico.idOcorrenciaServico DESC ");

		StringBuilder fromWhereQueryPiece = new StringBuilder("FROM ");
		fromWhereQueryPiece.append("	OcorrenciaServico ocorrenciaServico ");
		fromWhereQueryPiece.append("WHERE ");
		fromWhereQueryPiece.append(" 	ocorrenciaServico.idServico = " + gerenciamentoPortfolioCadastroServicoDTO.getIdServico() + " ");

		if (gerenciamentoPortfolioCadastroServicoDTO.getCategoriaFiltroOcorrenciaServico() != null && !gerenciamentoPortfolioCadastroServicoDTO.getCategoriaFiltroOcorrenciaServico().isEmpty()) {
			fromWhereQueryPiece.append("AND UPPER(ocorrenciaServico.categoriaOcorrencia) = UPPER('" + gerenciamentoPortfolioCadastroServicoDTO.getCategoriaFiltroOcorrenciaServico() + "') ");
		}

		if (gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroInicioOcorrenciaServico() != null && gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroFimOcorrenciaServico() != null) {
			fromWhereQueryPiece.append("AND ocorrenciaServico.dataCriacao ");
			fromWhereQueryPiece.append("	BETWEEN '" + gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroInicioOcorrenciaServico() + "' ");
			fromWhereQueryPiece.append("	AND '" + gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroFimOcorrenciaServico() + "' ");
		} else if (gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroInicioOcorrenciaServico() != null) {
			fromWhereQueryPiece.append("AND ocorrenciaServico.dataCriacao >= '" + gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroInicioOcorrenciaServico() + "' ");
		} else if (gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroFimOcorrenciaServico() != null) {
			fromWhereQueryPiece.append("AND ocorrenciaServico.dataCriacao <= '" + gerenciamentoPortfolioCadastroServicoDTO.getDataFiltroFimOcorrenciaServico() + "' ");
		}

		String sql = "";
		List<Object> lista = new ArrayList<Object>();
		if (isTotalizacao) {
			final StringBuilder sqlCount = this.countQueryPiece(fromWhereQueryPiece);
			final Long totalElements = this.countElements(sqlCount.toString(), null);
			final List<OcorrenciaServicoDTO> result = new ArrayList<OcorrenciaServicoDTO>();
			taskPage = this.makePage(result, pageable, totalElements);

		} else {
			if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
				sql = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, selectQueryPiece.toString(), orderBy.toString(), fromWhereQueryPiece.toString());
			} else {
				selectQueryPiece.append(fromWhereQueryPiece);
				selectQueryPiece.append(orderBy);
				sql = PagingQueryUtil.concatPagingPieceOnQuery(pageable, selectQueryPiece.toString(), MAIN_SGBD);
			}

			lista = this.execSQL(sql, null);

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idOcorrenciaServico");
			listRetorno.add("idServico");
			listRetorno.add("nomeUsuario");
			listRetorno.add("dataCriacao");
			listRetorno.add("categoriaOcorrencia");
			listRetorno.add("tipoOcorrencia");
			listRetorno.add("descricaoOcorrencia");

			List<OcorrenciaServicoDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
			taskPage = new PageImpl<OcorrenciaServicoDTO>(result, pageable, 1L);
		}

		return taskPage;
	}

}
