package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.MapaNegocioItemDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDesenhoMapaServicoDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.TipoItemMapaServico;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class OcorrenciaServicoDesenhoMapaServicoDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoDesenhoMapaServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoMapaServico";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoDesenhoMapaServico", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idItemMapaServico", "idItemMapaServicoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("iconeItemMapaServico", "iconeItemMapaServicoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeItemMapaServico", "nomeItemMapaServicoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("tipoItemMapaServico", "tipoItemMapaServicoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoDesenhoMapaServicoDTO> getBean() {
		return OcorrenciaServicoDesenhoMapaServicoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoDesenhoMapaServicoDTO> findOcorrenciaServicoDesenhoMapaServicoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoDesenhoMapaServico"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoDesenhoMapaServicoDTO> listaOcorrenciaServicoDesenhoMapaServico = (List<OcorrenciaServicoDesenhoMapaServicoDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoDesenhoMapaServico != null && !listaOcorrenciaServicoDesenhoMapaServico.isEmpty()) {
			return listaOcorrenciaServicoDesenhoMapaServico;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio do desenho do mapa de servio
	 * 
	 * @param idOcorrenciaServico
	 * @param itemMapaNegocio
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoDesenhoMapaServico(final Integer idOcorrenciaServico, final MapaNegocioItemDTO itemMapaNegocio, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		mapaNegocioItem.idMapaNegocioItem AS id, ");
		sqlBuilder.append("		mapaNegocioItem.icone, ");
		sqlBuilder.append("		servico.nomeServico AS nome, ");
		sqlBuilder.append("		COALESCE(mapaNegocioItem.idServicoApoio, -1) ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN mapaNegocioItem mapaNegocioItem ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = mapaNegocioItem.idServicoNegocio ");
		sqlBuilder.append("		INNER JOIN servico servico ");
		sqlBuilder.append("			ON servico.idServico =  mapaNegocioItem.idServicoApoio ");
		sqlBuilder.append("	UNION ");
		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		mapaNegocioItem.idMapaNegocioItem AS id, ");
		sqlBuilder.append("		mapaNegocioItem.icone, ");
		sqlBuilder.append("		itemConfiguracao.nome AS nome, ");
		sqlBuilder.append("		COALESCE(mapaNegocioItem.idServicoApoio, -1) ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN mapaNegocioItem mapaNegocioItem ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = mapaNegocioItem.idServicoNegocio ");
		sqlBuilder.append("		INNER JOIN itemConfiguracao itemConfiguracao ");
		sqlBuilder.append("			ON itemConfiguracao.idItemConfiguracao = mapaNegocioItem.idItemConfiguracao ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("	ORDER  BY id ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idItemMapaServicoOcorrenciaServico");
		listRetorno.add("iconeItemMapaServicoOcorrenciaServico");
		listRetorno.add("nomeItemMapaServicoOcorrenciaServico");
		listRetorno.add("idTipoItemMapaServico");

		List<OcorrenciaServicoDesenhoMapaServicoDTO> listaOcorrenciaServicoDesenhoMapaServico = this.engine
				.listConvertion(OcorrenciaServicoDesenhoMapaServicoDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoDesenhoMapaServico != null && !listaOcorrenciaServicoDesenhoMapaServico.isEmpty() && itemMapaNegocio != null) {
			for (OcorrenciaServicoDesenhoMapaServicoDTO ocorrenciaServicoDesenhoMapaServicoDTO : listaOcorrenciaServicoDesenhoMapaServico) {
				ocorrenciaServicoDesenhoMapaServicoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())
						&& itemMapaNegocio.getIdMapaNegocioItem().equals(ocorrenciaServicoDesenhoMapaServicoDTO.getIdItemMapaServicoOcorrenciaServico())) {
					ocorrenciaServicoDesenhoMapaServicoDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				if (ocorrenciaServicoDesenhoMapaServicoDTO.getIdTipoItemMapaServico() > 0) {
					ocorrenciaServicoDesenhoMapaServicoDTO.setTipoItemMapaServicoOcorrenciaServico(TipoItemMapaServico.SERVICO_APOIO.getIdentificador());
				} else {
					ocorrenciaServicoDesenhoMapaServicoDTO.setTipoItemMapaServicoOcorrenciaServico(TipoItemMapaServico.ITEM_CONFIGURACAO.getIdentificador());
				}
				this.create(ocorrenciaServicoDesenhoMapaServicoDTO);
			}
		}

		if (acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) && itemMapaNegocio != null) {
			this.createOcorrenciaServicoDesenhoMapaServicoRemovido(idOcorrenciaServico, itemMapaNegocio);
		}

	}

	/**
	 * Cria a ocorrncia de servio do desenho do mapa de servio removido
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoItemMapaServico
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param itemMapaNegocio
	 *            item do mapa de negcio removido
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoDesenhoMapaServicoRemovido(final Integer idOcorrenciaServico, final MapaNegocioItemDTO itemMapaNegocio) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();
		List<Object> listParametro = new ArrayList<Object>();

		if (itemMapaNegocio.getIdServicoApoio() != null) {
			sqlBuilder.append("	SELECT ");
			sqlBuilder.append("		servico.nomeServico AS nome ");
			sqlBuilder.append("	FROM ");
			sqlBuilder.append("		servico servico ");
			sqlBuilder.append("	WHERE ");
			sqlBuilder.append("		servico.idServico = ? ");

			listParametro.add(itemMapaNegocio.getIdServicoApoio());

		} else if (itemMapaNegocio.getIdItemConfiguracao() != null) {
			sqlBuilder.append("	SELECT ");
			sqlBuilder.append("		itemConfiguracao.nome AS nome ");
			sqlBuilder.append("	FROM ");
			sqlBuilder.append("		itemConfiguracao itemConfiguracao ");
			sqlBuilder.append("	WHERE ");
			sqlBuilder.append("		itemConfiguracao.idItemConfiguracao = ? ");

			listParametro.add(itemMapaNegocio.getIdItemConfiguracao());

		}

		if (UtilStrings.isNotVazio(sqlBuilder.toString())) {
			listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("nomeItemMapaServicoOcorrenciaServico");

			List<OcorrenciaServicoDesenhoMapaServicoDTO> listaOcorrenciaServicoDesenhoMapaServicoRemovido = this.engine
					.listConvertion(OcorrenciaServicoDesenhoMapaServicoDTO.class, listResultado, listRetorno);

			if (listaOcorrenciaServicoDesenhoMapaServicoRemovido != null && !listaOcorrenciaServicoDesenhoMapaServicoRemovido.isEmpty()) {
				String tipoItemMapaNegocio = itemMapaNegocio.getIdServicoApoio() != null ? TipoItemMapaServico.SERVICO_APOIO.getIdentificador()
						: TipoItemMapaServico.ITEM_CONFIGURACAO.getIdentificador();
				OcorrenciaServicoDesenhoMapaServicoDTO ocorrenciaServicoDesenhoMapaServicoDTO = listaOcorrenciaServicoDesenhoMapaServicoRemovido.iterator().next();
				ocorrenciaServicoDesenhoMapaServicoDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				ocorrenciaServicoDesenhoMapaServicoDTO.setAcaoOcorrenciaServico(AuditoriaAcoes.REMOVIDO.getIdentificador());
				ocorrenciaServicoDesenhoMapaServicoDTO.setIdItemMapaServicoOcorrenciaServico(itemMapaNegocio.getIdMapaNegocioItem());
				ocorrenciaServicoDesenhoMapaServicoDTO.setIconeItemMapaServicoOcorrenciaServico(itemMapaNegocio.getIcone());
				ocorrenciaServicoDesenhoMapaServicoDTO.setTipoItemMapaServicoOcorrenciaServico(tipoItemMapaNegocio);
				this.create(ocorrenciaServicoDesenhoMapaServicoDTO);
			}
		}
	}

}
