package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoDetalhesDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoDetalhesDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoDetalhesDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoDetalhes";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoDetalhes", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeServico", "nomeServico", false, false, false, false));
		listFields.add(new Field("nomeCategoriaServico", "nomeCategoriaServico", false, false, false, false));
		listFields.add(new Field("faseServico", "faseServico", false, false, false, false));
		listFields.add(new Field("tipoDeInvestimento", "tipoDeInvestimento", false, false, false, false));
		listFields.add(new Field("nomeTipoServico", "nomeTipoServico", false, false, false, false));
		listFields.add(new Field("detalheServico", "detalheServico", false, false, false, false));
		listFields.add(new Field("processoDeIniciacao", "processoDeIniciacao", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("statusServico", "statusServico", false, false, false, false));
		listFields.add(new Field("nomeImportanciaNegocio", "nomeImportanciaNegocio", false, false, false, false));
		listFields.add(new Field("nomeLocalExecucaoServico", "nomeLocalExecucaoServico", false, false, false, false));
		listFields.add(new Field("objetivo", "objetivo", false, false, false, false));
		listFields.add(new Field("nomeTemplateServico", "nomeTemplateServico", false, false, false, false));
		listFields.add(new Field("valoresDoServico", "valoresDoServico", false, false, false, false));
		listFields.add(new Field("criticidadeServico", "criticidadeServico", false, false, false, false));
		listFields.add(new Field("demandaServico", "demandaServico", false, false, false, false));
		listFields.add(new Field("retornoFinanceiroServico", "retornoFinanceiroServico", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoDetalhesDTO> getBean() {
		return OcorrenciaServicoDetalhesDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	@SuppressWarnings("unchecked")
	public OcorrenciaServicoDetalhesDTO findOcorrenciaServicoDetalhesByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idOcorrenciaServicoDetalhes"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoDetalhesDTO> listaOcorrenciaServicoDetalhes = (List<OcorrenciaServicoDetalhesDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoDetalhes != null && !listaOcorrenciaServicoDetalhes.isEmpty()) {
			return listaOcorrenciaServicoDetalhes.iterator().next();
		}

		return null;
	}

	/**
	 * Cria os detalhes do servio da ocorrncia de servio do tipo Detalhes
	 * 
	 * @param idOcorrenciaServico
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	@SuppressWarnings("unchecked")
	public OcorrenciaServicoDetalhesDTO createOcorrenciaServicoDetalhes(final Integer idOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();
		OcorrenciaServicoDetalhesDTO ocorrenciaServicoDetalhesDTO = new OcorrenciaServicoDetalhesDTO();

		sqlBuilder.append("SELECT ");
		sqlBuilder.append("		servico.nomeServico, ");
		sqlBuilder.append("		categoriaServico.nomeCategoriaServico, ");
		sqlBuilder.append("		servico.faseServico, ");
		sqlBuilder.append("		servico.tipoDeInvestimento, ");
		sqlBuilder.append("		tipoServico.nomeTipoServico, ");
		sqlBuilder.append("		servico.detalheServico, ");
		sqlBuilder.append("		servico.processoDeIniciacao, ");
		sqlBuilder.append("		servico.dataInicio, ");
		sqlBuilder.append("		servico.statusServico, ");
		sqlBuilder.append("		importanciaNegocio.nomeImportanciaNegocio, ");
		sqlBuilder.append("		localExecucaoServico.nomeLocalExecucaoServico, ");
		sqlBuilder.append("		servico.objetivo, ");
		sqlBuilder.append("		templateServico.nomeTemplate, ");
		sqlBuilder.append("		servico.valoresDoServico, ");
		sqlBuilder.append("		servico.criticidadeServico, ");
		sqlBuilder.append("		servico.demandaServico, ");
		sqlBuilder.append("		servico.retornoFinanceiroServico, ");
		sqlBuilder.append("		servico.deleted ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico");
		sqlBuilder.append("		INNER JOIN");
		sqlBuilder.append("		servico servico ");
		sqlBuilder.append("		ON servico.idServico = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN");
		sqlBuilder.append("		categoriaservico categoriaServico ");
		sqlBuilder.append("		ON servico.idCategoriaServico = categoriaServico.idCategoriaServico ");
		sqlBuilder.append("		LEFT JOIN");
		sqlBuilder.append("		tipoServico tipoServico ");
		sqlBuilder.append("		ON servico.idTipoServico = tipoServico.idTipoServico ");
		sqlBuilder.append("		LEFT JOIN");
		sqlBuilder.append("		importanciaNegocio importanciaNegocio ");
		sqlBuilder.append("		ON servico.idImportanciaNegocio = importanciaNegocio.idImportanciaNegocio ");
		sqlBuilder.append("		LEFT JOIN");
		sqlBuilder.append("		localExecucaoServico localExecucaoServico ");
		sqlBuilder.append("		ON servico.idLocalExecucaoServico = localExecucaoServico.idLocalExecucaoServico ");
		sqlBuilder.append("		LEFT JOIN");
		sqlBuilder.append("		templateServico templateServico ");
		sqlBuilder.append("		ON servico.idTemplateServico = templateServico.idTemplateServico ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("nomeServico");
		listRetorno.add("nomeCategoriaServico");
		listRetorno.add("faseServico");
		listRetorno.add("tipoDeInvestimento");
		listRetorno.add("nomeTipoServico");
		listRetorno.add("detalheServico");
		listRetorno.add("processoDeIniciacao");
		listRetorno.add("dataInicio");
		listRetorno.add("statusServico");
		listRetorno.add("nomeImportanciaNegocio");
		listRetorno.add("nomeLocalExecucaoServico");
		listRetorno.add("objetivo");
		listRetorno.add("nomeTemplateServico");
		listRetorno.add("valoresDoServico");
		listRetorno.add("criticidadeServico");
		listRetorno.add("demandaServico");
		listRetorno.add("retornoFinanceiroServico");
		listRetorno.add("deleted");

		List<OcorrenciaServicoDetalhesDTO> listaOcorrenciaServicoDetalhes = this.engine.listConvertion(OcorrenciaServicoDetalhesDTO.class, listResultado,
				listRetorno);

		if (listaOcorrenciaServicoDetalhes != null && !listaOcorrenciaServicoDetalhes.isEmpty()) {
			ocorrenciaServicoDetalhesDTO = listaOcorrenciaServicoDetalhes.iterator().next();
		}

		if (ocorrenciaServicoDetalhesDTO != null) {
			ocorrenciaServicoDetalhesDTO.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoDetalhesDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
			this.create(ocorrenciaServicoDetalhesDTO);
			return ocorrenciaServicoDetalhesDTO;
		}

		return null;
	}

}
