package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoEsquemaDadosDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoEsquemaDadosDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoEsquemaDadosDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoEsquemaDados";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoEsquemaDados", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idEsquemaDados", "idEsquemaDadosOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("detalhesEsquemaDados", "detalhesEsquemaDadosOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoEsquemaDadosDTO> getBean() {
		return OcorrenciaServicoEsquemaDadosDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoEsquemaDadosDTO> findOcorrenciaServicoEsquemaDadosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoEsquemaDados"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoEsquemaDadosDTO> listaOcorrenciaServicoEsquemaDados = (List<OcorrenciaServicoEsquemaDadosDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoEsquemaDados != null && !listaOcorrenciaServicoEsquemaDados.isEmpty()) {
			return listaOcorrenciaServicoEsquemaDados;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos esquemas de dados
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoEsquemaDados(final Integer idOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append(" SELECT ");
		sqlBuilder.append("		esquemaDados.idEsquemaDados, ");
		sqlBuilder.append(" 	esquemaDados.detalhes ");
		sqlBuilder.append(" FROM ");
		sqlBuilder.append(" 	ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append(" 	INNER JOIN esquemaDados esquemaDados  ");
		sqlBuilder.append("     	ON ocorrenciaServico.idServico = esquemaDados.idServicoNegocio ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append(" 	ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append(" 	AND esquemaDados.dataFim IS NULL ");
		sqlBuilder.append(" ORDER  BY esquemaDados.idEsquemaDados ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idEsquemaDadosOcorrenciaServico");
		listRetorno.add("detalhesEsquemaDadosOcorrenciaServico");

		List<OcorrenciaServicoEsquemaDadosDTO> listaOcorrenciaServicoEsquemaDados = this.engine.listConvertion(OcorrenciaServicoEsquemaDadosDTO.class,
				listResultado, listRetorno);

		if (listaOcorrenciaServicoEsquemaDados != null && !listaOcorrenciaServicoEsquemaDados.isEmpty()) {
			for (OcorrenciaServicoEsquemaDadosDTO ocorrenciaServicoEsquemaDadosDTO : listaOcorrenciaServicoEsquemaDados) {
				ocorrenciaServicoEsquemaDadosDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				ocorrenciaServicoEsquemaDadosDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				this.create(ocorrenciaServicoEsquemaDadosDTO);
			}
		}

	}
}
