package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoHabilidadeDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoHabilidadeDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoHabilidadeDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoHabilidade";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoHabilidade", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idHabilidade", "idHabilidadeOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeHabilidade", "nomeHabilidadeOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoHabilidadeDTO> getBean() {
		return OcorrenciaServicoHabilidadeDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoHabilidadeDTO> findOcorrenciaServicoHabilidadeByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoHabilidade"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoHabilidadeDTO> listaOcorrenciaServicoHabilidade = (List<OcorrenciaServicoHabilidadeDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoHabilidade != null && !listaOcorrenciaServicoHabilidade.isEmpty()) {
			return listaOcorrenciaServicoHabilidade;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio das habilidades
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids da habilidade em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoHabilidade(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		habilidade.idHabilidade, ");
		sqlBuilder.append("		habilidade.nomeHabilidade ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN habilidadeServico habilidadeServico ");
		sqlBuilder.append("			ON habilidadeServico.idServico = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN habilidade habilidade ");
		sqlBuilder.append("			ON habilidade.idHabilidade = habilidadeServico.idHabilidade ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND habilidade.dataHoraFim IS NULL ");
		sqlBuilder.append("	ORDER BY habilidade.idHabilidade ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idHabilidadeOcorrenciaServico");
		listRetorno.add("nomeHabilidadeOcorrenciaServico");

		List<OcorrenciaServicoHabilidadeDTO> listaOcorrenciaServicoHabilidade = this.engine.listConvertion(OcorrenciaServicoHabilidadeDTO.class, listResultado,
				listRetorno);

		if (listaOcorrenciaServicoHabilidade != null && !listaOcorrenciaServicoHabilidade.isEmpty()) {
			for (OcorrenciaServicoHabilidadeDTO ocorrenciaServicoHabilidadeDTO : listaOcorrenciaServicoHabilidade) {
				ocorrenciaServicoHabilidadeDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!listaIdsOcorrenciaServico.isEmpty() && !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoHabilidadeDTO.getIdHabilidadeOcorrenciaServico())) {
					ocorrenciaServicoHabilidadeDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				this.create(ocorrenciaServicoHabilidadeDTO);
			}
		}

		if (!listaIdsOcorrenciaServico.isEmpty() && AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)) {
			this.createOcorrenciaServicoHabilidadeDesvinculado(idOcorrenciaServico, listaIdsOcorrenciaServico.get(0));
		}
	}

	/**
	 * Cria a ocorrncia de servio da habilidade desvinculada
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param idHabilidadeDesvinculada
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoHabilidadeDesvinculado(final Integer idOcorrenciaServico, final Integer idHabilidadeDesvinculada) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		habilidade.idHabilidade, ");
		sqlBuilder.append("		habilidade.nomeHabilidade ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		habilidade habilidade ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		habilidade.idHabilidade = ? ");
		sqlBuilder.append("	ORDER BY habilidade.idHabilidade ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idHabilidadeDesvinculada);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idHabilidadeOcorrenciaServico");
		listRetorno.add("nomeHabilidadeOcorrenciaServico");

		List<OcorrenciaServicoHabilidadeDTO> listaOcorrenciaServicoHabilidade = this.engine.listConvertion(OcorrenciaServicoHabilidadeDTO.class, listResultado,
				listRetorno);

		if (listaOcorrenciaServicoHabilidade != null && !listaOcorrenciaServicoHabilidade.isEmpty()) {
			OcorrenciaServicoHabilidadeDTO ocorrenciaServicoHabilidadeDTO = listaOcorrenciaServicoHabilidade.iterator().next();
			ocorrenciaServicoHabilidadeDTO.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoHabilidadeDTO.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			this.create(ocorrenciaServicoHabilidadeDTO);
		}
	}
}
