package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoProcessoNegocioDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoProcessoNegocioDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoProcessoNegocioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoProcessoNegocio";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoProcessoNegocio", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idProcessoNegocio", "idProcessoNegocioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeProcessoNegocio", "nomeProcessoNegocioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeCliente", "nomeCliente", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoProcessoNegocioDTO> getBean() {
		return OcorrenciaServicoProcessoNegocioDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoProcessoNegocioDTO> findOcorrenciaServicoProcessoNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoProcessoNegocio"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoProcessoNegocioDTO> listaOcorrenciaServicoProcessoNegocio = (List<OcorrenciaServicoProcessoNegocioDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoProcessoNegocio != null && !listaOcorrenciaServicoProcessoNegocio.isEmpty()) {
			return listaOcorrenciaServicoProcessoNegocio;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos processos de negcio
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do processo negcio em que houve alguma ao
	 * @param acaoOcorrenciaServico
	 *            identificador do {@link AuditoriaAcoes}
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoProcessoNegocio(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		processoNegocio.idProcessoNegocio, ");
		sqlBuilder.append("		processoNegocio.nomeProcessoNegocio, ");
		sqlBuilder.append("		clientes.nomerazaosocial as nomeCliente ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN servicoProcessoNegocio servicoProcessoNegocio ");
		sqlBuilder.append("			ON servicoProcessoNegocio.idServico = ocorrenciaServico.idServico ");
		sqlBuilder.append("		INNER JOIN processoNegocio processoNegocio ");
		sqlBuilder.append("			ON processoNegocio.idProcessoNegocio = servicoProcessoNegocio.idProcessoNegocio ");
		sqlBuilder.append("		INNER JOIN clientes clientes ");
		sqlBuilder.append("			ON processoNegocio.idcliente = clientes.idcliente ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND (processoNegocio.deleted IS NULL OR UPPER(processoNegocio.deleted) <> UPPER('Y')) ");
		sqlBuilder.append("	ORDER  BY processoNegocio.idProcessoNegocio ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProcessoNegocioOcorrenciaServico");
		listRetorno.add("nomeProcessoNegocioOcorrenciaServico");
		listRetorno.add("nomeCliente");

		List<OcorrenciaServicoProcessoNegocioDTO> listaOcorrenciaServicoProcessoNegocio = this.engine
				.listConvertion(OcorrenciaServicoProcessoNegocioDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoProcessoNegocio != null && !listaOcorrenciaServicoProcessoNegocio.isEmpty()) {
			for (OcorrenciaServicoProcessoNegocioDTO ocorrenciaServicoProcessoNegocioDTO : listaOcorrenciaServicoProcessoNegocio) {
				ocorrenciaServicoProcessoNegocioDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (!listaIdsOcorrenciaServico.isEmpty() && !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoProcessoNegocioDTO.getIdProcessoNegocioOcorrenciaServico())) {
					ocorrenciaServicoProcessoNegocioDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
				}
				this.create(ocorrenciaServicoProcessoNegocioDTO);
			}
		}

		if (!listaIdsOcorrenciaServico.isEmpty() && AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(acaoOcorrenciaServico)) {
			this.createOcorrenciaServicoProcessoNegocioDesvinculado(idOcorrenciaServico, listaIdsOcorrenciaServico.get(0));
		}
	}

	/**
	 * Cria a ocorrncia de servio do processo de negcio desvinculado
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param idProcessoNegocioDesvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoProcessoNegocioDesvinculado(final Integer idOcorrenciaServico, final Integer idProcessoNegocioDesvinculado) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		processoNegocio.idProcessoNegocio, ");
		sqlBuilder.append("		processoNegocio.nomeProcessoNegocio, ");
		sqlBuilder.append("		clientes.nomerazaosocial as nomeCliente ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		processoNegocio processoNegocio ");
		sqlBuilder.append("		INNER JOIN clientes clientes ");
		sqlBuilder.append("			ON processoNegocio.idcliente = clientes.idcliente ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		processoNegocio.idProcessoNegocio = ? ");
		sqlBuilder.append("		AND (processoNegocio.deleted IS NULL OR UPPER(processoNegocio.deleted) <> UPPER('Y')) ");
		sqlBuilder.append("	ORDER  BY processoNegocio.idProcessoNegocio ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idProcessoNegocioDesvinculado);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProcessoNegocioOcorrenciaServico");
		listRetorno.add("nomeProcessoNegocioOcorrenciaServico");
		listRetorno.add("nomeCliente");

		List<OcorrenciaServicoProcessoNegocioDTO> listaOcorrenciaServicoProcessoNegocio = this.engine
				.listConvertion(OcorrenciaServicoProcessoNegocioDTO.class, listResultado, listRetorno);

		if (listaOcorrenciaServicoProcessoNegocio != null && !listaOcorrenciaServicoProcessoNegocio.isEmpty()) {
			OcorrenciaServicoProcessoNegocioDTO ocorrenciaServicoProcessoNegocioDTO = listaOcorrenciaServicoProcessoNegocio.iterator().next();
			ocorrenciaServicoProcessoNegocioDTO.setIdOcorrenciaServico(idOcorrenciaServico);
			ocorrenciaServicoProcessoNegocioDTO.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			this.create(ocorrenciaServicoProcessoNegocioDTO);
		}
	}
}
