package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProprietariosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoProprietariosDTO;
import br.com.centralit.citcorpore.bean.VinculoServicoProprietariosDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.ProprietariosTipo;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class OcorrenciaServicoProprietariosDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoProprietariosDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoProprietarios";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoProprietarios", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idProprietario", "idProprietarioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeProprietario", "nomeProprietarioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("tipoProprietario", "tipoProprietarioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoProprietariosDTO> getBean() {
		return OcorrenciaServicoProprietariosDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoProprietariosDTO> findOcorrenciaServicoProprietariosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoProprietarios"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoProprietariosDTO> listaOcorrenciaServicoProprietarios = (List<OcorrenciaServicoProprietariosDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoProprietarios != null && !listaOcorrenciaServicoProprietarios.isEmpty()) {
			return listaOcorrenciaServicoProprietarios;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos proprietrios
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do servio relacionado em que houve alguma ao
	 * @param gerenciamentoProprietarioOcorrenciaServico
	 *            </br>
	 *            - acaoOcorrenciaServico (ver: {@link AuditoriaAcoes}) </br>
	 *            - Quando a ao for OcorrenciaServicoAcoes.Desvinculado deve
	 *            possuir o atributo: vinculoServicoProprietariosDesvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoProprietarios(final Integer idOcorrenciaServico, List<Integer> listaIdsOcorrenciaServico,
			GerenciamentoPortfolioProprietariosDTO gerenciamentoProprietarioOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		vinculoServicoProprietarios.idVinculoServicoProprietarios id, ");
		sqlBuilder.append("		grupo.nome, ");
		sqlBuilder.append("		vinculoServicoProprietarios.tipo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN vinculoServicoProprietarios vinculoServicoProprietarios ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = vinculoServicoProprietarios.idServico ");
		sqlBuilder.append("		INNER JOIN grupo grupo ");
		sqlBuilder.append("			ON grupo.idGrupo = vinculoServicoProprietarios.idGrupo ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND grupo.dataFim IS NULL ");
		sqlBuilder.append("	UNION ");
		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		vinculoServicoProprietarios.idVinculoServicoProprietarios id, ");
		sqlBuilder.append("		empregados.nome, ");
		sqlBuilder.append("		vinculoServicoProprietarios.tipo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN vinculoServicoProprietarios vinculoServicoProprietarios ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = vinculoServicoProprietarios.idServico ");
		sqlBuilder.append("		INNER JOIN empregados empregados ");
		sqlBuilder.append("			ON empregados.idEmpregado = vinculoServicoProprietarios.idEmpregado ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND empregados.dataFim IS NULL ");
		sqlBuilder.append("	ORDER  BY id ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProprietarioOcorrenciaServico");
		listRetorno.add("nomeProprietarioOcorrenciaServico");
		listRetorno.add("tipoProprietarioOcorrenciaServico");

		List<OcorrenciaServicoProprietariosDTO> listaOcorrenciaServicoProprietarios = this.engine.listConvertion(OcorrenciaServicoProprietariosDTO.class,
				listResultado, listRetorno);

		if (listaOcorrenciaServicoProprietarios != null && !listaOcorrenciaServicoProprietarios.isEmpty()) {
			for (OcorrenciaServicoProprietariosDTO ocorrenciaServicoProprietariosDTO : listaOcorrenciaServicoProprietarios) {
				ocorrenciaServicoProprietariosDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (gerenciamentoProprietarioOcorrenciaServico != null
						&& !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(gerenciamentoProprietarioOcorrenciaServico.getAcaoProprietariosOcorrenciaServico())
						&& !listaIdsOcorrenciaServico.isEmpty() && listaIdsOcorrenciaServico.contains(ocorrenciaServicoProprietariosDTO.getIdProprietarioOcorrenciaServico())) {
					ocorrenciaServicoProprietariosDTO.setAcaoOcorrenciaServico(gerenciamentoProprietarioOcorrenciaServico.getAcaoProprietariosOcorrenciaServico());
				}
				this.create(ocorrenciaServicoProprietariosDTO);
			}
		}

		if (gerenciamentoProprietarioOcorrenciaServico != null && gerenciamentoProprietarioOcorrenciaServico.getVinculoServicoProprietariosDesvinculado() != null
				&& AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(gerenciamentoProprietarioOcorrenciaServico.getAcaoProprietariosOcorrenciaServico())) {
			this.createOcorrenciaServicoProprietariosDesvinculado(idOcorrenciaServico, gerenciamentoProprietarioOcorrenciaServico.getVinculoServicoProprietariosDesvinculado());
		}
	}

	/**
	 * Cria a ocorrncia de servio dos proprietrios desvinculados
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param proprietarioOcorrenciaServicoDesvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoProprietariosDesvinculado(final Integer idOcorrenciaServico, VinculoServicoProprietariosDTO proprietarioOcorrenciaServicoDesvinculado) throws Exception {
		if (proprietarioOcorrenciaServicoDesvinculado != null) {

			List<Object> listResultado = new ArrayList<Object>();
			StringBuilder sqlBuilder = new StringBuilder();
			List<Object> listParametro = new ArrayList<Object>();

			if (proprietarioOcorrenciaServicoDesvinculado.getTipo().equals(ProprietariosTipo.EMPREGADO.getIdentificador())) {
				sqlBuilder.append("	SELECT ");
				sqlBuilder.append("		empregados.nome ");
				sqlBuilder.append("	FROM ");
				sqlBuilder.append("		empregados empregados ");
				sqlBuilder.append("	WHERE ");
				sqlBuilder.append("		empregados.idEmpregado = ? ");

				listParametro.add(proprietarioOcorrenciaServicoDesvinculado.getIdEmpregado());

			} else if (proprietarioOcorrenciaServicoDesvinculado.getTipo().equals(ProprietariosTipo.GRUPO.getIdentificador())) {
				sqlBuilder.append("	SELECT ");
				sqlBuilder.append("		grupo.nome ");
				sqlBuilder.append("	FROM ");
				sqlBuilder.append("		grupo grupo ");
				sqlBuilder.append("	WHERE ");
				sqlBuilder.append("		grupo.idGrupo = ? ");

				listParametro.add(proprietarioOcorrenciaServicoDesvinculado.getIdGrupo());

			}

			if (UtilStrings.isNotVazio(sqlBuilder.toString())) {
				listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

				List<String> listRetorno = new ArrayList<String>();
				listRetorno.add("nomeProprietarioOcorrenciaServico");

				List<OcorrenciaServicoProprietariosDTO> listaOcorrenciaServicoProprietariosDesvinculado = this.engine
						.listConvertion(OcorrenciaServicoProprietariosDTO.class, listResultado, listRetorno);

				if (listaOcorrenciaServicoProprietariosDesvinculado != null && !listaOcorrenciaServicoProprietariosDesvinculado.isEmpty()) {
					OcorrenciaServicoProprietariosDTO ocorrenciaServicoProprietariosDesvinculado = listaOcorrenciaServicoProprietariosDesvinculado.iterator().next();
					ocorrenciaServicoProprietariosDesvinculado.setIdOcorrenciaServico(idOcorrenciaServico);
					ocorrenciaServicoProprietariosDesvinculado.setIdProprietarioOcorrenciaServico(proprietarioOcorrenciaServicoDesvinculado.getIdVinculoServicoProprietarios());
					ocorrenciaServicoProprietariosDesvinculado.setTipoProprietarioOcorrenciaServico(proprietarioOcorrenciaServicoDesvinculado.getTipo());
					ocorrenciaServicoProprietariosDesvinculado.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
					this.create(ocorrenciaServicoProprietariosDesvinculado);
				}
			}
		}

	}
}
