package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoRequisitosNivelServicoDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoRequisitosNivelServicoDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoRequisitosNivelServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoRequisitosNivelServico";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoRequisitosNivelServico", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("dataInicioServico", "dataInicioServico", false, false, false, false));
		listFields.add(new Field("donoDoServico", "donoDoServico", false, false, false, false));
		listFields.add(new Field("especificacao", "especificacao", false, false, false, false));
		listFields.add(new Field("contexto", "contexto", false, false, false, false));
		listFields.add(new Field("funcionalidadesEssenciais", "funcionalidadesEssenciais", false, false, false, false));
		listFields.add(new Field("seguranca", "seguranca", false, false, false, false));
		listFields.add(new Field("disponibilidade", "disponibilidade", false, false, false, false));
		listFields.add(new Field("capacidade", "capacidade", false, false, false, false));
		listFields.add(new Field("continuidadeDoNegocio", "continuidadeDoNegocio", false, false, false, false));
		listFields.add(new Field("performanceDesempenho", "performanceDesempenho", false, false, false, false));
		listFields.add(new Field("interrupcoesPlanejadas", "interrupcoesPlanejadas", false, false, false, false));
		listFields.add(new Field("gestaoDeIncidentes", "gestaoDeIncidentes", false, false, false, false));
		listFields.add(new Field("gestaoDeProblemas", "gestaoDeProblemas", false, false, false, false));
		listFields.add(new Field("gestaoDeMudancas", "gestaoDeMudancas", false, false, false, false));
		listFields.add(new Field("conformidadeInterna", "conformidadeInterna", false, false, false, false));
		listFields.add(new Field("conformidadeExterna", "conformidadeExterna", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoRequisitosNivelServicoDTO> getBean() {
		return OcorrenciaServicoRequisitosNivelServicoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	@SuppressWarnings("unchecked")
	public OcorrenciaServicoRequisitosNivelServicoDTO findOcorrenciaServicoRequisitosNivelServicoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idOcorrenciaServicoRequisitosNivelServico"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoRequisitosNivelServicoDTO> listaOcorrenciaServicoRequisitosNivelServico = (List<OcorrenciaServicoRequisitosNivelServicoDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoRequisitosNivelServico != null && !listaOcorrenciaServicoRequisitosNivelServico.isEmpty()) {
			return (OcorrenciaServicoRequisitosNivelServicoDTO) listaOcorrenciaServicoRequisitosNivelServico.iterator().next();
		}

		return null;
	}

}
