package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoServicoApoioDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class OcorrenciaServicoServicoApoioDAO extends CrudDaoDefaultImpl{

	public OcorrenciaServicoServicoApoioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoServicoApoio";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();
		
		listFields.add(new Field("id", "idOcorrenciaServicoServicoApoio", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idServicoApoio", "idServicoApoioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeServicoApoio", "nomeServicoApoioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("faseServicoApoio", "faseServicoApoioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("statusServicoApoio", "statusServicoApoioOcorrenciaServico", false, false, false, false));
		
		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoServicoApoioDTO> getBean() {
		return OcorrenciaServicoServicoApoioDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoServicoApoioDTO> findOcorrenciaServicoServicoApoioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoServicoApoio"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoServicoApoioDTO> listaOcorrenciaServicoServicoApoio = (List<OcorrenciaServicoServicoApoioDTO>) super.findByCondition(condicao, ordenacao);
		
		if(listaOcorrenciaServicoServicoApoio != null && !listaOcorrenciaServicoServicoApoio.isEmpty()) {
			return listaOcorrenciaServicoServicoApoio;
		}
		
		return Collections.emptyList();
	}
	
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoServicoApoio(final Integer idOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();
		
		sqlBuilder.append(" SELECT ");
		sqlBuilder.append("		servicoAutoRelacionamento.idServico, ");
		sqlBuilder.append(" 	servico.nomeServico, ");
		sqlBuilder.append(" 	servicoAutoRelacionamento.faseServico, ");
		sqlBuilder.append(" 	servicoAutoRelacionamento.statusServico ");
		sqlBuilder.append(" FROM ");
		sqlBuilder.append(" 	ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append(" 	INNER JOIN servicoAutoRelacionamento servicoAutoRelacionamento ");
		sqlBuilder.append("     	ON ocorrenciaServico.idServico = servicoAutoRelacionamento.idServicoRelacionado ");
		sqlBuilder.append("     INNER JOIN servico servico ");
		sqlBuilder.append("     	ON servico.idServico = servicoAutoRelacionamento.idServico ");
		sqlBuilder.append(" WHERE ");
		sqlBuilder.append(" 	ocorrenciaServico.idOcorrenciaServico = "+idOcorrenciaServico+" ");
		sqlBuilder.append(" 	AND UPPER(servico.tipoServico) = UPPER('A') ");
		sqlBuilder.append(" 	AND servicoAutoRelacionamento.dataFim IS NULL ");
		sqlBuilder.append(" ORDER  BY servicoAutoRelacionamento.idServico ");

		listResultado = this.execSQL(sqlBuilder.toString(), null);
		
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idServicoApoioOcorrenciaServico");
		listRetorno.add("nomeServicoApoioOcorrenciaServico");
		listRetorno.add("faseServicoApoioOcorrenciaServico");
		listRetorno.add("statusServicoApoioOcorrenciaServico");
		
		List<OcorrenciaServicoServicoApoioDTO> listaOcorrenciaServicoServicoApoio = (List<OcorrenciaServicoServicoApoioDTO>) this.engine.listConvertion(OcorrenciaServicoServicoApoioDTO.class, listResultado, listRetorno);
		
		if(listaOcorrenciaServicoServicoApoio != null && !listaOcorrenciaServicoServicoApoio.isEmpty()) {
			for(OcorrenciaServicoServicoApoioDTO ocorrenciaServicoServicoApoioDTO : listaOcorrenciaServicoServicoApoio) {
				ocorrenciaServicoServicoApoioDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				this.create(ocorrenciaServicoServicoApoioDTO);
			}
		}
		
	}
}
