package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoUsuarioNegocioDTO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class OcorrenciaServicoUsuarioNegocioDAO extends CrudDaoDefaultImpl {

	public OcorrenciaServicoUsuarioNegocioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "OcorrenciaServicoUserNegocio";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("id", "idOcorrenciaServicoUsuarioNegocio", true, true, false, false));
		listFields.add(new Field("idOcorrenciaServico", "idOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("acaoOcorrenciaServico", "acaoOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("idUsuarioNegocio", "idUsuarioNegocioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("nomeUsuarioNegocio", "nomeUsuarioNegocioOcorrenciaServico", false, false, false, false));
		listFields.add(new Field("tipoUsuarioNegocio", "tipoUsuarioNegocioOcorrenciaServico", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<OcorrenciaServicoUsuarioNegocioDTO> getBean() {
		return OcorrenciaServicoUsuarioNegocioDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public Collection<OcorrenciaServicoUsuarioNegocioDTO> findOcorrenciaServicoUsuarioNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("idOcorrenciaServicoUsuarioNegocio"));
		condicao.add(new Condition("idOcorrenciaServico", idOcorrenciaServico));
		List<OcorrenciaServicoUsuarioNegocioDTO> listaOcorrenciaServicoUsuarioNegocio = (List<OcorrenciaServicoUsuarioNegocioDTO>) super.findByCondition(condicao, ordenacao);

		if (listaOcorrenciaServicoUsuarioNegocio != null && !listaOcorrenciaServicoUsuarioNegocio.isEmpty()) {
			return listaOcorrenciaServicoUsuarioNegocio;
		}

		return Collections.emptyList();
	}

	/**
	 * Cria a ocorrncia de servio dos usurios do negcio
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param listaIdsOcorrenciaServico
	 *            lista dos ids do servio relacionado em que houve alguma ao
	 * @param usuarioNegocioOcorrenciaServico
	 *            </br>
	 *            - acaoOcorrenciaServico (ver: {@link AuditoriaAcoes}) </br>
	 *            - Quando a ao for OcorrenciaServicoAcoes.Desvinculado deve
	 *            possuir todas as informaes do usurio do negcio
	 *            desvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	public void createOcorrenciaServicoUsuarioNegocio(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico,
			final GerenciamentoPortfolioBusinessUserDTO usuarioNegocioOcorrenciaServico) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		portfolioBusinessUser.idGrupo id, ");
		sqlBuilder.append("		grupo.nome, ");
		sqlBuilder.append("		portfolioBusinessUser.tipo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN portfolioBusinessUser portfolioBusinessUser ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = portfolioBusinessUser.idServico ");
		sqlBuilder.append("		INNER JOIN grupo grupo ");
		sqlBuilder.append("			ON grupo.idGrupo = portfolioBusinessUser.idGrupo ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND grupo.dataFim IS NULL ");
		sqlBuilder.append("	UNION ");
		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		portfolioBusinessUser.idUsuario id, ");
		sqlBuilder.append("		usuario.nome, ");
		sqlBuilder.append("		portfolioBusinessUser.tipo ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		ocorrenciaServico ocorrenciaServico ");
		sqlBuilder.append("		INNER JOIN portfolioBusinessUser portfolioBusinessUser ");
		sqlBuilder.append("			ON ocorrenciaServico.idServico = portfolioBusinessUser.idServico ");
		sqlBuilder.append("		INNER JOIN usuario usuario ");
		sqlBuilder.append("			ON usuario.idUsuario = portfolioBusinessUser.idUsuario ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		ocorrenciaServico.idOcorrenciaServico = ? ");
		sqlBuilder.append("		AND UPPER(usuario.status) = UPPER('A') ");
		sqlBuilder.append("	ORDER  BY id ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idOcorrenciaServico);
		listParametro.add(idOcorrenciaServico);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idUsuarioNegocioOcorrenciaServico");
		listRetorno.add("nomeUsuarioNegocioOcorrenciaServico");
		listRetorno.add("tipoUsuarioNegocioOcorrenciaServico");

		List<OcorrenciaServicoUsuarioNegocioDTO> listaOcorrenciaServicoUsuarioNegocio = this.engine.listConvertion(OcorrenciaServicoUsuarioNegocioDTO.class,
				listResultado, listRetorno);

		if (listaOcorrenciaServicoUsuarioNegocio != null && !listaOcorrenciaServicoUsuarioNegocio.isEmpty()) {
			for (OcorrenciaServicoUsuarioNegocioDTO ocorrenciaServicoUsuarioNegocioDTO : listaOcorrenciaServicoUsuarioNegocio) {
				ocorrenciaServicoUsuarioNegocioDTO.setIdOcorrenciaServico(idOcorrenciaServico);
				if (listaIdsOcorrenciaServico != null && !listaIdsOcorrenciaServico.isEmpty() && usuarioNegocioOcorrenciaServico != null
						&& !AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(usuarioNegocioOcorrenciaServico.getAcaoUsuarioNegocioOcorrenciaServico())
						&& listaIdsOcorrenciaServico.contains(ocorrenciaServicoUsuarioNegocioDTO.getIdUsuarioNegocioOcorrenciaServico())
						&& ocorrenciaServicoUsuarioNegocioDTO.getTipoUsuarioNegocioOcorrenciaServico().equals(usuarioNegocioOcorrenciaServico.getTipo())) {
					ocorrenciaServicoUsuarioNegocioDTO.setAcaoOcorrenciaServico(usuarioNegocioOcorrenciaServico.getAcaoUsuarioNegocioOcorrenciaServico());
				}
				this.create(ocorrenciaServicoUsuarioNegocioDTO);
			}
		}

		if (usuarioNegocioOcorrenciaServico != null && AuditoriaAcoes.DESVINCULADO.getIdentificador().equals(usuarioNegocioOcorrenciaServico.getAcaoUsuarioNegocioOcorrenciaServico())) {
			this.createOcorrenciaServicoUsuarioNegocioDesvinculado(idOcorrenciaServico, usuarioNegocioOcorrenciaServico);
		}
	}

	/**
	 * Cria a ocorrncia de servio do usrio do negcio desvinculado
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @param idOcorrenciaServico
	 * @param usuarioNegocioDesvinculado
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@SuppressWarnings("unchecked")
	private void createOcorrenciaServicoUsuarioNegocioDesvinculado(final Integer idOcorrenciaServico, final GerenciamentoPortfolioBusinessUserDTO usuarioNegocioDesvinculado) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();
		List<Object> listParametro = new ArrayList<Object>();

		if (usuarioNegocioDesvinculado.getIdUsuario() != null) {
			sqlBuilder.append("	SELECT ");
			sqlBuilder.append("		usuario.nome ");
			sqlBuilder.append("	FROM ");
			sqlBuilder.append("		usuario usuario ");
			sqlBuilder.append("	WHERE ");
			sqlBuilder.append("		usuario.idUsuario = ? ");
			sqlBuilder.append("		AND UPPER(usuario.status) = UPPER('A') ");

			listParametro.add(usuarioNegocioDesvinculado.getIdUsuario());
		} else if (usuarioNegocioDesvinculado.getIdGrupoUsuario() != null) {
			sqlBuilder.append("	SELECT ");
			sqlBuilder.append("		grupo.nome ");
			sqlBuilder.append("	FROM ");
			sqlBuilder.append("		grupo grupo ");
			sqlBuilder.append("	WHERE ");
			sqlBuilder.append("		grupo.idGrupo = ? ");
			sqlBuilder.append("		AND grupo.dataFim IS NULL ");

			listParametro.add(usuarioNegocioDesvinculado.getIdGrupoUsuario());
		}

		if (UtilStrings.isNotVazio(sqlBuilder.toString())) {
			listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("nomeUsuarioNegocioOcorrenciaServico");

			List<OcorrenciaServicoUsuarioNegocioDTO> listaOcorrenciaServicoUsuarioNegocio = this.engine
					.listConvertion(OcorrenciaServicoUsuarioNegocioDTO.class, listResultado, listRetorno);

			if (listaOcorrenciaServicoUsuarioNegocio != null && !listaOcorrenciaServicoUsuarioNegocio.isEmpty()) {
				OcorrenciaServicoUsuarioNegocioDTO ocorrenciaServicoUsuarioNegocioDesvinculado = listaOcorrenciaServicoUsuarioNegocio.iterator().next();
				Integer idUsuarioNegocio = BusinessUserTipo.USUARIO.getIdentificador().equals(usuarioNegocioDesvinculado.getTipo()) ? usuarioNegocioDesvinculado.getIdUsuario()
						: usuarioNegocioDesvinculado.getIdGrupoUsuario();
				ocorrenciaServicoUsuarioNegocioDesvinculado.setIdOcorrenciaServico(idOcorrenciaServico);
				ocorrenciaServicoUsuarioNegocioDesvinculado.setAcaoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				ocorrenciaServicoUsuarioNegocioDesvinculado.setIdUsuarioNegocioOcorrenciaServico(idUsuarioNegocio);
				ocorrenciaServicoUsuarioNegocioDesvinculado.setTipoUsuarioNegocioOcorrenciaServico(usuarioNegocioDesvinculado.getTipo());
				this.create(ocorrenciaServicoUsuarioNegocioDesvinculado);
			}
		}
	}
}
