package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoGrupoDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoUsuarioDTO;
import br.com.centralit.citcorpore.bean.PermissaoAcessoPaginaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class PermissaoAcessoPaginaDao extends CrudDaoDefaultImpl {

	private GrupoDao grupoDAO;
	private PerfilAcessoGrupoDao perfilAcessoGrupoDAO;
	private PerfilAcessoUsuarioDAO perfilAcessoUsuarioDAO;

	public PermissaoAcessoPaginaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idperfilacesso", "idPerfilAcesso", true, false, false, false));
		listFields.add(new Field("caminho", "caminho", true, false, false, false));
		listFields.add(new Field("pesquisa", "pesquisa", false, false, false, false));
		listFields.add(new Field("grava", "grava", false, false, false, false));
		listFields.add(new Field("deleta", "deleta", false, false, false, false));
		listFields.add(new Field("tipoperfilacesso", "tipoPerfilAcesso", false, false, false, false));
		listFields.add(new Field("ordem", "ordem", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "permissaoacessopagina";
	}

	@Override
	public Class<PermissaoAcessoPaginaDTO> getBean() {
		return PermissaoAcessoPaginaDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<PermissaoAcessoPaginaDTO> getPaginasByUsuario(UsuarioDTO usuario, Boolean isSomentePesquisa) throws PersistenceException {
		Collection<PermissaoAcessoPaginaDTO> result = null;

		getPerfilAcessoUsuarioDAO().setTransactionControler(this.getTransactionControler());
		getGrupoDAO().setTransactionControler(this.getTransactionControler());
		getPerfilAcessoGrupoDAO().setTransactionControler(this.getTransactionControler());

		StringBuilder sql = new StringBuilder();
		List<Integer> parametros = new ArrayList<>();

		sql.append("SELECT ");
		sql.append(getNamesFieldsStr()).append(" ");
		sql.append("FROM ");
		sql.append(getTableName()).append(" ");
		sql.append("WHERE ");

		PerfilAcessoUsuarioDTO perfilAcessoEspecifico = getPerfilAcessoUsuarioDAO().obterPerfilAcessoUsuario(usuario);

		sql.append("	idPerfilAcesso in (");
		boolean adicionouInterrogacao = false;

		if (perfilAcessoEspecifico != null) {
			sql.append("?");
			parametros.add(perfilAcessoEspecifico.getIdPerfilAcesso());
			adicionouInterrogacao = true;
		}

		Collection<GrupoDTO> gruposDoEmpregado = getGrupoDAO().getGruposByIdEmpregado(usuario.getIdEmpregado());

		if (gruposDoEmpregado != null && !gruposDoEmpregado.isEmpty()) {
			for (GrupoDTO grupo : gruposDoEmpregado) {
				PerfilAcessoGrupoDTO perfilAcessoGrupo = getPerfilAcessoGrupoDAO().obterPerfilAcessoGrupo(grupo);

				if (perfilAcessoGrupo != null) {
					if (adicionouInterrogacao){
						sql.append(",?");
					} else {
						sql.append("?");
						adicionouInterrogacao = true;
					}
					parametros.add(perfilAcessoGrupo.getIdPerfilAcessoGrupo());
				}
			}
		}
		sql.append(") ");

		if (isSomentePesquisa) {
			sql.append("	AND pesquisa = 'S'");
		}

		List<?> lista = this.execSQL(sql.toString(), parametros.toArray());

		result = engine.listConvertion(PermissaoAcessoPaginaDTO.class, lista, getListNamesFieldClass());

		return result;
	}

	@SuppressWarnings("unchecked")
	public Collection<PermissaoAcessoPaginaDTO> getPaginasByPerfilAcesso(Integer idPerfilAcesso, Integer tipoPerfilAcesso) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idPerfilAcesso", idPerfilAcesso));
		condicao.add(new Condition("tipoPerfilAcesso", tipoPerfilAcesso));
		ordenacao.add(new Order("ordem"));
		return findByCondition(condicao, ordenacao);
	}

	public Boolean isPermissaoAcessoJaExiste(Integer idPerfilAcesso, Integer tipoPerfilAcesso) throws PersistenceException {
		Collection<PermissaoAcessoPaginaDTO> permissaoAcessoPaginas = getPaginasByPerfilAcesso(idPerfilAcesso, tipoPerfilAcesso);
		return permissaoAcessoPaginas != null && !permissaoAcessoPaginas.isEmpty();
	}

	private GrupoDao getGrupoDAO() {
		if (grupoDAO == null) {
			grupoDAO = new GrupoDao();
		}
		return grupoDAO;
	}

	private PerfilAcessoGrupoDao getPerfilAcessoGrupoDAO() {
		if (perfilAcessoGrupoDAO == null) {
			perfilAcessoGrupoDAO = new PerfilAcessoGrupoDao();
		}
		return perfilAcessoGrupoDAO;
	}

	private PerfilAcessoUsuarioDAO getPerfilAcessoUsuarioDAO() {
		if (perfilAcessoUsuarioDAO == null) {
			perfilAcessoUsuarioDAO = new PerfilAcessoUsuarioDAO();
		}
		return perfilAcessoUsuarioDAO;
	}
}
