package br.com.centralit.citcorpore.integracao;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.PlanoMelhoriaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class PlanoMelhoriaDao extends CrudDaoDefaultImpl {
	public PlanoMelhoriaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idPlanoMelhoria" ,"idPlanoMelhoria", true, true, false, false));
		listFields.add(new Field("idFornecedor" ,"idFornecedor", false, false, false, false));
		listFields.add(new Field("idContrato" ,"idContrato", false, false, false, false));
		listFields.add(new Field("titulo" ,"titulo", false, false, false, false));
		listFields.add(new Field("dataInicioPlano", "dataInicioPlano", false, false, false, false));
		listFields.add(new Field("dataFimPlano", "dataFimPlano", false, false, false, false));
		listFields.add(new Field("objetivo" ,"objetivo", false, false, false, false));
		listFields.add(new Field("visaoGeral" ,"visaoGeral", false, false, false, false));
		listFields.add(new Field("escopo" ,"escopo", false, false, false, false));
		listFields.add(new Field("visao" ,"visao", false, false, false, false));
		listFields.add(new Field("missao" ,"missao", false, false, false, false));
		listFields.add(new Field("notas" ,"notas", false, false, false, false));
		listFields.add(new Field("criadoPor" ,"criadoPor", false, false, false, false));
		listFields.add(new Field("modificadoPor" ,"modificadoPor", false, false, false, false));
		listFields.add(new Field("dataCriacao" ,"dataCriacao", false, false, false, false));
		listFields.add(new Field("ultModificacao" ,"ultModificacao", false, false, false, false));
		listFields.add(new Field("situacao" ,"situacao", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "PlanoMelhoria";
	}

	@Override
	public Collection<PlanoMelhoriaDTO> list() throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		List<Order> ordenacao = new ArrayList<>();

		ordenacao.add(new Order("dataInicioPlano"));
		condicao.add(new Condition("datafim", "is", null));

		return super.findByCondition(condicao, ordenacao);
	}

	@Override
	public Class<PlanoMelhoriaDTO> getBean() {
		return PlanoMelhoriaDTO.class;
	}

	@Override
	public void update(IDto obj) throws PersistenceException {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) restore(obj);

		if (planoMelhoriaDTO != null){
			((PlanoMelhoriaDTO) obj).setCriadoPor(planoMelhoriaDTO.getCriadoPor());
			((PlanoMelhoriaDTO) obj).setDataCriacao(planoMelhoriaDTO.getDataCriacao());
		}

		super.update(obj);
	}

	@Override
	public void delete(IDto obj) throws PersistenceException {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) restore(obj);

		if (planoMelhoriaDTO != null) {
			planoMelhoriaDTO.setDataFim(new Date(new java.util.Date().getTime()));
		}

		super.updateNotNull(planoMelhoriaDTO);
	}
}
