package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.PortfolioServicoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;

public class PortfolioServicoDao extends CrudDaoDefaultImpl {

	public PortfolioServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idPortfolioServico", "idPortfolioServico", true, true, false, false));
		listFields.add(new Field("descPortfolioServico", "descPortfolioServico", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		listFields.add(new Field("disponivelportal", "disponivelPortal", false, false, false, false));
		listFields.add(new Field("nomeportal", "nomePortal", false, false, false, false));
		listFields.add(new Field("descricaoportal", "descricaoPortal", false, false, false, false));
		listFields.add(new Field("imagemportal", "imagemPortal", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "portfolioservico";
	}

	@SuppressWarnings("unchecked")
	public Collection<PortfolioServicoDTO> findAtivos() throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();

		condicao.add(new Condition("dataFim", "is", null));
		ordenacao.add(new Order("descPortfolioServico"));

		return super.findByCondition(condicao, ordenacao);
	}

	@SuppressWarnings("unchecked")
	public Collection<PortfolioServicoDTO> findDisponiveisPortal(String nome) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();

		sql.append(" SELECT " + this.getNamesFieldsStr(this.getTableName()) + " ");
		sql.append(" FROM " + this.getTableName());
		sql.append(" WHERE datafim is NULL and disponivelportal = 'S' ");

		if (nome != null && !nome.isEmpty()) {
			sql.append(" and upper(nomePortal) like upper('%" + nome + "%') ");
		}

		final List<Object> fields = new ArrayList<Object>(this.getFields());

		final List<?> dados = this.execSQL(sql.toString(), null);

		return this.listConvertion(this.getBean(), dados, fields);
	}

	public List<PortfolioServicoDTO> findDisponiveisPortalByContratos(String nomePortal, Collection<ContratoDTO> contratosDTO) throws PersistenceException {
		StringBuilder sb = new StringBuilder();

		sb.append("SELECT DISTINCT\n");
		sb.append("ps.idPortfolioServico, ");
		sb.append("ps.descPortfolioServico, ");
		sb.append("ps.dataInicio, ");
		sb.append("ps.dataFim, ");
		sb.append("ps.disponivelportal, ");
		sb.append("ps.nomeportal, ");
		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
			sb.append("convert(varchar(max),ps.descricaoportal), ");
		}else{
			sb.append("ps.descricaoportal, ");
		}
		sb.append("ps.imagemportal ");
		sb.append("FROM \n");
		sb.append("	servico s \n");
		sb.append("	INNER JOIN servicocontrato sc ON s.idservico = sc.idservico \n");
		sb.append("	INNER JOIN portfolioservico ps ON s.idPortfolioServico = ps.idPortfolioServico \n");
		sb.append("WHERE \n");
		sb.append("	upper(s.statusServico) in (upper('LBRC'), upper('PRD')) \n");
		sb.append("	and (upper(s.deleted)  = 'N' or s.deleted is null) \n");
		sb.append("	and ps.dataFim is null \n");
		sb.append("	and upper(ps.disponivelPortal) = upper('S') \n");
		sb.append("	and upper(s.dispportal) = upper('S') \n");
		sb.append("	and upper(s.tipoServico) = upper('N') \n");

		if (nomePortal != null && !nomePortal.isEmpty()) {
			sb.append(" and upper(ps.nomePortal) like upper('%" + nomePortal + "%') ");
		}

		if (contratosDTO != null && !contratosDTO.isEmpty()) {
			sb.append(" and sc.idcontrato in (");

			int count = 0;
			for (ContratoDTO contratoDTO : contratosDTO) {
				sb.append((count == 0 ? "" : ", ") + contratoDTO.getIdContrato());
				count++;
			}

			sb.append(") ");
		}

		sb.append("ORDER BY \n");
		sb.append("	ps.nomeportal \n");

		final List<Object> fields = new ArrayList<Object>(this.getFields());

		final List<?> dados = this.execSQL(sb.toString(), null);

		return this.listConvertion(this.getBean(), dados, fields);
	}

	@Override
	public Class<?> getBean() {
		return PortfolioServicoDTO.class;
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	/**
	 * Retorna o id do portflio se o registro j existe.
	 *
	 * @param String
	 *            nomePortfolio
	 * @return Integer idPortfolio
	 * @throws PersistenceException
	 */
	public Integer getIdPortfolioSeExiste(String nomePortfolio) throws PersistenceException {
		List listResultado = new ArrayList<>();
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append(" SELECT ");
		sql.append(" 	idportfolioservico");
		sql.append(" FROM ");
		sql.append(" 	categoriaservico ");
		sql.append(" WHERE ");
		sql.append("	datafim IS NULL ");
		sql.append("	AND descportfolioservico LIKE ? ");
		sql.append(" ORDER BY idportfolioservico DESC");

		parametros.add(nomePortfolio);

		listResultado = this.execSQL(sql.toString(), parametros.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idportfolioservico");

		List<PortfolioServicoDTO> listaPortfolio = this.engine.listConvertion(getBean(), listResultado, listRetorno);

		if (listaPortfolio != null && !listaPortfolio.isEmpty()) {
			PortfolioServicoDTO portfolio = listaPortfolio.iterator().next();
			if (portfolio != null) {
				return portfolio.getIdPortfolioServico();
			}
		}

		return null;
	}
}
