package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ProblemaBaseConhecimentoRelacionadoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ProblemaBaseConhecimentoDAO extends CrudDaoDefaultImpl {
	public ProblemaBaseConhecimentoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idProblemaBaseConhecimentoRelacionado", "idProblemaBaseConhecimentoRelacionado", true, true, false, false));
		listFields.add(new Field("idProblema", "idProblema", false, false, false, false));
		listFields.add(new Field("idBaseConhecimento", "idBaseConhecimento", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "problemabaseconhecimentorelacionado";
	}

	@Override
	public Class<ProblemaBaseConhecimentoRelacionadoDTO> getBean() {
		return ProblemaBaseConhecimentoRelacionadoDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaBaseConhecimentoRelacionadoDTO> findByIdProblemaBaseConhecimento(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idProblemaBaseConhecimentoRelacionado", parm));
		ordenacao.add(new Order("idProblemaBaseConhecimentoRelacionado"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdProblemaBaseConhecimento(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProblemaBaseConhecimentoRelacionado", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaBaseConhecimentoRelacionadoDTO> findByIdProblema(Integer idProblema) throws Exception {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();

		StringBuffer sql = new StringBuffer();
		sql.append("SELECT p.idproblemabaseconhecimentorelacionado, p.idproblema, p.idbaseconhecimento ");
		sql.append("FROM problemabaseconhecimentorelacionado p ");
		sql.append("WHERE p.idproblema = ? ");
		sql.append("ORDER BY idproblemabaseconhecimentorelacionado");

		parametro.add(idProblema);

		List<?> list = this.execSQL(sql.toString(), parametro.toArray());

		fields.add("idproblemabaseconhecimentorelacionado");
		fields.add("idProblema");
		fields.add("idBaseConhecimento");

		if (list != null && !list.isEmpty()) {
			List<ProblemaBaseConhecimentoRelacionadoDTO> listaMudanca = this.listConvertion(this.getBean(), list, fields);
			return listaMudanca;
		}

		return null;
	}

	public void deleteByIdProblema(Integer parm) throws Exception {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProblema", parm));
		super.deleteByCondition(condicao);
	}

	public void deleteByIdBaseConhecimento(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idBaseConhecimento", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public ProblemaBaseConhecimentoRelacionadoDTO restoreByIdProblema(Integer idProblema) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		parametro.add(idProblema);

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idproblemabaseconhecimentorelacionado");
		listRetorno.add("idProblema");
		listRetorno.add("idBaseConhecimento");

		String sql = "  select * from problemabaseconhecimentorelacionado where idproblema = ? ";

		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		if (lista != null && !lista.isEmpty()) {
			List<ProblemaBaseConhecimentoRelacionadoDTO> listaResult = this.engine.listConvertion(ProblemaBaseConhecimentoRelacionadoDTO.class, lista, listRetorno);
			return listaResult.get(0);
		} else {
			return null;
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Collection<BaseConhecimentoDTO> listaErroConhecidoByIdProblema(Integer parm) throws PersistenceException {
		List parametro = new ArrayList<>();

		StringBuilder sql = new StringBuilder();

		List<?> lista = new ArrayList<>();

		List<String> listRetorno = new ArrayList<>();

		sql.append("select bc.idbaseconhecimento  ");
		sql.append(" from problemabaseconhecimentorelacionado pbcr");
		sql.append(" inner join historicobaseconhecimento bc on pbcr.idbaseconhecimento = bc.idbaseconhecimento   ");
		sql.append(" where pbcr.idproblema = ? ");

		if (parm != null) {
			parametro.add(parm);
		}

		lista = this.execSQL(sql.toString(), parametro.toArray());

		listRetorno.add("idBaseConhecimento");

		if (lista != null && !lista.isEmpty()) {
			Collection<BaseConhecimentoDTO> listaBaseConhecimentoByIdProblema = this.listConvertion(BaseConhecimentoDTO.class, lista, listRetorno);
			return listaBaseConhecimentoByIdProblema;
		}

		return null;
	}

	public ProblemaBaseConhecimentoRelacionadoDTO getErroConhecidoByProblema(Integer idProblema) throws PersistenceException {
		Collection<ProblemaBaseConhecimentoRelacionadoDTO> listaBaseConhecimentoByIdProblema = getListErroConhecidoByIdProblema(idProblema);
		if(listaBaseConhecimentoByIdProblema != null && !listaBaseConhecimentoByIdProblema.isEmpty()) {
			return (ProblemaBaseConhecimentoRelacionadoDTO) listaBaseConhecimentoByIdProblema.toArray()[0];
		} 
		return null;
	}

	public List<ProblemaBaseConhecimentoRelacionadoDTO> findErroConhecidoByProblema(Integer idProblema) throws PersistenceException {

		return getListErroConhecidoByIdProblema(idProblema);

	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private List<ProblemaBaseConhecimentoRelacionadoDTO> getListErroConhecidoByIdProblema(Integer idProblema) throws PersistenceException {
		List parametro = new ArrayList<>();

		StringBuilder sql = new StringBuilder();

		List<?> lista = new ArrayList<>();

		List<String> listRetorno = new ArrayList<String>();

		sql.append("select ");
		sql.append("	problemabaseconhecimentorelacionado.idproblemabaseconhecimentorelacionado,");
		sql.append("	problemabaseconhecimentorelacionado.idbaseconhecimento,");
		sql.append("	problemabaseconhecimentorelacionado.idproblema,");
		sql.append("	baseconhecimento.titulo,");
		sql.append("	CASE WHEN baseconhecimento.status ='S' THEN 'pesquisaBaseConhecimento.publicado' WHEN baseconhecimento.status ='N' THEN 'pesquisaBaseConhecimento.naoPublicado' ELSE baseconhecimento.status END as status ");
		sql.append("from problemabaseconhecimentorelacionado problemabaseconhecimentorelacionado ");
		sql.append("inner join historicobaseconhecimento baseconhecimento on baseconhecimento.idbaseconhecimento = problemabaseconhecimentorelacionado.idbaseconhecimento ");
		sql.append("where  baseconhecimento.dataFim is null and baseconhecimento.erroconhecido = ? and baseconhecimento.arquivado = ? ");

		parametro.add("S");
		parametro.add("N");

		if (idProblema != null) {
			sql.append(" and problemabaseconhecimentorelacionado.idproblema = ? ");
			parametro.add(idProblema);
		}
		
		sql.append(" order by baseconhecimento.titulo asc ");

		lista = this.execSQL(sql.toString(), parametro.toArray());

		listRetorno.add("idProblemaBaseConhecimentoRelacionado");
		listRetorno.add("idBaseConhecimento");
		listRetorno.add("idProblema");
		listRetorno.add("titulo");
		listRetorno.add("status");

		if (lista != null && !lista.isEmpty()) {
			return this.listConvertion(ProblemaBaseConhecimentoRelacionadoDTO.class, lista, listRetorno);
		}

		return new ArrayList<>();
	}
}
