package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.ProblemaMudancaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ProblemaMudancaDAO extends CrudDaoDefaultImpl {
	public ProblemaMudancaDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idProblemaMudanca", "idProblemaMudanca", true, true, false, false));
		listFields.add(new Field("idProblema", "idProblema", false, false, false, false));
		listFields.add(new Field("idRequisicaoMudanca", "idRequisicaoMudanca", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "problemamudanca";
	}

	@Override
	public Class<ProblemaMudancaDTO> getBean() {
		return ProblemaMudancaDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaMudancaDTO> findByIdProblemaMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idProblemaMudanca", "=", parm));
		ordenacao.add(new Order("idProblemaMudanca"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdProblemaMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProblemaMudanca", "=", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaMudancaDTO> findByIdProblema(Integer idProblema) throws Exception {

		List<?> list;
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();

		StringBuffer sql = new StringBuffer();
		sql.append("SELECT p.idproblemamudanca, p.idproblema, p.idrequisicaomudanca, m.titulo, m.idStatus ");
		sql.append("FROM problemamudanca p left join requisicaomudanca m on p.idrequisicaomudanca = m.idrequisicaomudanca ");
		sql.append("WHERE p.idproblema = ? and (p.datafim is null) ");
		sql.append("ORDER BY idrequisicaomudanca");

		parametro.add(idProblema);

		list = this.execSQL(sql.toString(), parametro.toArray());

		fields.add("idProblemaMudanca");
		fields.add("idProblema");
		fields.add("idRequisicaoMudanca");
		fields.add("titulo");
		fields.add("idStatus");

		if (list != null && !list.isEmpty()) {
			List<ProblemaMudancaDTO> listaMudanca = this.listConvertion(this.getBean(), list, fields);
			return listaMudanca;
		}
		return null;

	}

	public void deleteByIdProblema(Integer parm) throws Exception {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProblema", "=", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaMudancaDTO> findByIdRequisicaoMudanca(Integer parm) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		List<?> list = new ArrayList<Object>();
		StringBuilder sql = new StringBuilder();
		sql.append(" SELECT distinct pm.idproblema as idproblema, titulo, idStatus FROM problema pro JOIN problemamudanca pm ON pro.idproblema = pm.idproblema WHERE pm.idrequisicaomudanca = ? AND pm.datafim is null ORDER BY pm.idproblema");
		parametro.add(parm);
		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("idProblema");
		fields.add("titulo");
		fields.add("idStatus");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(getBean(), list, fields);
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaMudancaDTO> findByIdMudancaEDataFim(Integer idRequisicaoMudanca) throws PersistenceException {
		List<String> fields = new ArrayList<String>();

		String sql = "select idproblemamudanca, idproblema, idrequisicaomudanca, datafim from problemamudanca WHERE idrequisicaomudanca = ? and datafim is null";

		List<?> resultado = execSQL(sql, new Object[] { idRequisicaoMudanca });

		fields.add("idProblemaMudanca");
		fields.add("idProblema");
		fields.add("idRequisicaoMudanca");
		fields.add("dataFim");

		return listConvertion(getBean(), resultado, fields);
	}

	@SuppressWarnings("unchecked")
	public Collection<ProblemaMudancaDTO> listByIdHistoricoMudanca(Integer idHistoricoMudanca) throws PersistenceException {
		List<String> fields = new ArrayList<String>();

		String sql = "select distinct pr.idproblemamudanca, pr.idproblema, pr.idrequisicaomudanca, pr.datafim " + "from problemamudanca pr " + "inner join ligacao_mud_hist_pr ligpr on ligpr.idproblemamudanca = pr.idproblemamudanca "
				+ "WHERE ligpr.idhistoricomudanca = ?";

		List<?> resultado = execSQL(sql, new Object[] { idHistoricoMudanca });

		fields.add("idProblemaMudanca");
		fields.add("idProblema");
		fields.add("idRequisicaoMudanca");
		fields.add("dataFim");

		return listConvertion(getBean(), resultado, fields);
	}

	public void deleteByIdRequisicaoMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idRequisicaoMudanca", "=", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public List<ProblemaDTO> listProblemaByIdMudanca(Integer idMudanca) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		StringBuilder sql = new StringBuilder();

		sql.append("select pr.idproblema ");
		sql.append(" from problema pr  ");
		sql.append(" inner join problemamudanca pm ");
		sql.append(" on pr.idproblema = pm.idproblema ");
		sql.append(" where pm.idrequisicaomudanca =  ? ");

		parametro.add(idMudanca);

		fields.add("idProblema");

		List<?> dados = this.execSQL(sql.toString(), parametro.toArray());

		return this.listConvertion(ProblemaDTO.class, dados, fields);
	}

	public ProblemaMudancaDTO restoreByIdProblema(Integer idProblema) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		parametro.add(idProblema);

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProblemaMudanca");
		listRetorno.add("idProblema");
		listRetorno.add("idRequisicaoMudanca");
		listRetorno.add("dataFim");

		String sql = "  select * from problemamudanca where idproblema = ? and datafim is null ";

		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		if (lista != null && !lista.isEmpty()) {
			List<?> listaResult = this.engine.listConvertion(ProblemaMudancaDTO.class, lista, listRetorno);
			return (ProblemaMudancaDTO) listaResult.get(0);
		} else {
			return null;
		}
	}
}
