package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProblemaServicoNegocioDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class ProblemaServicoNegocioDao extends CrudDaoDefaultImpl {

	public ProblemaServicoNegocioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	public ProblemaServicoNegocioDao(String databaseAlias) {
		super(databaseAlias, null);
	}
	@Override
	public String getTableName() {
		return "PROBLEMASERVICONEGOCIO";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> fields = new ArrayList<>();
		fields.add(new Field("idProblemaServicoNegocio", "idProblemaServicoNegocio", true, true, false, false));
		fields.add(new Field("idProblema", "idProblema", false, false, false, false));
		fields.add(new Field("idServico", "idServico", false, false, false, false));
		return fields;
	}

	@Override
	public Class<?> getBean() {
		return ProblemaServicoNegocioDTO.class;
	}
	
	public ProblemaServicoNegocioDTO findByIdProblema(ProblemaServicoNegocioDTO problemaServicoNegocioDTO) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		List<Order> ordenacao = new ArrayList<>();
		condicao.add(new Condition("idProblema", Condition.EQUALS, problemaServicoNegocioDTO.getIdProblema()));
		Collection<ProblemaServicoNegocioDTO> colReturn = this.findByCondition(condicao, ordenacao);
		if(colReturn != null && !colReturn.isEmpty()){
			return new ArrayList<ProblemaServicoNegocioDTO>(colReturn).get(0);
		}
		return null;
	}
	
	public void deleteAllByIdProblema(ProblemaServicoNegocioDTO problemaServicoNegocioDTO) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idProblema", Condition.EQUALS, problemaServicoNegocioDTO.getIdProblema()));
		super.deleteByCondition(condicao);
		
	}
	
}