package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProcessoNegocioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class ProcessoNegocioDao extends CrudDaoDefaultImpl {
	public ProcessoNegocioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idProcessoNegocio" ,"idProcessoNegocio", true, true, false, false));
		listFields.add(new Field("idGrupoExecutor" ,"idGrupoExecutor", false, false, false, false));
		listFields.add(new Field("idGrupoAdministrador" ,"idGrupoAdministrador", false, false, false, false));
		listFields.add(new Field("nomeProcessoNegocio" ,"nomeProcessoNegocio", false, false, false, false));
		listFields.add(new Field("permissaoSolicitacao" ,"permissaoSolicitacao", false, false, false, false));
		listFields.add(new Field("percDispensaNovaAprovacao" ,"percDispensaNovaAprovacao", false, false, false, false));
		listFields.add(new Field("permiteAprovacaoNivelInferior" ,"permiteAprovacaoNivelInferior", false, false, false, false));
		listFields.add(new Field("alcadaPrimeiroNivel" ,"alcadaPrimeiroNivel", false, false, false, false));
		listFields.add(new Field("deleted" ,"deleted", false, false, false, false));
		listFields.add(new Field("idcliente" ,"idCliente", false, false, false, false));
		
		return listFields;
	}
	public String getTableName() {
		return this.getOwner() + "ProcessoNegocio";
	}
	
	public Collection<ProcessoNegocioDTO> list() throws PersistenceException {
        List<Order> ordenacao = new ArrayList<Order>();        
        ordenacao.add(new Order("nomeProcessoNegocio") );
        return (Collection<ProcessoNegocioDTO>) super.list(ordenacao);
	}

	public Class<ProcessoNegocioDTO> getBean() {
		return ProcessoNegocioDTO.class;
	}
	
	public ProcessoNegocioDTO findById(final Integer idProcessoNegocio) throws PersistenceException {
		List listResultado = new ArrayList();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("SELECT ");
		sqlBuilder.append("		pn.idProcessoNegocio, ");
		sqlBuilder.append("		pn.nomeProcessoNegocio, ");
		sqlBuilder.append("		pn.idGrupoExecutor, ");
		sqlBuilder.append("		pn.idGrupoAdministrador, ");
		sqlBuilder.append("		pn.idCliente, ");
		sqlBuilder.append("		cli.nomerazaosocial processoNegocioCliente ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("		ProcessoNegocio pn ");
		sqlBuilder.append("LEFT JOIN ");
		sqlBuilder.append(" 	clientes cli on pn.idcliente = cli.idcliente ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("		(pn.deleted is NULL OR UPPER(pn.deleted) <> 'Y') ");
		sqlBuilder.append("		AND ");
		sqlBuilder.append("		pn.idProcessoNegocio = "+ idProcessoNegocio+" ");
		sqlBuilder.append("ORDER BY ");
		sqlBuilder.append("		pn.idProcessoNegocio");

		listResultado = this.execSQL(sqlBuilder.toString(), null);
		
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProcessoNegocio");
		listRetorno.add("nomeProcessoNegocio");
		listRetorno.add("idGrupoExecutor");
		listRetorno.add("idGrupoAdministrador");
		listRetorno.add("idCliente");
		listRetorno.add("processoNegocioCliente");
		
		List<ProcessoNegocioDTO> listaProcessosNegocio = (List<ProcessoNegocioDTO>) this.engine.listConvertion(getBean(), listResultado, listRetorno);
		
		if(listaProcessosNegocio != null && !listaProcessosNegocio.isEmpty()) {
			return (ProcessoNegocioDTO) listaProcessosNegocio.get(0);
		}
		
        return null;
	};
	
	public Page<ProcessoNegocioDTO> listProcessoDeNegocio(Integer idServico, String filtroProcessoNegocio, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		Page<ProcessoNegocioDTO> taskPage;
		
		StringBuilder selectQueryPiece = new StringBuilder("SELECT ");
		selectQueryPiece.append("	processoNegocio.idProcessoNegocio, ");
		selectQueryPiece.append("	processoNegocio.nomeProcessoNegocio, ");
		selectQueryPiece.append("	cli.nomerazaosocial processoNegocioCliente ");
		
		StringBuilder orderBy = new StringBuilder(" ORDER BY processoNegocio.nomeProcessoNegocio ");
		
		StringBuilder fromWhereQueryPiece = new StringBuilder("FROM ");
		fromWhereQueryPiece.append("	ProcessoNegocio processoNegocio ");
		fromWhereQueryPiece.append("	inner join ServicoProcessoNegocio servicoProcessoNegocio on servicoProcessoNegocio.idservico = "+idServico+" ");
		fromWhereQueryPiece.append("	left join clientes cli on cli.idcliente = processoNegocio.idcliente ");
		fromWhereQueryPiece.append(" WHERE ");
		fromWhereQueryPiece.append(" (processoNegocio.deleted is NULL OR UPPER(processoNegocio.deleted) <> 'Y') ");
		fromWhereQueryPiece.append(" AND ");
		fromWhereQueryPiece.append(" processoNegocio.idprocessonegocio = servicoProcessoNegocio.idprocessonegocio ");
		
		if (UtilStrings.isNotVazio(filtroProcessoNegocio)) {
			try {
				Integer idProcessoNegocio = Integer.parseInt(filtroProcessoNegocio);
				fromWhereQueryPiece.append(" and (processoNegocio.idProcessoNegocio = " + idProcessoNegocio + " ");
				fromWhereQueryPiece.append(" or upper(processoNegocio.nomeProcessoNegocio) like upper('%" + filtroProcessoNegocio + "%') ");
			} catch(Exception e) {
				fromWhereQueryPiece.append(" and upper(processoNegocio.nomeProcessoNegocio) like upper('%" + filtroProcessoNegocio + "%') ");
			}
		} 
		
		String sql = "";
		List lista = new ArrayList();
		if (isTotalizacao) {
			final StringBuilder sqlCount = this.countQueryPiece(fromWhereQueryPiece);
			final Long totalElements = this.countElements(sqlCount.toString(), null);
			final List<ProcessoNegocioDTO> result = new ArrayList<ProcessoNegocioDTO>();
			taskPage = this.makePage(result, pageable, totalElements);
			
		} else {
			if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
				sql = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, selectQueryPiece.toString(), orderBy.toString(), fromWhereQueryPiece.toString());
			} else {
				selectQueryPiece.append(fromWhereQueryPiece);
				selectQueryPiece.append(orderBy);
				sql = PagingQueryUtil.concatPagingPieceOnQuery(pageable, selectQueryPiece.toString(), MAIN_SGBD);
			}
			
			lista = this.execSQL(sql, null);
			
			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idProcessoNegocio");
			listRetorno.add("nomeProcessoNegocio");
			listRetorno.add("processoNegocioCliente");
			
			List<ProcessoNegocioDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
			taskPage = new PageImpl<ProcessoNegocioDTO>(result, pageable, 1L);
		}
		
		return taskPage;
	}
}
