package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProcessoNegocioTiposFluxoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class ProcessoNegocioTiposFluxoDAO extends CrudDaoDefaultImpl {

	public ProcessoNegocioTiposFluxoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<ProcessoNegocioTiposFluxoDTO> getBean() {
		return ProcessoNegocioTiposFluxoDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idProcessoNegocioTiposFluxo", "idProcessoNegocioTiposFluxo", true, true, false, false));
		listFields.add(new Field("idProcessoNegocio", "idProcessoNegocio", false, false, false, false));
		listFields.add(new Field("idTipoFluxo", "idTipoFluxo", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "ProcessoNegocioTiposFluxo";
	}

	@SuppressWarnings("unchecked")
	public Collection<ProcessoNegocioTiposFluxoDTO> findIdsTiposFluxoByIdProcessoNegocio(final Integer idProcessoNegocio) throws PersistenceException {
		StringBuilder sb = new StringBuilder();

		sb.append("SELECT ");
		sb.append(this.getNamesFieldsStr("pntf")).append(" ");
		sb.append("FROM ");
		sb.append("	ProcessoNegocioTiposFluxo pntf ");
		sb.append("	INNER JOIN bpm_fluxo f on pntf.idTipoFluxo = f.idTipoFluxo ");
		sb.append("WHERE ");
		sb.append("	pntf.idProcessoNegocio = ? ");
		sb.append("ORDER BY ");
		sb.append(" pntf.idTipoFluxo");

		List<Integer> parameters = new ArrayList<Integer>();
		parameters.add(idProcessoNegocio);

		final List<?> lista = this.execSQL(sb.toString(), parameters.toArray());

		return engine.listConvertion(this.getBean(), lista, this.getListNamesFieldClass());
	}

	public void deleteAllTiposFluxoFromProcessoNegocio(final Integer idProcessoNegocio) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProcessoNegocio", idProcessoNegocio));
		super.deleteByCondition(condicao);
	}

}