package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProcessoNegocioUnidadesDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ProcessoNegocioUnidadesDAO extends CrudDaoDefaultImpl {

	public ProcessoNegocioUnidadesDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class getBean() {
		return ProcessoNegocioUnidadesDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idProcessoNegocioUnidades", "idProcessoNegocioUnidades", true, true, false, false));
		listFields.add(new Field("idProcessoNegocio", "idProcessoNegocio", false, false, false, false));
		listFields.add(new Field("idUnidade", "idUnidade", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "ProcessoNegocioUnidades";
	}
	
	public Collection<ProcessoNegocioUnidadesDTO> findIdsUnidadesByIdProcessoNegocio(final Integer idProcessoNegocio) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idUnidade"));
		condicao.add(new Condition("idProcessoNegocio", idProcessoNegocio));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteAllUnidadesFromProcessoNegocio(final Integer idProcessoNegocio) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProcessoNegocio", idProcessoNegocio));
		super.deleteByCondition(condicao);
	}

}
