package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ProjetoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("unchecked")
public class ProjetoDao extends CrudDaoDefaultImpl {

	public ProjetoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<ProjetoDTO> getBean() {
		return ProjetoDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDPROJETO", "idProjeto", true, true, false, false));
		listFields.add(new Field("IDPROJETOPAI", "idProjetoPai", false, false, false, false));
		listFields.add(new Field("IDCLIENTE", "idCliente", false, false, false, false));
		listFields.add(new Field("idContrato", "idContrato", false, false, false, false));
		listFields.add(new Field("NOMEPROJETO", "nomeProjeto", false, false, false, false));
		listFields.add(new Field("DETALHAMENTO", "detalhamento", false, false, false, false));
		listFields.add(new Field("SITUACAO", "situacao", false, false, false, false));
		listFields.add(new Field("valorEstimado", "valorEstimado", false, false, false, false));
		listFields.add(new Field("idOs", "idOs", false, false, false, false));
		listFields.add(new Field("sigla", "sigla", false, false, false, false));
		listFields.add(new Field("emergencial", "emergencial", false, false, false, false));
		listFields.add(new Field("severidade", "severidade", false, false, false, false));
		listFields.add(new Field("nomeGestor", "nomeGestor", false, false, false, false));
		listFields.add(new Field("idRequisicaoMudanca", "idRequisicaoMudanca", false, false, false, false));
		listFields.add(new Field("idLiberacao", "idLiberacao", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "PROJETOS";
	}

	@Override
	public Collection<ProjetoDTO> find(IDto obj) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("deleted", Condition.IS, null));
		ordenacao.add(new Order("nomeProjeto"));
		return super.findByCondition(condicao, ordenacao);
	}

	@Override
	public Collection<ProjetoDTO> list() throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("deleted", Condition.IS, null));
		ordenacao.add(new Order("nomeProjeto"));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection<ProjetoDTO> findByIdCliente(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idCliente", "=", parm));
		condicao.add(new Condition("deleted", "is", null));
		ordenacao.add(new Order("nomeProjeto"));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection<ProjetoDTO> findSemPai(Integer idCliente) throws PersistenceException {
		Integer cli = -1;
		if (idCliente != null) {
			cli = idCliente;
		}

		Object[] objs = new Object[] { cli, cli };
		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append("	idProjeto,");
		sb.append("	idProjetoPai,");
		sb.append("	nomeProjeto,");
		sb.append("	situacao ");
		sb.append("FROM ");
		sb.append("	projetos ");
		sb.append("WHERE ");
		sb.append("	idProjetoPai is null ");
		sb.append("	and (? = -1 or ? = idCliente) ");
		sb.append("	and deleted is null ");
		sb.append("ORDER BY ");
		sb.append("	idProjeto");

		List<?> lista = this.execSQL(sb.toString(), objs);

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProjeto");
		listRetorno.add("idProjetoPai");
		listRetorno.add("nomeProjeto");
		listRetorno.add("situacao");

		List<ProjetoDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
		return result;
	}

	public Collection<ProjetoDTO> findByIdPai(Integer idPai, Integer idCliente) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idProjetoPai", idPai));
		condicao.add(new Condition("deleted", Condition.IS, null));
		if (idCliente != null) {
			condicao.add(new Condition("idCliente", idCliente));
		}
		ordenacao.add(new Order("idProjeto"));
		return super.findByCondition(condicao, ordenacao);
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	public Collection<ProjetoDTO> findByIdMedidaResposta(Integer idMedidaResposta) throws PersistenceException {
		List<Integer> param = new ArrayList<Integer>();

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append("	proj.idProjeto,");
		sb.append("	proj.nomeProjeto ");
		sb.append("FROM ");
		sb.append("	projetos proj ");
		sb.append("	INNER JOIN medidarespostaprojeto mrp on proj.idProjeto = mrp.idProjeto ");
		sb.append("WHERE ");
		sb.append("	proj.deleted is null ");
		sb.append("	and mrp.idMedidaResposta = ? ");
		sb.append("ORDER BY ");
		sb.append("	proj.idProjeto");

		param.add(idMedidaResposta);

		List<?> lista = this.execSQL(sb.toString(), param.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProjeto");
		listRetorno.add("nomeProjeto");

		List<ProjetoDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
		return result;
	}

}
