package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.RecursoProjetoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class RecursoProjetoDao extends CrudDaoDefaultImpl {
	public RecursoProjetoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idProjeto" ,"idProjeto", true, false, false, false));
		listFields.add(new Field("idEmpregado" ,"idEmpregado", true, false, false, false));
		listFields.add(new Field("custoHora" ,"custoHora", false, false, false, false));
		return listFields;
	}
	@Override
	public String getTableName() {
		return getOwner() + "RecursoProjeto";
	}
	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return RecursoProjetoDTO.class;
	}
	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}
	public Collection findByIdProjeto(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idProjeto", "=", parm));
		ordenacao.add(new Order("idEmpregado"));
		return super.findByCondition(condicao, ordenacao);
	}
	public void deleteByIdProjeto(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idProjeto", "=", parm));
		super.deleteByCondition(condicao);
	}
	public Collection findByIdEmpregado(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idEmpregado", "=", parm));
		ordenacao.add(new Order("idProjeto"));
		return super.findByCondition(condicao, ordenacao);
	}
	public void deleteByIdEmpregado(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idEmpregado", "=", parm));
		super.deleteByCondition(condicao);
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.02.2016
	 * @param idProjeto
	 * @return Collection<RecursoProjetoDTO>
	 * @throws PersistenceException
	 */
	@SuppressWarnings("unchecked")
	public List<RecursoProjetoDTO> findRecursoProjetoComEmpregadoByIdProjeto(Integer idProjeto) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		recursoProjeto.idProjeto, ");
		sqlBuilder.append("		recursoProjeto.idEmpregado, ");
		sqlBuilder.append("		recursoProjeto.custoHora, ");
		sqlBuilder.append("		empregados.nome ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		recursoProjeto recursoProjeto ");
		sqlBuilder.append("		INNER JOIN empregados empregados ");
		sqlBuilder.append("			ON recursoProjeto.idEmpregado = empregados.idEmpregado ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		recursoProjeto.idProjeto = ? ");
		sqlBuilder.append("	ORDER  BY empregados.nome ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idProjeto);

		listResultado = execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProjeto");
		listRetorno.add("idEmpregado");
		listRetorno.add("custoHora");
		listRetorno.add("nomeEmpregado");

		List<RecursoProjetoDTO> listaRecursoProjeto = engine.listConvertion(RecursoProjetoDTO.class, listResultado, listRetorno);
		

		if (listaRecursoProjeto != null && !listaRecursoProjeto.isEmpty()) {
			return listaRecursoProjeto;
		}
				
		return Collections.emptyList();
	}
}
