package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.RequisitosNivelServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author douglas.japiassu
 * @since 19.10.2015
 */
public class RequisitosNivelServicoDao extends CrudDaoDefaultImpl {
	private static final String TABLE_NAME = "requisitosnivelservico";

	public RequisitosNivelServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return TABLE_NAME;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		
		listFields.add(new Field("idRequisitosNivelServico", "idRequisitosNivelServico", true, true, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("dataInicioServico", "dataInicioServico", false, false, false, false));
		listFields.add(new Field("idServicoNegocio", "idServicoNegocio", false, false, false, false));
		listFields.add(new Field("donoDoServico", "donoDoServico", false, false, false, false));
		listFields.add(new Field("especificacao", "especificacao", false, false, false, false));
		listFields.add(new Field("contexto", "contexto", false, false, false, false));
		listFields.add(new Field("funcionalidadesEssenciais", "funcionalidadesEssenciais", false, false, false, false));
		listFields.add(new Field("seguranca", "seguranca", false, false, false, false));
		listFields.add(new Field("disponibilidade", "disponibilidade", false, false, false, false));
		listFields.add(new Field("capacidade", "capacidade", false, false, false, false));
		listFields.add(new Field("continuidadeDoNegocio", "continuidadeDoNegocio", false, false, false, false));
		listFields.add(new Field("performanceDesempenho", "performanceDesempenho", false, false, false, false));
		listFields.add(new Field("interrupcoesPlanejadas", "interrupcoesPlanejadas", false, false, false, false));
		listFields.add(new Field("gestaoDeIncidentes", "gestaoDeIncidentes", false, false, false, false));
		listFields.add(new Field("gestaoDeProblemas", "gestaoDeProblemas", false, false, false, false));
		listFields.add(new Field("gestaoDeMudancas", "gestaoDeMudancas", false, false, false, false));
		listFields.add(new Field("conformidadeInterna", "conformidadeInterna", false, false, false, false));
		listFields.add(new Field("conformidadeExterna", "conformidadeExterna", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));
		listFields.add(new Field("idempregado", "idEmpregado", false, false, false, false));
		
		return listFields;
	}

	@SuppressWarnings("unchecked")
	public Collection<RequisitosNivelServicoDTO> findByIdServicoNegocio(final Integer idServicoNegocio) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServicoNegocio", idServicoNegocio));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();
		
		return this.findByCondition(condicao, ordenacao);
	}

	@Override
	public Class<RequisitosNivelServicoDTO> getBean() {
		return RequisitosNivelServicoDTO.class;
	}
	
}
