package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.RiscoContDTO;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class RiscoContDAO extends CrudDaoDefaultImpl {

	public RiscoContDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "RISCOCONT";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDRISCO", "idRisco", true, true, false, false));
		listFields.add(new Field("IDCATEGORIARISCO", "idCategoriaRisco", false, false, false, false));
		listFields.add(new Field("NOMERISCO", "nomeRisco", false, false, false, false));
		listFields.add(new Field("DATAFIM", "datafim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class getBean() {
		return RiscoContDTO.class;
	}


}
