package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoAutoRelacionamentoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ServicoAutoRelacionamentoDao extends CrudDaoDefaultImpl {
	
	public ServicoAutoRelacionamentoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		
		listFields.add(new Field("idServicoAutoRelacionamento", "idServicoAutoRelacionamento", true, true, false, false));
		listFields.add(new Field("idServico", "idServico", false, false, false, false));
		listFields.add(new Field("idServicoRelacionado", "idServicoRelacionado", false, false, false, false));
		listFields.add(new Field("faseServico", "faseServico", false, false, false, false));
		listFields.add(new Field("statusServico", "statusServico", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		
		return listFields;
	}


	@Override
	public String getTableName() {
		return this.getOwner() + "servicoautorelacionamento";
	}

	@Override
	public Class<ServicoAutoRelacionamentoDTO> getBean() {
		return ServicoAutoRelacionamentoDTO.class;
	}
	
	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}
	
	@SuppressWarnings("unchecked")
	public ServicoAutoRelacionamentoDTO findServicoRelacionado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		
		condicao.add(new Condition("idServico", idServico));
		condicao.add(new Condition("idServicoRelacionado", idServicoRelacionado));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		
		List<ServicoAutoRelacionamentoDTO> servicoAutoRelacionamento = (List<ServicoAutoRelacionamentoDTO>) this.findByCondition(condicao, ordenacao);
		
		if (servicoAutoRelacionamento == null || servicoAutoRelacionamento.isEmpty()) {
			return null;
		}
		
		return servicoAutoRelacionamento.get(0);
	}
	
	@SuppressWarnings("unchecked")
	public ServicoAutoRelacionamentoDTO findServicoRelacionadoDeletado(Integer idServico, Integer idServicoRelacionado) throws Exception {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		
		condicao.add(new Condition("idServico", idServico));
		condicao.add(new Condition("idServicoRelacionado", idServicoRelacionado));
		condicao.add(new Condition("dataFim", Condition.IS_NOT, null));
		
		List<ServicoAutoRelacionamentoDTO> servicoAutoRelacionamento = (List<ServicoAutoRelacionamentoDTO>) this.findByCondition(condicao, ordenacao);
		
		if (servicoAutoRelacionamento == null || servicoAutoRelacionamento.isEmpty()) {
			return null;
		}
		
		return servicoAutoRelacionamento.get(0);
	}

	/**
	 * Lista os servios relacionados diponveis para serem vinculados ao contrato
	 * 
	 * Query deve estar de acordo com a lookup LOOKUP_SERVICOS_VINCULAR_CONTRATO e com os filtros da funo gerenciamentoPortfolioVinculoServicoContrato > abreLookupListaServicosContrato
	 * 
	 * @see br.com.centralit.citcorpore.util.Enumerated.OcorrenciaServicoAcoes
	 * @param idPortfolioServico
	 * @param idServicoRelacionado
	 * @param tipoServico
	 * @param idContrato
	 * @return
	 * @throws Exception
	 * 
	 * @author deborah.ferreira
	 * @since 07.08.2016
	 */
	@SuppressWarnings("unchecked")
	public List<Integer> listIdsServicosRelacionadosVincularContrato(Integer idPortfolioServico, Integer idServicoRelacionado, String tipoServico, Integer idContrato) throws Exception {
		List<Object> listResultado = new ArrayList<>();
		List<Object> listParametro = new ArrayList<>();
		List<Integer> listIdsServicos = new ArrayList<>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("SELECT ");
		sqlBuilder.append("		serv.idServico ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("		servico serv ");
		sqlBuilder.append("	INNER JOIN ");
		sqlBuilder.append(" 	servicoautorelacionamento auto ");
		sqlBuilder.append(" 		ON serv.idservico = auto.idservico ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("		(UPPER(deleted) <> 'Y' OR deleted IS NULL)  ");
		sqlBuilder.append("		AND auto.dataFim IS NULL ");
		sqlBuilder.append("		AND serv.idPortfolioServico = ? ");
		sqlBuilder.append("		AND auto.idServicoRelacionado = ? ");
		sqlBuilder.append("		AND serv.tipoServico = ? ");
		sqlBuilder.append("		AND serv.idservico NOT IN ( ");
		sqlBuilder.append("			SELECT ");
		sqlBuilder.append("				idservico ");
		sqlBuilder.append("			FROM ");
		sqlBuilder.append("				servicocontrato ");
		sqlBuilder.append("			WHERE ");
		sqlBuilder.append("				idservico = serv.idservico ");
		sqlBuilder.append("				AND idcontrato = ? ");
		sqlBuilder.append("				AND (UPPER(deleted) = 'N' OR deleted IS NULL) ");
		sqlBuilder.append("		) ");
		sqlBuilder.append("ORDER BY ");
		sqlBuilder.append("		serv.idServico ");

		listParametro.add(idPortfolioServico);
		listParametro.add(idServicoRelacionado);
		listParametro.add(tipoServico);
		listParametro.add(idContrato);
		
		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());
		
		if(listResultado != null && !listResultado.isEmpty()) {
			for(Object obj : listResultado) {
				Object[] objs = (Object[]) obj;
				Integer idServicoVincular = null;
				
				try {
					idServicoVincular = Integer.parseInt(String.valueOf(objs[0]));
				} catch (Exception e) {
					e.printStackTrace();
				}
				
				if(idServicoVincular != null) {
					listIdsServicos.add(idServicoVincular);
				}
			}
		}
		
		if(!listIdsServicos.isEmpty()) {
			return listIdsServicos;
		}
		
		return Collections.emptyList();
	}

}