package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.VinculoServicoProprietariosDTO;
import br.com.centralit.citcorpore.util.Util;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class ServicoBaseConhecimentoDAO  extends CrudDaoDefaultImpl {

	@Override
	public String getTableName() {
		return "ServicoBaseConhecimento";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idServicoBaseConhecimento", "idServicoBaseConhecimento", true, true, false, false));
		listFields.add(new Field("idServico", "idServico", false, false, false, false));
		listFields.add(new Field("idBaseConhecimento", "idBaseConhecimento", false, false, false, false));
		return listFields;
	}

	@Override
	public Class<ServicoBaseConhecimentoDTO> getBean() {
		return ServicoBaseConhecimentoDTO.class;
	}
	
	public ServicoBaseConhecimentoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	@SuppressWarnings("unchecked")
	public Collection<ServicoBaseConhecimentoDTO> findConhecimentosByServico(Integer idServico, String like) throws Exception{
		try{
			StringBuilder sql = new StringBuilder();
			List<Object> parametros = new ArrayList<Object>();
			List<VinculoServicoProprietariosDTO> result = new ArrayList<VinculoServicoProprietariosDTO>();
			Collection<ServicoBaseConhecimentoDTO> listaVinculo;
			
			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idServicoBaseConhecimento");
			listRetorno.add("idServico");
			listRetorno.add("idBaseConhecimento");
			if(like==null || like.equals("")){

				
				sql.append("SELECT * ");
				sql.append("FROM SERVICOBASECONHECIMENTO ");
				sql.append("WHERE IDSERVICO = ?");
				parametros.add(idServico);
					
				result = this.execSQL(sql.toString(), parametros.toArray());
				listaVinculo = this.engine.listConvertion(getBean(), result, listRetorno);
					
				return listaVinculo;
			}else{
				
				sql.append("SELECT SBC.IDSERVICOBASECONHECIMENTO, SBC.IDSERVICO, SBC.IDBASECONHECIMENTO ");
				sql.append("FROM SERVICOBASECONHECIMENTO SBC INNER JOIN BASECONHECIMENTO BC ON SBC.idBaseConhecimento = BC.idBaseConhecimento ");
				sql.append("WHERE SBC.IDSERVICO = ? AND ").append(Util.getQueryLikeWithCaseInsensitiveAndAccentInsensitive(MAIN_SGBD, "BC.TITULO", like));
				parametros.add(idServico);
					
				result = this.execSQL(sql.toString(), parametros.toArray());
				listaVinculo = this.engine.listConvertion(getBean(), result, listRetorno);
				
				return listaVinculo;
			}
		}catch(Exception e){
			e.printStackTrace();
			throw new Exception(e);
		}
	}
	
	public void deletaVinculo(Integer idVinculo) throws Exception{
		try{
			StringBuilder sql = new StringBuilder();
			List<Object> parametros = new ArrayList<Object>();
			
			sql.append("DELETE ");
			sql.append("FROM SERVICOBASECONHECIMENTO ");
			sql.append("WHERE IDSERVICOBASECONHECIMENTO = ?");
			parametros.add(idVinculo);
			this.execUpdate(sql.toString(), parametros.toArray());
		}catch(Exception e){
			e.printStackTrace();
			throw new Exception(e);
		}
	}
}
