package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoContratoCalendarioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class ServicoContratoCalendarioDAO extends CrudDaoDefaultImpl {

	public ServicoContratoCalendarioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "servicoContratoCalendario";
	}

	@Override
	public Collection<Field> getFields() {
		final List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idServicoContratoCalendario", "idServicoContratoCalendario", true, true, false, false));
		listFields.add(new Field("idServicoContrato", "idServicoContrato", false, false, false, false));
		listFields.add(new Field("idCalendario", "idCalendario", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<ServicoContratoCalendarioDTO> getBean() {
		return ServicoContratoCalendarioDTO.class;
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	@SuppressWarnings("unchecked")
	public Page<ServicoContratoCalendarioDTO> listCalendario(Integer idServicoContrato, String filtroContratoCalendario, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
		Page<ServicoContratoCalendarioDTO> taskPage;

		StringBuilder selectQueryPiece = new StringBuilder("SELECT ");
		selectQueryPiece.append("	servicoContratoCalendario.idServicoContratoCalendario, ");
		selectQueryPiece.append("	servicoContratoCalendario.idServicoContrato, ");
		selectQueryPiece.append("	servicoContratoCalendario.idCalendario, ");
		selectQueryPiece.append("	calendario.descricao, ");
		selectQueryPiece.append("	servicoContratoCalendario.dataInicio, ");
		selectQueryPiece.append("	servicoContratoCalendario.dataFim ");

		StringBuilder orderBy = new StringBuilder(" ORDER BY servicoContratoCalendario.idServicoContratoCalendario DESC ");

		StringBuilder fromWhereQueryPiece = new StringBuilder("FROM ");
		fromWhereQueryPiece.append("	servicoContratoCalendario servicoContratoCalendario ");
		fromWhereQueryPiece.append("	INNER JOIN calendario calendario ON servicoContratoCalendario.idCalendario = calendario.idCalendario");
		fromWhereQueryPiece.append(" WHERE ");
		fromWhereQueryPiece.append(" servicoContratoCalendario.idServicoContrato = ").append(idServicoContrato);

		if (UtilStrings.isNotVazio(filtroContratoCalendario)) {
			try {
				Integer idCalendario = Integer.parseInt(filtroContratoCalendario);
				fromWhereQueryPiece.append(" and (servicoContratoCalendario.idCalendario = " + idCalendario + " ");
				fromWhereQueryPiece.append(" or upper(calendario.descricao) like upper('%" + filtroContratoCalendario + "%') ");
			} catch (Exception e) {
				fromWhereQueryPiece.append(" and upper(calendario.descricao) like upper('%" + filtroContratoCalendario + "%') ");
			}
		}

		String sql = "";
		List<Object> lista = new ArrayList<Object>();
		if (isTotalizacao) {
			final StringBuilder sqlCount = this.countQueryPiece(fromWhereQueryPiece);
			final Long totalElements = this.countElements(sqlCount.toString(), null);
			final List<ServicoContratoCalendarioDTO> result = new ArrayList<ServicoContratoCalendarioDTO>();
			taskPage = this.makePage(result, pageable, totalElements);

		} else {
			if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
				sql = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, selectQueryPiece.toString(), orderBy.toString(), fromWhereQueryPiece.toString());
			} else {
				selectQueryPiece.append(fromWhereQueryPiece);
				selectQueryPiece.append(orderBy);
				sql = PagingQueryUtil.concatPagingPieceOnQuery(pageable, selectQueryPiece.toString(), MAIN_SGBD);
			}

			lista = this.execSQL(sql, null);

			List<String> listRetorno = new ArrayList<String>();
			listRetorno.add("idServicoContratoCalendario");
			listRetorno.add("idServicoContrato");
			listRetorno.add("idCalendario");
			listRetorno.add("nomeCalendario");
			listRetorno.add("dataInicio");
			listRetorno.add("dataFim");

			List<ServicoContratoCalendarioDTO> result = this.engine.listConvertion(getBean(), lista, listRetorno);
			taskPage = new PageImpl<ServicoContratoCalendarioDTO>(result, pageable, 1L);
		}

		return taskPage;
	}

	public Boolean existeCalendarioAtivoByServicoContrato(Integer idServicoContrato) throws Exception {
		StringBuilder sb = new StringBuilder();

		sb.append("SELECT ");
		sb.append(getNamesFieldsStr()).append(" ");
		sb.append("FROM ");
		sb.append(getTableName()).append(" ");
		sb.append("WHERE ");
		sb.append("	idServicoContrato = ").append(idServicoContrato).append(" ");
		sb.append("	and (dataFim is null) ");
		sb.append("ORDER BY ");
		sb.append("	idServicoContratoCalendario desc");

		List<?> list = this.execSQL(sb.toString(), null);

		if (list != null && !list.isEmpty()) {
			return true;
		}

		return false;
	}
	
	public Collection<ServicoContratoCalendarioDTO> getServicoContratoCalendarioDTOAtivoByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idServicoContrato", Condition.EQUALS, idServicoContrato));
		condicao.add(new Condition("dataFim", Condition.IS, null));
		return this.findByCondition(condicao, new ArrayList<>());
	}

}
