package br.com.centralit.citcorpore.integracao;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import br.com.centralit.bpm.util.Enumerated.FlowInstanceStatus;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class ServicoContratoDao extends CrudDaoDefaultImpl {
    public ServicoContratoDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    public static String strSGBDPrincipal = null;

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<>();

        listFields.add(new Field("idServicoContrato", "idServicoContrato", true, true, false, false));
        listFields.add(new Field("idServico", "idServico", false, false, false, false));
        listFields.add(new Field("idContrato", "idContrato", false, false, false, false));
        listFields.add(new Field("idCondicaoOperacao", "idCondicaoOperacao", false, false, false, false));
        listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
        listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
        listFields.add(new Field("observacao", "observacao", false, false, false, false));
        listFields.add(new Field("custo", "custo", false, false, false, false));
        listFields.add(new Field("restricoesPressup", "restricoesPressup", false, false, false, false));
        listFields.add(new Field("objetivo", "objetivo", false, false, false, false));
        listFields.add(new Field("permiteSLANoCadInc", "permiteSLANoCadInc", false, false, false, false));
        listFields.add(new Field("linkProcesso", "linkProcesso", false, false, false, false));
        listFields.add(new Field("descricaoProcesso", "descricaoProcesso", false, false, false, false));
        listFields.add(new Field("tipoDescProcess", "tipoDescProcess", false, false, false, false));
        listFields.add(new Field("areaRequisitante", "areaRequisitante", false, false, false, false));
        listFields.add(new Field("idModeloEmailCriacao", "idModeloEmailCriacao", false, false, false, false));
        listFields.add(new Field("idModeloEmailFinalizacao", "idModeloEmailFinalizacao", false, false, false, false));
        listFields.add(new Field("idModeloEmailAcoes", "idModeloEmailAcoes", false, false, false, false));
        listFields.add(new Field("idGrupoNivel1", "idGrupoNivel1", false, false, false, false));
        listFields.add(new Field("idGrupoExecutor", "idGrupoExecutor", false, false, false, false));
        listFields.add(new Field("idGrupoAprovador", "idGrupoAprovador", false, false, false, false));
        listFields.add(new Field("idCalendario", "idCalendario", false, false, false, false));
        listFields.add(new Field("permSLATempoACombinar", "permSLATempoACombinar", false, false, false, false));
        listFields.add(new Field("permMudancaSLA", "permMudancaSLA", false, false, false, false));
        listFields.add(new Field("permMudancaCalendario", "permMudancaCalendario", false, false, false, false));
        listFields.add(new Field("deleted", "deleted", false, false, false, false));
        listFields.add(new Field("expandir", "expandir", false, false, false, false));
        listFields.add(new Field("idServicoContratoRelacionado", "idServicoContratoRelacionado", false, false, false, false));
		listFields.add(new Field("custoHoraIndisponibilidade", "custoHoraIndisponibilidade", false, false, false, false));
		listFields.add(new Field("reiniciaSla", "reiniciaSla", false, false, false, false));

        return listFields;
    }

    @Override
    public String getTableName() {
        return this.getOwner() + "ServicoContrato";
    }

    @Override
    public Collection list() throws PersistenceException {
        return null;
    }

    @Override
    public Class getBean() {
        return ServicoContratoDTO.class;
    }

    @Override
    public Collection find(final IDto arg0) throws PersistenceException {
        return null;
    }

    public Collection<ServicoContratoDTO> findByIdServico(final Integer parm) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
		sql.append("SELECT idServicoContrato, idServico, idContrato, deleted, dataInicio, dataFim ");
        sql.append("FROM " + getTableName() + " ");
        sql.append("WHERE idservico = " + parm + " ");
        sql.append("AND (datafim is null or datafim > ? )");
        parametro.add(UtilDatas.getDataAtual());
        list = this.execSQL(sql.toString(), parametro.toArray());
        final List listRetorno = new ArrayList();
		listRetorno.add("idServicoContrato");
        listRetorno.add("idServico");
        listRetorno.add("idContrato");
        listRetorno.add("deleted");
        listRetorno.add("dataInicio");
        listRetorno.add("dataFim");

        final List result = engine.listConvertion(getBean(), list, listRetorno);
        if (result == null || result.size() == 0) {
            return null;
        } else {
            return result;
        }
    }

    public void deleteByIdServico(final Integer parm) throws PersistenceException {
        final List condicao = new ArrayList();
        condicao.add(new Condition("idServico", "=", parm));
        super.deleteByCondition(condicao);
    }

    public Collection<ServicoContratoDTO> findByIdContrato(final Integer parm) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
        sql.append("SELECT " + this.getNamesFieldsStr() + " ");
        sql.append("FROM " + getTableName() + " ");
        sql.append("WHERE idContrato = ? ");
        sql.append("AND (deleted is null or deleted <> 'y')");

        parametro.add(parm);

        list = this.execSQL(sql.toString(), parametro.toArray());

        final List listRetorno = this.getListNamesFieldClass();

        List result = new ArrayList();
        result = engine.listConvertion(getBean(), list, listRetorno);

        return result;

    }

    public Collection<ServicoContratoDTO> findServicoComNomeByIdContrato(final Integer parm) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
        sql.append("SELECT sc.idservicocontrato, s.nomeservico FROM servicocontrato sc ");
        sql.append("inner join servico s on s.idservico = sc.idservico WHERE idContrato = ? ");
        sql.append("AND (sc.deleted is null or sc.deleted <> 'y')");

        parametro.add(parm);

        list = this.execSQL(sql.toString(), parametro.toArray());

        final List listRetorno = new ArrayList();
        listRetorno.add("idServicoContrato");
        listRetorno.add("nomeServico");

        List result = new ArrayList();
        result = engine.listConvertion(getBean(), list, listRetorno);

        return result;

    }

    public Collection<ServicoContratoDTO> findByIdContratoDistinct(final Integer idContrato) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
        sql.append("SELECT distinct servicocontrato.idServico ");
        sql.append("FROM servicocontrato ");
        sql.append("INNER JOIN servico ON servico.idservico = servicocontrato.idservico ");
        sql.append("WHERE servicocontrato.idcontrato = " + idContrato);
        list = this.execSQL(sql.toString(), parametro.toArray());
        final List listRetorno = new ArrayList();
        listRetorno.add("idServico");

        final List result = engine.listConvertion(getBean(), list, listRetorno);
        if (result == null || result.size() == 0) {
            return null;
        } else {
            return result;
        }
    }

    public Collection<ServicoContratoDTO> findServicoContratoByIdContrato(final Integer idContrato) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
        sql.append("SELECT servicocontrato.idServicoContrato, servico.nomeServico, servico.idServico ");
        sql.append("FROM servicocontrato servicocontrato ");
        sql.append("INNER JOIN servico servico ON servicocontrato.idservico = servico.idservico ");
        sql.append("WHERE servicocontrato.idContrato = " + idContrato);
        sql.append(" AND (servicocontrato.deleted is null or servicocontrato.deleted <> 'y') ");
        sql.append("order by servico.nomeservico ");
        list = this.execSQL(sql.toString(), parametro.toArray());
        final List listRetorno = new ArrayList();
        listRetorno.add("idServicoContrato");
        listRetorno.add("nomeServico");
        listRetorno.add("idServico");

        final List result = engine.listConvertion(getBean(), list, listRetorno);
        if (result == null || result.size() == 0) {
            return null;
        } else {
            return result;
        }
    }

    /**
	 * Localiza os servios contrato utilizando o id do servio
	 *
	 * @param idServico
	 * @return
	 * @throws Exception
	 */
    public Collection<ServicoContratoDTO> findServicoContratoByIdServico(final Integer idServico) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();
        sql.append(" SELECT servicocontrato.idServicoContrato ");
        sql.append(" FROM servicocontrato ");
        sql.append(" WHERE servicocontrato.idServico = " + idServico);
        sql.append(" AND (servicocontrato.deleted is null or servicocontrato.deleted <> 'y') ");

        list = this.execSQL(sql.toString(), parametro.toArray());
        final List listRetorno = new ArrayList();
        listRetorno.add("idServicoContrato");

        final List result = engine.listConvertion(getBean(), list, listRetorno);
        if (result == null || result.size() == 0) {
            return null;
        } else {
            return result;
        }
    }

    /**
	 * Retorna ServicoContrato Ativo de acordo com o idContrato e idServico
	 * informado.
	 *
	 * @param idContrato
	 *            - Identificador do Contrato.
	 * @param idServico
	 *            - Identificador do Servio.
	 * @return ServicoContratoDTO
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    public ServicoContratoDTO findByIdContratoAndIdServico(final Integer idContrato, final Integer idServico)
            throws PersistenceException {

        final StringBuilder sql = new StringBuilder();

        sql.append(" SELECT ");
        sql.append(this.getNamesFieldsStr());
        sql.append(" FROM servicocontrato ");
        sql.append(" WHERE idcontrato = ? AND idservico = ? AND (datafim is null OR datafim > ? ) AND (deleted <> 'y' OR deleted <> 'Y' OR deleted is null) ");

        final List parametros = new ArrayList();

        parametros.add(idContrato);
        parametros.add(idServico);
        parametros.add(UtilDatas.getDataAtual());

        final List list = this.execSQL(sql.toString(), parametros.toArray());

        final List<ServicoContratoDTO> listServicoContratoDto = this.listConvertion(this.getBean(), list,
                this.getListNamesFieldClass());

        if (listServicoContratoDto != null && !listServicoContratoDto.isEmpty()) {
            return listServicoContratoDto.get(0);
        } else {
            return null;
        }

    }

    /**
     * @author euler.ramos
     * @return
     * @throws Exception
     */
    public ServicoContratoDTO findByIdServicoContrato(final Integer idServicoContrato) throws PersistenceException {

        final StringBuilder sql = new StringBuilder();

		sql.append("SELECT servicocontrato.idServicoContrato, servico.nomeServico, servicocontrato.custohoraindisponibilidade ");
        sql.append("FROM servicocontrato JOIN servico servico ON servicocontrato.idservico = servico.idservico ");
        sql.append("WHERE idservicocontrato = ? AND (servicocontrato.datafim is null OR servicocontrato.datafim > ? ) AND (servicocontrato.deleted <> 'y' OR servicocontrato.deleted <> 'Y' OR servicocontrato.deleted is null) ");

        final List parametros = new ArrayList();
        final List listaRetorno = new ArrayList();

        listaRetorno.add("idServicoContrato");
        listaRetorno.add("nomeServico");
		listaRetorno.add("custohoraindisponibilidade");

        parametros.add(idServicoContrato);
        parametros.add(UtilDatas.getDataAtual());

        final List list = this.execSQL(sql.toString(), parametros.toArray());

        final List<ServicoContratoDTO> listServicoContratoDto = this.listConvertion(this.getBean(), list, listaRetorno);

        if (listServicoContratoDto != null && !listServicoContratoDto.isEmpty()) {
            return listServicoContratoDto.get(0);
        } else {
            return null;
        }

    }

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	public ServicoContratoDTO listByIdServicoContrato(final Integer idServicoContrato) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idServicoContrato", idServicoContrato));
		ordenacao.add(new Order("idServicoContrato"));

		final List<ServicoContratoDTO> listServicoContrato = (List<ServicoContratoDTO>) super.findByCondition(condicao, ordenacao);

		if (listServicoContrato != null && !listServicoContrato.isEmpty()) {
			return listServicoContrato.iterator().next();
		}

		return null;
	}

    public void deleteByIdContrato(final Integer parm) throws PersistenceException {
        final List condicao = new ArrayList();
        condicao.add(new Condition("idContrato", "=", parm));
        super.deleteByCondition(condicao);
    }

    public void setDataFim(final Integer idServicoContrato) throws PersistenceException {

        final ServicoContratoDTO servicoContratoDto = new ServicoContratoDTO();

        servicoContratoDto.setIdServicoContrato(idServicoContrato);
        servicoContratoDto.setDataFim(UtilDatas.getDataAtual());

        super.updateNotNull(servicoContratoDto);
    }

    public Collection<ServicoContratoDTO> findByIdFornecedor(final Integer idFornecedor) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List list = new ArrayList();

        final Collection fields = getFields();
        final List listaNomes = new ArrayList();
        sql.append("SELECT ");
        int i = 0;
        for (final Iterator it = fields.iterator(); it.hasNext();) {
            final Field field = (Field) it.next();
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("sc." + field.getFieldDB());
            listaNomes.add(field.getFieldClass());
            i++;
        }

        sql.append(" FROM " + getTableName());
        sql.append(" sc INNER JOIN contratos c ON c.idcontrato = sc.idcontrato WHERE c.idfornecedor = ? ");

        parametro.add(idFornecedor);

        list = this.execSQL(sql.toString(), parametro.toArray());

        final List result = engine.listConvertion(getBean(), list, listaNomes);
        if (result == null || result.size() == 0) {
            return null;
        } else {
            return result;
        }
    }

    public boolean validaServicoContrato(final Integer idContrato, final Integer idServico) throws PersistenceException {

        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();

        List list = new ArrayList();
        sql.append("SELECT idServicoContrato ");
        sql.append("FROM " + getTableName() + " ");
        sql.append("WHERE idContrato = ? ");
        sql.append("AND idServico = ? ");
        sql.append("AND deleted IS NULL ");

        parametro.add(idContrato);
        parametro.add(idServico);

        list = this.execSQL(sql.toString(), parametro.toArray());
        final List listRetorno = new ArrayList();
        listRetorno.add("idServicoContrato");

        final List result = engine.listConvertion(getBean(), list, listRetorno);
        if (result == null || result.size() == 0) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param idServicoContrato
     * @param data
     * @throws PersistenceException
     * @author cledson.junioro
     */
    public void updateServicoContrato(final Integer idServicoContrato, final Date data) throws PersistenceException {
        final List parametros = new ArrayList();
        if (data != null) {
            parametros.add(data);
        } else {
            parametros.add(null);
        }
        parametros.add("y");
        parametros.add(idServicoContrato);
        final String sql = "UPDATE " + getTableName() + " SET datafim = ?, deleted = ? WHERE idServicoContrato = ?";
        execUpdate(sql, parametros.toArray());
    }

    /**
	 * @param servicoContratoDTO
	 * @param paginaSelecionada
	 * @param itensPorPagina
	 * @param campoPesquisa
	 * @return
	 * @throws Exception
	 * @author cledson.junioro
	 *
	 *         Paginao da tela Administrao de Contratos
	 *
	 *         TODO: [douglas.japiassu]
	 */
    public Collection<ServicoContratoDTO> findByIdContratoPaginada(final ServicoContratoDTO servicoContratoDTO, Pageable pageable, final String campoPesquisa) throws PersistenceException {
        Page<ServicoContratoDTO> taskPage;

        StringBuilder selectQueryPiece = new StringBuilder("SELECT ");
		selectQueryPiece.append(this.getNamesFieldsStr("servcont"));

		StringBuilder orderBy = new StringBuilder("ORDER BY serv.nomeServico ");

		StringBuilder fromWhereQueryPiece = new StringBuilder(" FROM ");
		fromWhereQueryPiece.append("	servicocontrato servcont ");
		fromWhereQueryPiece.append("	inner join servico serv on serv.idservico = servcont.idservico ");
		fromWhereQueryPiece.append("WHERE ");
		fromWhereQueryPiece.append(" servcont.idContrato = " + servicoContratoDTO.getIdContrato());
		fromWhereQueryPiece.append(" and serv.tipoServico not in ('" + Enumerados.TipoServico.SERVICO_NEGOCIO.getIdentificador() + "', '" + Enumerados.TipoServico.SERVICO_APOIO.getIdentificador() + "')");
		fromWhereQueryPiece.append(" and (upper(servcont.deleted)  <> 'Y' or servcont.deleted is null) ");
		fromWhereQueryPiece.append(" and (upper(serv.nomeServico) like '%" + campoPesquisa.toUpperCase() + "%'");
		fromWhereQueryPiece.append(" or upper(serv.siglaAbrev) like '%" + campoPesquisa.toUpperCase() + "%')");

		final StringBuilder sqlCount = this.countQueryPiece(fromWhereQueryPiece);
		final Long totalElements = this.countElements(sqlCount.toString(), null);
		List<ServicoContratoDTO> result = new ArrayList<ServicoContratoDTO>();
		taskPage = this.makePage(result, pageable, totalElements);
		servicoContratoDTO.setTotalItens(totalElements.intValue());
		servicoContratoDTO.setTotalPagina(taskPage.getTotalPages());

		String sqlPageable = "";
		List listaPageable = new ArrayList();

		if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
			sqlPageable = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, selectQueryPiece.toString(), orderBy.toString(), fromWhereQueryPiece.toString());
		} else {
			selectQueryPiece.append(fromWhereQueryPiece);
			selectQueryPiece.append(orderBy);
			sqlPageable = PagingQueryUtil.concatPagingPieceOnQuery(pageable, selectQueryPiece.toString(), MAIN_SGBD);
		}

		listaPageable = this.execSQL(sqlPageable, null);

		final List<String> listRetorno = this.getListNamesFieldClass();

		result = this.engine.listConvertion(getBean(), listaPageable, listRetorno);
		taskPage = new PageImpl<ServicoContratoDTO>(result, pageable, 1L);

        return result;
    }

    /**
	 *
	 * @param idServicoContrato
	 *            metodo para buscar por inner join informaes sobre o servico
	 *            pelo idServicoContrato para exibir no carrinho de
	 *            servios(Portal)
	 * @return ServicoDTO
	 * @throws Exception
	 */
    public ServicoContratoDTO findByIdServicoContrato(final Integer idServico, final Integer idContrato)
            throws PersistenceException {
        final List parametro = new ArrayList();
        final List fields = new ArrayList();
        List list = new ArrayList();

		StringBuilder sql = new StringBuilder();

		sql.append("select servicocontrato.idservicocontrato, servicoContrato.custo as valorServico, servico.nomeservico, categoriaservico.nomecategoriaservico "
                + "from servicocontrato servicocontrato "
                + "inner join servico servico on servicocontrato.idservico = servico.idservico "
                + "inner join categoriaservico categoriaservico on servico.idcategoriaservico = categoriaservico.idcategoriaservico "
				+ "and servicocontrato.idservico = ? and servicocontrato.idcontrato = ? "
                + "and (servico.deleted is null OR servico.deleted = 'n') "
				+ "and (servicocontrato.deleted is null OR servicocontrato.deleted = 'n')");

		parametro.add(idServico);
		parametro.add(idContrato);

		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().equalsIgnoreCase("ORACLE")) {
			sql.append("where (servicocontrato.datafim is null or trunc(servicocontrato.datafim) >= to_date(? ,'yyyy-mm-dd'))");
		} else {
			sql.append("where (servicocontrato.datafim is null or servicocontrato.datafim >= (cast(? as date)))");
		}

		parametro.add(UtilDatas.dateToSTRWithFormat(UtilDatas.getDataAtual(), "yyyy-MM-dd"));

		list = this.execSQL(sql.toString(), parametro.toArray());
        fields.add("idServicoContrato");
        fields.add("valorServico");
        fields.add("nomeServico");
        fields.add("nomeCategoriaServico");
        if (list != null && !list.isEmpty()) {
            return (ServicoContratoDTO) this.listConvertion(getBean(), list, fields).get(0);
        } else {
            return null;
        }
    }

    public Collection<ServicoContratoDTO> findAtivosByIdGrupo(final Integer idGrupo) throws PersistenceException {
        final List parametro = new ArrayList();
        final List fields = new ArrayList();
        List list = new ArrayList();
        final String sql = "select servicocontrato.idservicocontrato "
                + "from servicocontrato servicocontrato "
                + "where (servicocontrato.idgruponivel1 = ? or servicocontrato.idgrupoexecutor = ? or servicocontrato.idgrupoaprovador = ?) "
                + "and servicocontrato.datafim is null";

        parametro.add(idGrupo);
        parametro.add(idGrupo);
        parametro.add(idGrupo);
        fields.add("idServicoContrato");
        list = this.execSQL(sql, parametro.toArray());

        if (list != null && !list.isEmpty()) {
            return this.listConvertion(getBean(), list, fields);
        } else {
            return null;
        }
    }

    /**
     * @author euler.ramos
     * @param idCalendario
     * @return
     * @throws Exception
     */
    public ArrayList<ServicoContratoDTO> findByIdCalendario(final Integer idCalendario) throws PersistenceException {
        final List condicao = new ArrayList();
        final List ordenacao = new ArrayList();
        condicao.add(new Condition("idCalendario", "=", idCalendario));
        ordenacao.add(new Order("idServico"));
        final ArrayList<ServicoContratoDTO> result = (ArrayList<ServicoContratoDTO>) super.findByCondition(condicao,
                ordenacao);
        return result == null ? new ArrayList<ServicoContratoDTO>() : result;
    }

    /**
	 * Verifica se existe Solicitao aberta vinculado com servio que est
	 * sendo excludo.
	 *
	 * @param idServico
	 * @return
	 * @throws Exception
	 * @author mario.haysaki
	 */
    public boolean verificaSeExisteSolicitacaoAbertaVinculadoComServico(final Integer idServico,
            final Integer idContrato) throws PersistenceException {

        final StringBuilder sql = new StringBuilder();
        List list = new ArrayList();
        final List parametros = new ArrayList();

        sql.append("select COUNT(*) from solicitacaoservico sol  ");
        sql.append("inner join servicocontrato sc on sol.idservicocontrato = sc.idservicocontrato ");
        sql.append("inner join execucaosolicitacao ex on sol.idsolicitacaoservico = ex.idsolicitacaoservico ");
        sql.append("inner join bpm_instanciafluxo ins on ex.idinstanciafluxo = ins.idinstancia  ");
		sql.append("where  sc.idServico = ? and sc.idContrato = ? and (ins.idStatus != ? and sol.idStatus != ?) ");

        parametros.add(idServico);
        parametros.add(idContrato);
		parametros.add(FlowInstanceStatus.CLOSED.getId());
		parametros.add(ServiceRequestStatus.CLOSED.getId());

        list = this.execSQL(sql.toString(), parametros.toArray());
        Long totalSolLong = 0l;
        BigDecimal totalSolBigDecimal;
        Integer totalSolInteger;
        if (list != null) {
            final Object[] totalSol = (Object[]) list.get(0);
            if (totalSol != null && totalSol.length > 0) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.POSTGRESQL)
                        || CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.MYSQL)) {
                    totalSolLong = (Long) totalSol[0];
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
                    totalSolBigDecimal = (BigDecimal) totalSol[0];
                    totalSolLong = totalSolBigDecimal.longValue();
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
                    totalSolInteger = (Integer) totalSol[0];
                    totalSolLong = Long.valueOf(totalSolInteger);
                }
            }
        }

        return list != null && !list.isEmpty() && totalSolLong > 0;

    }

    /**
	 * Verifica se o servio est vinculado com o Contrato
	 *
	 * @param idSolicitacaoServico
	 * @return
	 * @throws Exception
	 * @author mario.haysaki
	 */
	public boolean verificaServicoEstaVinculadoContrato(final Integer idSolicitacaoServico) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		List list = new ArrayList();
		final List parametros = new ArrayList();

		sql.append("select COUNT(*) from servicocontrato sc ");
		sql.append("inner join solicitacaoservico sol on sol.idservicocontrato = sc.idservicocontrato ");
		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().equalsIgnoreCase("ORACLE")) {
			sql.append("where (sc.datafim is null or trunc(sc.datafim) >= to_date(? ,'yyyy-mm-dd'))");
		} else {
		        /**
			 * Foi necessrio adicionar a funo que realiza o cast. A string
			 * str_dataAtual na sql, ser do tipo date, aceito pelos 3 bd's
			 * (SQLServer, MySQL, PostrgreSQL) alterado por rcs (Rafael Csar
			 * Soyer) - Analista Desenvolvedor - rafael.soyer@centralit.com.br
			 * data: 27/03/2015
			 */
			sql.append("where (sc.datafim is null or sc.datafim >= (cast(? as date)))");
		}
		sql.append(" and (sc.deleted ='n' or sc.deleted is null) and sol.idsolicitacaoservico = ?");

		parametros.add(UtilDatas.dateToSTRWithFormat(UtilDatas.getDataAtual(), "yyyy-MM-dd"));
		parametros.add(idSolicitacaoServico);

		list = this.execSQL(sql.toString(), parametros.toArray());
		Long totalSolLong = 0l;
        BigDecimal totalSolBigDecimal;
        Integer totalSolInteger;
        if (list != null) {
            final Object[] totalSol = (Object[]) list.get(0);
            if (totalSol != null && totalSol.length > 0) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.POSTGRESQL)
                        || CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.MYSQL)) {
                    totalSolLong = (Long) totalSol[0];
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
                    totalSolBigDecimal = (BigDecimal) totalSol[0];
                    totalSolLong = totalSolBigDecimal.longValue();
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
                    totalSolInteger = (Integer) totalSol[0];
                    totalSolLong = Long.valueOf(totalSolInteger);
                }
            }
        }

        return list != null && !list.isEmpty() && totalSolLong > 0;

    }

	public ServicoContratoDTO findByIdSolicitacaoServico(Integer idSolicitacaoServico) throws PersistenceException {

		 final StringBuilder  query = new StringBuilder();

		 query.append("SELECT sc.idgruponivel1, sc.idgrupoexecutor FROM servicocontrato sc ");

 		 query.append("INNER JOIN servico s ON s.idservico = sc.idservico ");

		 query.append("INNER JOIN solicitacaoservico ss ON ss.idservicocontrato = sc.idservicocontrato ");

		 query.append("WHERE ss.idsolicitacaoservico = ?");

		 List<String> fields = new ArrayList<String>();

		 List parametro = new ArrayList<>();

		 parametro.add(idSolicitacaoServico);

	     fields.add("idGrupoNivel1");

	     fields.add("idGrupoExecutor");

	     List list = this.execSQL(query.toString(), parametro.toArray());

        if (list != null && !list.isEmpty()) {
            return (ServicoContratoDTO) this.listConvertion(ServicoContratoDTO.class, list, fields).get(0);
        } else {
            return null;
        }
	}

	public ServicoContratoDTO findByIdServicoContratoWithNome(Integer idServicoContrato) throws PersistenceException {

		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();

		sql.append("SELECT ").append(this.getNamesFieldsStr("sercon")).append(", ser.nomeservico, ser.tiposervico ");
		sql.append(" FROM ").append(getTableName()).append(" sercon ");
		sql.append(" INNER JOIN servico ser ON ser.idservico = sercon.idservico ");
		sql.append("WHERE sercon.idservicocontrato = ? ");
		parametros.add(idServicoContrato);

		List<Object> result = this.execSQL(sql.toString(), parametros.toArray());

		List<Field> fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add(new Field("nomeservico", "nomeServico", false, false, false, false));
		fields.add(new Field("tiposervico", "tipoServico", false, false, false, false));

		List<ServicoContratoDTO> listRetorno = this.engine.listConvertion(getBean(), result, fields);

		if (listRetorno != null && !listRetorno.isEmpty()) {
			return listRetorno.get(0);
		}

		return null;

	}

	public List listServicoContratoFromAcordoServicoContrato(Integer idAcordoNivelServico) throws PersistenceException{
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		List<Object> fields = new ArrayList<>();

		sql.append("SELECT sercon.idservicocontrato, sercon.idservico, sercon.idcontrato, ser.tiposervico, ser.nomeservico ");
		sql.append(" FROM servicocontrato sercon ");
		sql.append(" INNER JOIN servico ser ON ser.idservico = sercon.idservico ");
		sql.append(" INNER JOIN acordoservicocontrato ascon ON ascon.idservicocontrato = sercon.idservicocontrato ");
		sql.append(" WHERE ascon.idacordonivelservico = ? and (ascon.deleted is null or ascon.deleted = 'N' or ascon.deleted = 'n') and ascon.habilitado = 'S'");

		parametros.add(idAcordoNivelServico);

		List result = this.execSQL(sql.toString(), parametros.toArray());

		fields.add("idServicoContrato");
		fields.add("idServico");
		fields.add("idContrato");
		fields.add("tipoServico");
		fields.add("nomeServico");

		return this.engine.listConvertion(getBean(), result, fields);
	}

	public Collection<ServicoContratoDTO> listServicosNegocioByIdContrato(Integer idContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		List<Object> fields = new ArrayList<>();

		sql.append("SELECT sc.idservicocontrato, sc.idservico, sc.idcontrato, s.idportfolioservico, s.nomeservico  ");
		sql.append(" FROM servicocontrato sc ");
		sql.append(" INNER JOIN servico s on s.idservico = sc.idservico ");
		sql.append(" WHERE s.tiposervico like '" + Enumerados.TipoServico.SERVICO_NEGOCIO.getIdentificador() + "' and idcontrato = ? ");
		sql.append(" AND (sc.deleted is null or upper(sc.deleted) <> upper('y')); ");

		parametros.add(idContrato);

		List result = this.execSQL(sql.toString(), parametros.toArray());

		fields.add("idServicoContrato");
		fields.add("idServico");
		fields.add("idContrato");
		fields.add("idPortfolioServico");
		fields.add("nomeServico");

		return this.engine.listConvertion(getBean(), result, fields);
	}

	public Collection<ServicoContratoDTO> listServicosApoioByIdContrato(Integer idContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		List<Object> fields = new ArrayList<>();

		sql.append("SELECT sc.idservicocontrato, sc.idservico, sc.idcontrato, s.idportfolioservico, s.nomeservico  ");
		sql.append(" FROM servicocontrato sc ");
		sql.append(" INNER JOIN servico s on s.idservico = sc.idservico ");
		sql.append(" WHERE s.tiposervico like '" + Enumerados.TipoServico.SERVICO_APOIO.getIdentificador() + "' and idcontrato = ? ");
		sql.append(" AND (sc.deleted is null or upper(sc.deleted) <> upper('y')); ");

		parametros.add(idContrato);

		List result = this.execSQL(sql.toString(), parametros.toArray());

		fields.add("idServicoContrato");
		fields.add("idServico");
		fields.add("idContrato");
		fields.add("idPortfolioServico");
		fields.add("nomeServico");

		return this.engine.listConvertion(getBean(), result, fields);
	}

	public Collection<ServicoContratoDTO> listRequisicoesIncidentesProcedimentosByIdServicoIdContrato(String tipoServico, Integer idPortfolio, Integer idServicoNegocio, Integer idContrato) throws PersistenceException {

		StringBuilder sql = new StringBuilder();

		sql.append("SELECT DISTINCT ");
		sql.append("	servcontrato.idServicoContrato, ");
		sql.append("	servcontrato.idServico, ");
		sql.append("	servcontrato.idContrato, ");
		sql.append("	serv.nomeServico ");

		sql.append("FROM ");
		sql.append("	servico serv ");
		sql.append("	inner join servicoautorelacionamento auto on serv.idservico = auto.idservico ");
		sql.append("	inner join servicocontrato servcontrato on serv.idservico = servcontrato.idservico ");
		sql.append("WHERE ");
		sql.append(" (upper(serv.deleted)  = 'N' or serv.deleted is null) ");
		sql.append(" and (upper(servcontrato.deleted)  = 'N' or servcontrato.deleted is null) ");
		sql.append(" and auto.idservicorelacionado = ? ");
		sql.append(" and servcontrato.idcontrato = ? ");
		sql.append(" and (serv.idportfolioservico = ? OR serv.idportfolioservico is null) ");
		sql.append(" and tipoServico = ? ");

		sql.append("ORDER BY serv.nomeServico ");

		List<Object> parametros = new ArrayList<>();
		parametros.add(idServicoNegocio);
		parametros.add(idContrato);
		parametros.add(idPortfolio);
		parametros.add(tipoServico);

		List result = this.execSQL(sql.toString(), parametros.toArray());

		List<Object> fields = new ArrayList<>();

		fields.add("idServicoContrato");
		fields.add("idServico");
		fields.add("idContrato");
		fields.add("nomeServico");

		return this.engine.listConvertion(getBean(), result, fields);
	}

	public Collection<ServicoContratoDTO> listServicosContratoByIdContratoAndTipoServico(Integer idContrato, String tipoServico) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		List<Object> fields = new ArrayList<>();

		sql.append(" SELECT DISTINCT ");
		sql.append(" 	sc.idServicoContrato, ");
		sql.append(" 	sc.idServico, ");
		sql.append(" 	sc.idContrato, ");
		sql.append(" 	s.idPortfolioServico, ");
		sql.append(" 	s.nomeServico ");
		sql.append(" FROM ");
		sql.append(" 	servicoContrato sc ");
		sql.append(" 	INNER JOIN servico s ");
		sql.append(" 		ON s.idServico = sc.idServico ");
		sql.append(" 	INNER JOIN servicoAutoRelacionamento auto  ");
		sql.append(" 		ON sc.idServico = auto.idServicoRelacionado ");
		sql.append(" 	INNER JOIN servicoContrato scr ");
		sql.append(" 		ON scr.idServico = auto.idServico ");
		sql.append(" WHERE s.tipoServico LIKE '" + tipoServico + "' ");
		sql.append(" 	AND sc.idContrato = ? ");
		sql.append(" 	AND (sc.deleted IS NULL OR UPPER(sc.deleted) <> UPPER('y')) ");
		sql.append(" ORDER BY s.nomeServico ");

		parametros.add(idContrato);

		List result = this.execSQL(sql.toString(), parametros.toArray());

		fields.add("idServicoContrato");
		fields.add("idServico");
		fields.add("idContrato");
		fields.add("idPortfolioServico");
		fields.add("nomeServico");

		if (result != null && !result.isEmpty()) {
			return this.engine.listConvertion(getBean(), result, fields);
		}

		return Collections.emptyList();
	}

	public List<Integer> getIdsServicosRelacionadosServicoContratoByIdsContrato(String idsContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> fields = new ArrayList<>();
		List<Integer> idsServicosRelacionados = new ArrayList<>();

		if (!UtilStrings.isNullOrEmpty(idsContrato)) {
			sql.append(" SELECT DISTINCT ");
			sql.append(" 	sc.idservico ");
			sql.append(" FROM ");
			sql.append(" 	servicoContrato sc ");
			sql.append(" 	INNER JOIN servico s ");
			sql.append(" 		ON s.idServico = sc.idServico ");
			sql.append(" 	INNER JOIN servicoAutoRelacionamento auto  ");
			sql.append(" 		ON sc.idServico = auto.idServicoRelacionado ");
			sql.append(" 	INNER JOIN servicoContrato scr ");
			sql.append(" 		ON scr.idServico = auto.idServico ");
			sql.append(" WHERE (sc.deleted IS NULL OR UPPER(sc.deleted) <> UPPER('y')) ");
			sql.append(" 	AND sc.idcontrato IN (").append(idsContrato).append(") ");

			List result = this.execSQL(sql.toString(), null);

			fields.add("idServico");

			if (result != null && !result.isEmpty()) {
				Collection<ServicoContratoDTO> listServicoContrato = this.engine.listConvertion(getBean(), result, fields);

				for (ServicoContratoDTO servicoContratoDTO : listServicoContrato) {
					idsServicosRelacionados.add(servicoContratoDTO.getIdServico());
				}

				return idsServicosRelacionados;
			}
		}

		return Collections.emptyList();
	}

	public List<Integer> getIdsServicoContratoByIdsContratoAndIdsServicosRelacionados(String idsContrato, String idsServicosRelacionados) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> fields = new ArrayList<>();
		List<Integer> idsServicosContrato = new ArrayList<>();

		if (!UtilStrings.isNullOrEmpty(idsContrato) && !UtilStrings.isNullOrEmpty(idsServicosRelacionados)) {
			sql.append(" SELECT DISTINCT ");
			sql.append(" 	sc.idservicoContrato ");
			sql.append(" FROM ");
			sql.append(" 	servico s ");
			sql.append(" 	INNER JOIN servicoAutoRelacionamento auto  ");
			sql.append(" 		ON s.idServico = auto.idServico ");
			sql.append(" 	INNER JOIN servicoContrato sc ");
			sql.append(" 		ON sc.idServico = s.idServico ");
			sql.append(" WHERE ");
			sql.append(" 	(UPPER(s.deleted)  = 'N' OR s.deleted IS NULL) ");
			sql.append(" 	AND (UPPER(sc.deleted)  = 'N' OR sc.deleted IS NULL) ");
			sql.append(" 	AND auto.idservicorelacionado IN (").append(idsServicosRelacionados).append(") ");
			sql.append(" 	AND sc.idcontrato IN (").append(idsContrato).append(") ");
			sql.append(" 	AND tipoServico IN ('R', 'P', 'I') ");

			List result = this.execSQL(sql.toString(), null);

			fields.add("idServicoContrato");

			if (result != null && !result.isEmpty()) {
				Collection<ServicoContratoDTO> listServicoContrato = this.engine.listConvertion(getBean(), result, fields);

				for (ServicoContratoDTO servicoContratoDTO : listServicoContrato) {
					idsServicosContrato.add(servicoContratoDTO.getIdServicoContrato());
				}

				return idsServicosContrato;
			}
		}

		return Collections.emptyList();
	}
	
	public boolean validaContratoServico(Integer idServicoContrato) throws PersistenceException{
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT c.idcontrato ");
		sql.append(" FROM servicocontrato sc INNER JOIN contratos c ON sc.idcontrato = c.idcontrato ");
		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().equalsIgnoreCase("ORACLE")) {
			sql.append(" WHERE sc.idservicocontrato = ? AND trunc(c.datafimcontrato) >= to_date(?,'yyyy-mm-dd') ");
		} else {
			sql.append(" WHERE sc.idservicocontrato = ? AND c.datafimcontrato >= (cast(? as date)) ");
		}
		sql.append(" AND c.deleted IS NULL");
		
		
		parametros.add(idServicoContrato);
		parametros.add(UtilDatas.dateToSTRWithFormat(UtilDatas.getDataAtual(), "yyyy-MM-dd"));
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		if(result !=null && result.size()>0) return true;
		else return false;

	}
	
	public Collection<ServicoContratoDTO> findRIOByIdContrato(final Integer parm) throws PersistenceException {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList();
        List<Object> fields = new ArrayList<>();
        List<ServicoContratoDTO> list = new ArrayList<ServicoContratoDTO>();
        sql.append("SELECT idServicoContrato, s.idServico, s.deleted, s.nomeServico, sc.dataInicio, sc.dataFim FROM " + getTableName() + " sc ");
        sql.append("INNER JOIN servico s ON sc.idServico = s.idServico ");
        sql.append("WHERE sc.idContrato = ? ");
        sql.append("AND (sc.deleted is null or sc.deleted <> 'y')");
        sql.append("AND (s.tiposervico = 'O' OR s.tiposervico = 'I' OR s.tiposervico = 'R')");

        parametro.add(parm);

        list = this.execSQL(sql.toString(), parametro.toArray());

        List result = new ArrayList();
        
        fields.add("idServicoContrato");
        fields.add("idServico");
        fields.add("deleted");
        fields.add("nomeServico");
        fields.add("dataInicio");
        fields.add("dataFim");
        
        result = engine.listConvertion(this.getBean(), list, fields);

        return result;

    }

}
