package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoProcessoNegocioDTO;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ServicoProcessoNegocioDAO extends CrudDaoDefaultImpl{

	public ServicoProcessoNegocioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "ServicoProcessoNegocio";
	}

	@Override
	public Collection<Field> getFields() {
		final List<Field> listFields = new ArrayList<Field>();
		
		listFields.add(new Field("idServicoProcessoNegocio", "idServicoProcessoNegocio", true, true, false, false));
		listFields.add(new Field("idServico", "idServico", false, false, false, false));
		listFields.add(new Field("idProcessoNegocio", "idProcessoNegocio", false, false, false, false));
		
		return listFields;
	}

	@Override
	public Class<ServicoProcessoNegocioDTO> getBean() {
		return ServicoProcessoNegocioDTO.class;
	}
	
	@SuppressWarnings("unchecked")
	public Collection<ServicoProcessoNegocioDTO> findIdsProcessosNegocioByIdServico(final Integer idServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		final List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idServico", idServico));
		ordenacao.add(new Order("idProcessoNegocio"));
		return super.findByCondition(condicao, ordenacao);
	}
	
	public void deleteProcessoNegocioFromServico(final Integer idProcessoNegocio, final Integer idServico) throws Exception {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idProcessoNegocio", idProcessoNegocio));
		condicao.add(Condition.AND, new Condition("idServico", Condition.EQUALS, idServico));
		super.deleteByCondition(condicao);
	}
	
	public Collection<ServicoDTO> findServicosByIdProcessosNegocio(final Integer idProcessoNegocio) throws Exception {
		List listResultado = new ArrayList();
		StringBuilder sqlBuilder = new StringBuilder();
		
		sqlBuilder.append("SELECT ");
		sqlBuilder.append("		servico.idServico, ");
		sqlBuilder.append("		servico.nomeServico ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("		ServicoProcessoNegocio servicoProcessoNegocio");
		sqlBuilder.append("		INNER JOIN");
		sqlBuilder.append("		Servico servico");
		sqlBuilder.append("		ON idProcessoNegocio = "+ idProcessoNegocio+" ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("		servico.idServico = servicoProcessoNegocio.idServico ");
		sqlBuilder.append("ORDER BY ");
		sqlBuilder.append("		servico.nomeServico");

		listResultado = this.execSQL(sqlBuilder.toString(), null);
		
		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idServico");
		listRetorno.add("nomeServico");
		
		List<ServicoDTO> listaServicos = (List<ServicoDTO>) this.engine.listConvertion(ServicoDTO.class, listResultado, listRetorno);
		
        return listaServicos;
	}

}
