package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class ServicoQuestionarioDao extends CrudDaoDefaultImpl {

	public ServicoQuestionarioDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);

	}

	@Override
	public Collection<Field> getFields() {
		List<Field> lista = new ArrayList<Field>();

		lista.add(new Field("idServicoQuestionario", "idServicoQuestionario", true, false, false, false));
		lista.add(new Field("idQuestionario", "idQuestionario", false, false, false, false));
		lista.add(new Field("idServico", "idServico", false, false, false, false));
		lista.add(new Field("dataQuestionario", "dataQuestionario", false, false, false, false));
		lista.add(new Field("situacao", "situacao", false, false, false, false));
		lista.add(new Field("dataHoraGrav", "dataHoraGrav", false, false, false, false));

		return lista;
	}

	@Override
	public String getTableName() {
		return "servicoquestionario";
	}

	@Override
	public Class<ServicoQuestionarioDTO> getBean() {
		return ServicoQuestionarioDTO.class;
	}

	public ServicoQuestionarioDTO findByIdServico(Integer idServico) throws PersistenceException {
		List<Order> order = new ArrayList<Order>();

		order.add(new Order("dataHoraGrav", Order.DESC));
		order.add(new Order("idServicoQuestionario", Order.DESC));

		ServicoQuestionarioDTO servicoQuestionarioDto = new ServicoQuestionarioDTO();
		servicoQuestionarioDto.setIdServico(idServico);
		@SuppressWarnings("unchecked")
		List<ServicoQuestionarioDTO> result = (List<ServicoQuestionarioDTO>) super.find(servicoQuestionarioDto, order);
		if (result != null && result.size() > 0) {
			return result.get(0);
		} else {
			return null;
		}
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}
}
