package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.SituacaoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class SituacaoServicoDao extends CrudDaoDefaultImpl {

	public SituacaoServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<SituacaoServicoDTO> getBean() {
		return SituacaoServicoDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDSITUACAOSERVICO", "idSituacaoServico", true, true, false, false));
		listFields.add(new Field("IDEMPRESA", "idEmpresa", false, false, false, false));
		listFields.add(new Field("NOMESITUACAOSERVICO", "nomeSituacaoServico", false, false, false, false));
		listFields.add(new Field("DATAINICIO", "dataInicio", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));
		listFields.add(new Field("ativo", "ativo", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "SITUACAOSERVICO";
	}

	@Override
	@SuppressWarnings("unchecked")
	public Collection<SituacaoServicoDTO> find(IDto obj) throws PersistenceException {
		List<Order> ordem = new ArrayList<Order>();
		ordem.add(new Order("nomeSituacaoServico"));
		return super.find(obj, ordem);
	}

	@Override
	@SuppressWarnings("unchecked")
	public Collection<SituacaoServicoDTO> list() throws PersistenceException {
		List<Order> list = new ArrayList<Order>();
		list.add(new Order("nomeSituacaoServico"));
		return super.list(list);
	}

	public boolean existeServicoAssociado(Integer idSituacaoServico) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT IDSITUACAOSERVICO FROM SERVICO WHERE IDSITUACAOSERVICO = ? and (deleted is null or deleted = 'n') ");
		parametro.add(idSituacaoServico);
		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		if(lista.size()>0) {
			return true;
		}

		return false;
	}

	@SuppressWarnings("unchecked")
	public Collection<SituacaoServicoDTO> getAtivos() throws PersistenceException {
		Collection<SituacaoServicoDTO> listSituacaoServicoDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("dataFim", "is", null));

		final List<Order> ordenacao = new ArrayList<Order>();
		ordenacao.add(new Order("nomeSituacaoServico"));

		listSituacaoServicoDto = this.findByCondition(condicao, ordenacao);

		return listSituacaoServicoDto;
	}
}
