package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.SmartDecisionsWidgetsDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class SmartDecisionsWidgetsDAO extends CrudDaoDefaultImpl {

	public SmartDecisionsWidgetsDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<SmartDecisionsWidgetsDTO> find(final IDto obj) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idsmartdecisionswidgets", "idSmartDecisionsWidgets", true, true, false, false));
		listFields.add(new Field("idusuario", "idUsuario", false, false, false, false));
		listFields.add(new Field("idpanel", "idPanel", false, false, false, false));
		listFields.add(new Field("model", "model", false, false, false, false));
		listFields.add(new Field("datainicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "smartdecisionswidgets";
	}

	@Override
	public Class<SmartDecisionsWidgetsDTO> getBean() {
		return SmartDecisionsWidgetsDTO.class;
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	public Collection<SmartDecisionsWidgetsDTO> findByIdUsuario(Integer idUsuario) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idUsuario", idUsuario));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		return this.findByCondition(condicao, ordenacao);
	}

	public Collection<SmartDecisionsWidgetsDTO> findByIdUsuarioAndIdPanel(Integer idUsuario, Integer idPanel) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idUsuario", idUsuario));
		condicao.add(new Condition("idPanel", idPanel));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		return this.findByCondition(condicao, ordenacao);
	}

}
