package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsWidgetsGroupsDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class SmartDecisionsWidgetsGroupsDAO extends CrudDaoDefaultImpl {

	public SmartDecisionsWidgetsGroupsDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idsmartdecisionswidgetsgroups", "idSmartDecisionsWidgetsGroups", true, true, false, false));
		listFields.add(new Field("idwidget", "idWidget", false, false, false, false));
		listFields.add(new Field("idgrupo", "idGrupo", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "smartdecisionswidgetsgroups";
	}

	@Override
	public Class<SmartDecisionsWidgetsGroupsDTO> getBean() {
		return SmartDecisionsWidgetsGroupsDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<SmartDecisionsWidgetsGroupsDTO> findByIdWidget(Integer idWidget) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idWidget", Condition.EQUALS, idWidget));
		ordenacao.add(new Order("idSmartDecisionsWidgetsGroups"));

		return this.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdWidget(Integer idWidget) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("idWidget", Condition.EQUALS, idWidget));

		this.deleteByCondition(condicao);
	}

	public List<SmartDecisionsWidgetsGroupsDTO> findAvailablesByUsuario(UsuarioDTO usuarioDTO) throws PersistenceException {
		StringBuilder sql = new StringBuilder();

		sql.append("select distinct \n");
		sql.append("	idwidget \n");
		sql.append("from \n");
		sql.append("	smartdecisionswidgetsgroups \n");

		if (usuarioDTO.getColGrupos() != null && !usuarioDTO.getColGrupos().isEmpty()) {
			sql.append("where \n");
			sql.append("	idgrupo in (");

			for (GrupoDTO grupoDTO : usuarioDTO.getColGrupos()) {
				if (!sql.toString().endsWith("(")) {
					sql.append(", ");
				}

				sql.append(grupoDTO.getIdGrupo());
			}

			sql.append(") \n");
		}

		List dados = this.execSQL(sql.toString(), null);

		List<String> fieldsRetorno = new ArrayList<String>();
		fieldsRetorno.add("idWidget");

		return this.listConvertion(this.getBean(), dados, fieldsRetorno);
	}
}
