package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.SmartReportGrupoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * Vnculo entre SmartReport e Grupo.
 *
 * @author douglas.japiassu
 */
public class SmartReportGrupoDAO extends CrudDaoDefaultImpl {

	public SmartReportGrupoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<SmartReportGrupoDTO> getBean() {
		return SmartReportGrupoDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idSmartReportGrupo", "idSmartReportGrupo", true, true, false, false));
		listFields.add(new Field("idSmartReport", "idSmartReport", false, false, false, false));
		listFields.add(new Field("idGrupo", "idGrupo", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "smartreportgrupo";
	}


	@SuppressWarnings("unchecked")
	public Collection<SmartReportGrupoDTO> findIdsGruposByIdSmartReport(final Integer idSmartReport) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idSmartReport", idSmartReport));

		final List<Order> ordenacao = new ArrayList<Order>();

		return this.findByCondition(condicao, ordenacao);
	}

	public void deleteAllGruposByIdSmartReport(final Integer idSmartReport) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idSmartReport", idSmartReport));
		super.deleteByCondition(condicao);
	}

}