package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.SolicitacaoEquipeMobileDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class SolicitacaoEquipeMobileDao extends CrudDaoDefaultImpl {

	public SolicitacaoEquipeMobileDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Class<SolicitacaoEquipeMobileDTO> getBean() {
		return SolicitacaoEquipeMobileDTO.class;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idsolicitacaoequipemobile", "idsolicitacaoequipemobile", true, true, false, false));
		listFields.add(new Field("idsolicitacao", "idsolicitacao", false, false, false, false));
		listFields.add(new Field("idequipe", "idequipe", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "solicitacaoequipemobile";
	}

	@Override
	public Collection<SolicitacaoEquipeMobileDTO> find(final IDto obj) throws PersistenceException {
		return null;
	}

	@SuppressWarnings("unchecked")
	public SolicitacaoEquipeMobileDTO buscaAtribuicaoPorIdSolicitacao(final Integer idSolicitacao) throws Exception {

		final StringBuilder sql = new StringBuilder();
		final List<Integer> parametro = new ArrayList<>();
		sql.append("SELECT idsolicitacaoequipemobile,idsolicitacao,idequipe FROM " + this.getTableName() + " where idsolicitacao = ? ");
		parametro.add(idSolicitacao);
		final List<?> list = this.execSQL(sql.toString(), parametro.toArray());
		final List<String> listRetorno = new ArrayList<>();
		listRetorno.add("idSolicitacaoEquipeMobile");
		listRetorno.add("idSolicitacao");
		listRetorno.add("idEquipe");

		final List<SolicitacaoEquipeMobileDTO> lista = (ArrayList<SolicitacaoEquipeMobileDTO>) engine.listConvertion(this.getBean(), list, listRetorno);

		if ((lista != null) && (lista.size() > 0)) {
			return lista.get(0);
		}
		return null;
	}

}
