package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.StatusInventarioDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.util.Constantes;

public class StatusInventarioDAO extends CrudDaoDefaultImpl {

	public StatusInventarioDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idstatusinventario", "idStatusInventario", true, true, false, false));
		listFields.add(new Field("ip", "ip", false, false, false, false));
		listFields.add(new Field("identificacao", "identificacao", false, false, false, false));
		listFields.add(new Field("idstatus", "idStatus", false, false, false, false));
		listFields.add(new Field("datahora", "dataHora", false, false, false, false));
		listFields.add(new Field("idconexao", "idConexao", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "statusinventario";
	}

	@Override
	public Class<StatusInventarioDTO> getBean() {
		return StatusInventarioDTO.class;
	}

	@Override
	public Collection<StatusInventarioDTO> list() throws PersistenceException {
		List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("idStatusInventario"));

		return super.list(ordenacao);
	}

	@SuppressWarnings("unchecked")
	public Collection<StatusInventarioDTO> list(Integer idConexao, String identificacao, String ip, Integer idStatus, Integer quantidadeAtual, Integer quantidadeCarregar) throws PersistenceException {
		StringBuilder select = new StringBuilder();
		StringBuilder from = new StringBuilder();
		StringBuilder where = new StringBuilder();
		StringBuilder order = new StringBuilder();
		StringBuilder sql = new StringBuilder();

		List<Object> parametros = new ArrayList<>();

		select.append("SELECT " + this.getNamesFieldsStr() + " ");
		from.append("FROM statusinventario ");
		where.append("WHERE 1=1 ");

		if (idConexao != null) {
			where.append(" AND idconexao = ? ");
			parametros.add(idConexao);
		}

		if (identificacao != null && !identificacao.isEmpty()) {
			where.append(" AND identificacao like ? ");
			parametros.add("%" + identificacao + "%");
		}

		if (ip != null && !ip.isEmpty()) {
			where.append(" AND ip like ? ");
			parametros.add("%" + ip + "%");
		}

		if (idStatus != null) {
			where.append(" AND idstatus = ? ");
			parametros.add(idStatus);
		}

		order.append(" order by idstatusinventario ");

		DataBase database = DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL);

		/*
		 * A paginao est sempre puxando a partir do 0 por causa da atualizao automtica da tela.
		 */
		if (database.equals(DataBase.MYSQL)) {
			sql.append(select).append(from).append(where).append(order);
			sql.append(" limit 0, " + (quantidadeAtual + (quantidadeCarregar == null ? 0 : quantidadeCarregar)) + " ");
		} else if (database.equals(DataBase.POSTGRESQL)) {
			sql.append(select).append(from).append(where).append(order);
			sql.append(" limit " + (quantidadeAtual + (quantidadeCarregar == null ? 0 : quantidadeCarregar)) + " offset 0 ");
		} else if (database.equals(DataBase.MSSQLSERVER)) {
			sql.append(" ;WITH TempTable AS ( ");
			sql.append(select);
			sql.append(" , ROW_NUMBER() ");
			sql.append(" OVER ( ");
			sql.append(order);
			sql.append(" ) ");
			sql.append(" AS Row ");
			sql.append(from);
			sql.append(where);
			sql.append(" ) SELECT * FROM TempTable WHERE Row > 0 and Row <= " + (quantidadeAtual + (quantidadeCarregar == null ? 0 : quantidadeCarregar)));
		} else if (database.equals(DataBase.ORACLE)) {
			sql.append(" SELECT * FROM ( ");
			sql.append("    SELECT PAGING.*, ROWNUM PAGING_RN FROM ( ");
			sql.append(select).append(from).append(where).append(order);
			sql.append("    ) PAGING ) WHERE PAGING_RN > 0 AND PAGING_RN <= " + (quantidadeAtual + (quantidadeCarregar == null ? 0 : quantidadeCarregar)) + " ");
		}

		List retorno = this.execSQL(sql.toString(), parametros.toArray());

		List<String> listFields = new ArrayList<>();
		listFields.add("idStatusInventario");
		listFields.add("ip");
		listFields.add("identificacao");
		listFields.add("idStatus");
		listFields.add("dataHora");
		listFields.add("idConexao");

		return this.engine.listConvertion(StatusInventarioDTO.class, retorno, listFields);
	}

	public Collection<StatusInventarioDTO> findByIdentificacao(final String identificacao) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("identificacao", Condition.EQUALS, identificacao));
		ordenacao.add(new Order("identificacao"));

		return this.findByCondition(condicao, ordenacao);
	}

	public Collection<StatusInventarioDTO> findByIp(final String ip) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("ip", Condition.EQUALS, ip));
		ordenacao.add(new Order("ip"));

		return this.findByCondition(condicao, ordenacao);
	}

}
