package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.TemplateServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class TemplateServicoDAO extends CrudDaoDefaultImpl {
	public TemplateServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idTemplateServico", "idTemplateServico", true, true, false, false));
		listFields.add(new Field("nomeTemplate", "nomeTemplate", false, false, false, false));
		listFields.add(new Field("identificacao", "identificacao", false, false, false, false));
		listFields.add(new Field("nomeClasseAction", "nomeClasseAction", false, false, false, false));
		listFields.add(new Field("nomeClasseServico", "nomeClasseServico", false, false, false, false));
		listFields.add(new Field("nomeClasseDto", "nomeClasseDto", false, false, false, false));
		listFields.add(new Field("urlRecuperacao", "urlRecuperacao", false, false, false, false));
		listFields.add(new Field("alturaDiv", "alturaDiv", false, false, false, false));
		listFields.add(new Field("idQuestionario", "idQuestionario", false, false, false, false));
		listFields.add(new Field("scriptAposRecuperacao", "scriptAposRecuperacao", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "templateservico";
	}

	@Override
	public Class<TemplateServicoDTO> getBean() {
		return TemplateServicoDTO.class;
	}

	@Override
	@SuppressWarnings("unchecked")
	public Collection<TemplateServicoDTO> list() throws PersistenceException {
		List<Order> list = new ArrayList<Order>();
		list.add(new Order("nomeTemplate"));

		return super.list(list);
	}
}