package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.TempoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class TempoAcordoNivelServicoDao extends CrudDaoDefaultImpl {

	public TempoAcordoNivelServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAcordoNivelServico", "idAcordoNivelServico", true, false, false, false));
		listFields.add(new Field("idPrioridade", "idPrioridade", true, false, false, false));
		listFields.add(new Field("idFase", "idFase", true, false, false, false));
		listFields.add(new Field("tempoHH", "tempoHH", false, false, false, false));
		listFields.add(new Field("tempoMM", "tempoMM", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "TempoAcordoNivelServico";
	}

	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return TempoAcordoNivelServicoDTO.class;
	}

	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}

	public void deleteByIdAcordo(Integer idAcordoNivelServico) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		super.deleteByCondition(condicao);
	}
	
	public Collection findByIdAcordo(Integer idAcordoNivelServico) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		ordenacao.add(new Order("idFase"));
		ordenacao.add(new Order("idPrioridade"));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection findByIdAcordoAndIdPrioridade(Integer idAcordoNivelServico, Integer idPrioridade) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		condicao.add(new Condition("idPrioridade", "=", idPrioridade));
		ordenacao.add(new Order("idFase"));
		return super.findByCondition(condicao, ordenacao);
	}

	public Collection findByIdAcordoAndFaseAndIdPrioridade(Integer idAcordoNivelServico, Integer idFase, Integer idPrioridade) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		condicao.add(new Condition("idFase", "=", idFase));
		condicao.add(new Condition("idPrioridade", "=", idPrioridade));
		ordenacao.add(new Order("idPrioridade"));
		return super.findByCondition(condicao, ordenacao);
	}
	
	public IDto listTempoAtendimentoRequisicao(EmpregadoDTO empregadoDTO, UnidadeDTO unidadeDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append("SELECT tans.tempohh, tans.tempomm, ans.idacordonivelservico ");
		sql.append("	FROM acordonivelservico ans ");
		sql.append("	INNER JOIN servicocontrato sc ON ans.idservicocontrato IS NOT NULL AND ans.idservicocontrato = sc.idservicocontrato and ans.idservicocontrato = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN tempoacordonivelservico  tans ON tans.idacordonivelservico = ans.idacordonivelservico and tans.idprioridade = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	LEFT JOIN tempoatendimentoempregado tae ON tae.idacordonivelservico = ans.idacordonivelservico and tae.idempregado = ? ");
		parametros.add(empregadoDTO.getIdEmpregado());
		sql.append("	LEFT JOIN tempoatendimentounidade tau ON tau.idacordonivelservico = ans.idacordonivelservico and tau.idunidade = ? ");
		parametros.add(unidadeDTO.getIdUnidade());
		sql.append("WHERE ");
		sql.append("	(ans.deleted IS NULL OR ans.deleted = 'N' OR ans.deleted = 'n') AND ans.tipo = 'T' AND ans.situacao = 'A' ");
		sql.append("	and ((tae.idtempoatendimentoempregado is not null and tau.idtempoatendimentounidade is not null) ");
		sql.append("		or (tae.idtempoatendimentoempregado is not null and tau.idtempoatendimentounidade is null) ");
		sql.append("		or (tae.idtempoatendimentoempregado is null and tau.idtempoatendimentounidade is not null)) ");
		sql.append("ORDER BY ");
		sql.append("	tae.idtempoatendimentoempregado DESC, tans.tempohh DESC, tans.tempomm DESC");

		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTARequisicaoIncidenteComEmpregadoComUnidade(EmpregadoDTO empregadoDTO, UnidadeDTO unidadeDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException{
		if(empregadoDTO == null || empregadoDTO.getIdEmpregado() == null)
			return null;
		
		if(unidadeDTO == null || unidadeDTO.getIdUnidade() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN SERVICOCONTRATO SC ON ANS.IDSERVICOCONTRATO IS NOT NULL AND ANS.IDSERVICOCONTRATO = SC.IDSERVICOCONTRATO AND ANS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAU.IDUNIDADE = ? ");
		parametros.add(unidadeDTO.getIdUnidade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAE.IDEMPREGADO = ? ");
		parametros.add(empregadoDTO.getIdEmpregado());
		
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND ( (TAU.IDUNIDADE IS NOT NULL) OR (TAE.IDEMPREGADO IS NOT NULL))  ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTARequisicaoIncidenteComEmpregadoSemUnidade(EmpregadoDTO empregadoDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException{
		if(empregadoDTO == null || empregadoDTO.getIdEmpregado() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();

		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN SERVICOCONTRATO SC ON ANS.IDSERVICOCONTRATO IS NOT NULL AND ANS.IDSERVICOCONTRATO = SC.IDSERVICOCONTRATO AND ANS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	INNER JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAE.IDEMPREGADO = ? ");
		parametros.add(empregadoDTO.getIdEmpregado());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND	TAU.IDTEMPOATENDIMENTOUNIDADE IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;		
	}
	
	public IDto listTARequisicaoIncidenteSemEmpregadoComUnidade(UnidadeDTO unidadeDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException{
		if(unidadeDTO == null || unidadeDTO.getIdUnidade() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN SERVICOCONTRATO SC ON ANS.IDSERVICOCONTRATO IS NOT NULL AND ANS.IDSERVICOCONTRATO = SC.IDSERVICOCONTRATO AND ANS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	INNER JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAU.IDUNIDADE = ? ");
		parametros.add(unidadeDTO.getIdUnidade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N') ");
		sql.append("	AND ANS.TIPO = 'T' ");
		sql.append("	AND ANS.SITUACAO = 'A' "); 
		sql.append("	AND TAE.IDTEMPOATENDIMENTOEMPREGADO IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTARequisicaoIncidenteSemEmpregadoSemUnidade( SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException{
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN SERVICOCONTRATO SC ON ANS.IDSERVICOCONTRATO IS NOT NULL AND ANS.IDSERVICOCONTRATO = SC.IDSERVICOCONTRATO AND ANS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND TAE.IDTEMPOATENDIMENTOEMPREGADO IS NULL ");
		sql.append("	AND	TAU.IDTEMPOATENDIMENTOUNIDADE IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTAClienteComEmpregadoSemUnidade(EmpregadoDTO empregadoDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException {
		if(empregadoDTO == null || empregadoDTO.getIdEmpregado() == null)
			return null;
		
		if(solicitacaoServicoDto == null|| solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN CONTRATOS C ON ANS.IDCONTRATO IS NOT NULL AND C.IDCONTRATO = ANS.IDCONTRATO  ");
		sql.append("	INNER JOIN ACORDOSERVICOCONTRATO ACS ON ACS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND ACS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	INNER JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAE.IDEMPREGADO = ? ");
		parametros.add(empregadoDTO.getIdEmpregado());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND	TAU.IDTEMPOATENDIMENTOUNIDADE IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}

	/**
	 * Lista os tempos de atendimento para todos os colaboradores das unidades contando tambem com os empregados includos
	 *
	 * @author rodrigo.guilherme
	 * @since 04.12.2015
	 */
	public IDto listTAClienteComEmpregadoComUnidade(EmpregadoDTO empregadoDTO, UnidadeDTO unidadeDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException {
		if(empregadoDTO == null || empregadoDTO.getIdEmpregado() == null)
			return null;
		
		if(unidadeDTO == null || unidadeDTO.getIdUnidade() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN CONTRATOS C ON ANS.IDCONTRATO IS NOT NULL AND C.IDCONTRATO = ANS.IDCONTRATO  ");
		sql.append("	INNER JOIN ACORDOSERVICOCONTRATO ACS ON ACS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND ACS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAU.IDUNIDADE = ? ");
		parametros.add(unidadeDTO.getIdUnidade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAE.IDEMPREGADO = ? ");
		parametros.add(empregadoDTO.getIdEmpregado());
		
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND ( (TAU.IDUNIDADE IS NOT NULL) OR (TAE.IDEMPREGADO IS NOT NULL))  ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTAClienteSemEmpregadoComUnidade(UnidadeDTO unidadeDTO, SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException {
		if(unidadeDTO == null || unidadeDTO.getIdUnidade() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN CONTRATOS C ON ANS.IDCONTRATO IS NOT NULL AND C.IDCONTRATO = ANS.IDCONTRATO  ");
		sql.append("	INNER JOIN ACORDOSERVICOCONTRATO ACS ON ACS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND ACS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	INNER JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TAU.IDUNIDADE = ? ");
		parametros.add(unidadeDTO.getIdUnidade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N') ");
		sql.append("	AND ANS.TIPO = 'T' ");
		sql.append("	AND ANS.SITUACAO = 'A' "); 
		sql.append("	AND TAE.IDTEMPOATENDIMENTOEMPREGADO IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTAClienteSemEmpregadoSemUnidade(SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException{
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdServicoContrato() == null)
			return null;
		
		if(solicitacaoServicoDto == null || solicitacaoServicoDto.getIdPrioridade() == null)
			return null;
		
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append(" SELECT ");
		sql.append("	TANS.TEMPOHH, TANS.TEMPOMM, ANS.IDACORDONIVELSERVICO ");
		sql.append(" FROM  ");
		sql.append("	ACORDONIVELSERVICO ANS  ");
		sql.append("	INNER JOIN CONTRATOS C ON ANS.IDCONTRATO IS NOT NULL AND C.IDCONTRATO = ANS.IDCONTRATO  ");
		sql.append("	INNER JOIN ACORDOSERVICOCONTRATO ACS ON ACS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND ACS.IDSERVICOCONTRATO = ? ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append("	INNER JOIN TEMPOACORDONIVELSERVICO  TANS ON TANS.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO AND TANS.IDPRIORIDADE = ? ");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		sql.append("	LEFT JOIN TEMPOATENDIMENTOEMPREGADO TAE ON TAE.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append("	LEFT JOIN TEMPOATENDIMENTOUNIDADE TAU ON TAU.IDACORDONIVELSERVICO = ANS.IDACORDONIVELSERVICO ");
		sql.append(" WHERE  ");
		sql.append("	(UPPER(ANS.DELETED) IS NULL OR UPPER(ANS.DELETED) = 'N' OR UPPER(ANS.DELETED) = 'N')  ");
		sql.append("	AND ANS.TIPO = 'T'  ");
		sql.append("	AND ANS.SITUACAO = 'A' ");
		sql.append("	AND TAE.IDTEMPOATENDIMENTOEMPREGADO IS NULL ");
		sql.append("	AND	TAU.IDTEMPOATENDIMENTOUNIDADE IS NULL ");
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
	
	public IDto listTempoAtendimentoGlobal(SolicitacaoServicoDTO solicitacaoServicoDto) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List<Object> parametros = new ArrayList<>();
		
		sql.append("SELECT tans.tempohh, tans.tempomm, ans.idacordonivelservico ");
		sql.append(" FROM acordonivelservico ans ");
		sql.append(" INNER JOIN acordoservicocontrato ascon ON ans.idacordonivelservico = ascon.idacordonivelservico AND ascon.idservicocontrato = ? ");
		sql.append("	AND (ans.deleted IS NULL OR UPPER(ans.deleted) = 'N' ) AND ans.idcontrato IS NULL AND ascon.deleted IS NULL AND ans.situacao = 'A' AND ans.tipo = 'T' ");
		parametros.add(solicitacaoServicoDto.getIdServicoContrato());
		sql.append(" INNER JOIN tempoacordonivelservico tans ON tans.idacordonivelservico = ans.idacordonivelservico ");
		sql.append(" WHERE tans.idprioridade = ? ");
		sql.append(" ORDER BY tans.tempohh DESC, tans.tempomm DESC");
		parametros.add(solicitacaoServicoDto.getIdPrioridade());
		
		List result = this.execSQL(sql.toString(), parametros.toArray());
		
		List<Object> fields = new ArrayList<>();
		
		fields.add("tempoHH");
		fields.add("tempoMM");
		fields.add("idAcordoNivelServico");
		
		List<IDto> retorno = this.engine.listConvertion(getBean(), result, fields);
		
		if(retorno != null && !retorno.isEmpty())
			return retorno.get(0);
		else
			return null;
	}
}
