package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.TempoAtendimentoEmpregadoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author rodrigo.guilherme
 * @since 19.11.2015
 */

@SuppressWarnings({"unchecked", "rawtypes"})
public class TempoAtendimentoEmpregadoDao extends CrudDaoDefaultImpl {
	public TempoAtendimentoEmpregadoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idtempoatendimentoempregado", "idTempoAtendimentoEmpregado", true, true, false, false));
		listFields.add(new Field("idacordonivelservico", "idAcordoNivelServico", false, false, false, false));
		listFields.add(new Field("idempregado", "idEmpregado", false, false, false, false));
		listFields.add(new Field("prioridade", "prioridade", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "tempoatendimentoempregado";
	}

	@Override
	public Class getBean() {
		return TempoAtendimentoEmpregadoDTO.class;
	}

	/**
	 * Lista pelo id do acordo de nvel de servio
	 *
	 * @param Integer
	 * @return Collection<TempoAtendimentoEmpregadoDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 19.11.2015
	 */
	public Collection<TempoAtendimentoEmpregadoDTO> findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		Collection<TempoAtendimentoEmpregadoDTO> listTempoAtendimentoEmpregadoDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));

		listTempoAtendimentoEmpregadoDto = this.findByCondition(condicao, null);

		return listTempoAtendimentoEmpregadoDto;
	}

	public TempoAtendimentoEmpregadoDTO restoreByIdAcordoNivelServico(final Integer idAcordoNivelServico) throws PersistenceException {
		final List<Order> ordem = new ArrayList<>();
		final TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregadoDTO = new TempoAtendimentoEmpregadoDTO();
		tempoAtendimentoEmpregadoDTO.setIdAcordoNivelServico(idAcordoNivelServico);
		final List<TempoAtendimentoEmpregadoDTO> col = (List<TempoAtendimentoEmpregadoDTO>) super.find(tempoAtendimentoEmpregadoDTO, ordem);
		if (col == null || col.size() == 0) {
			return null;
		}
		return col.get(0);
	}

	public TempoAtendimentoEmpregadoDTO restoreByIdEmpregadoIdANS(final Integer idEmpregado, final Integer idAcordoNivelServico) throws PersistenceException {
		ArrayList<TempoAtendimentoEmpregadoDTO> result;
		final List listRetorno = new ArrayList<String>();
		final List parametro = new ArrayList();
		final StringBuilder sql = new StringBuilder();

		listRetorno.addAll(getFields());

		sql.append("SELECT ").append(this.getNamesFieldsStr("tae"));
		sql.append(" FROM ").append(this.getTableName()).append(" tae");

		sql.append(" WHERE tae.idacordonivelservico = ?");
		if (idAcordoNivelServico != null) {
			parametro.add(idAcordoNivelServico);
		} else {
			parametro.add(0);
		}
		
		sql.append(" AND tae.idempregado = ?");
		if (idEmpregado != null) {
			parametro.add(idEmpregado);
		} else {
			parametro.add(0);
		}
		
		sql.append(" ORDER BY tae.prioridade ASC");
		
		List col = this.execSQL(sql.toString(), parametro.toArray());
		result = (ArrayList<TempoAtendimentoEmpregadoDTO>) engine.listConvertion(TempoAtendimentoEmpregadoDTO.class, col, listRetorno);
		
		if (result == null || result.size() == 0) {
			return null;
		}
		return result.get(0);
	}

	/**
	 * Lista pelo id do empregado
	 *
	 * @param Integer
	 * @return Collection<TempoAtendimentoEmpregadoDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 19.11.2015
	 */
	public Collection<TempoAtendimentoEmpregadoDTO> findByIdEmpregado(Integer idEmpregado) throws Exception {
		Collection<TempoAtendimentoEmpregadoDTO> listTempoAtendimentoEmpregadoDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idEmpregado", "=", idEmpregado));

		listTempoAtendimentoEmpregadoDto = this.findByCondition(condicao, null);

		return listTempoAtendimentoEmpregadoDto;
	}

	/**
	 * Retorna lista de Empregados a partir de um id do acordo de nivel de
	 * servio
	 *
	 * @param Integer
	 * @return ArrayList<EmpregadoDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 19.11.2015
	 */
	/*
	 * public ArrayList<EmpregadoDTO> listEmpregadosByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
	 * 
	 * Collection<TempoAtendimentoEmpregadoDTO> listaTempoAtendimentoEmpregadoDto = this.findByIdAcordoNivelServico(idAcordoNivelServico);
	 * 
	 * ArrayList<EmpregadoDTO> arrayListEmpregadoDto = new ArrayList<EmpregadoDTO>(); EmpregadoService EmpregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
	 * 
	 * if (listaTempoAtendimentoEmpregadoDto != null && !listaTempoAtendimentoEmpregadoDto.isEmpty()) { for (TempoAtendimentoEmpregadoDTO ansEmpregadosDto : listaTempoAtendimentoEmpregadoDto) { if (ansEmpregadosDto != null &&
	 * ansEmpregadosDto.getIdEmpregado() != null) { EmpregadoDTO empregadoDto = new EmpregadoDTO(); empregadoDto.setIdEmpregado(ansEmpregadosDto.getIdEmpregado()); empregadoDto = EmpregadoService.restore(empregadoDto);
	 * arrayListEmpregadoDto.add(empregadoDto); } } }
	 * 
	 * return arrayListEmpregadoDto; }
	 */
	/**
	 * Retorna quantidade de empregados a partir do id do ans
	 *
	 * @param Integer
	 * @return Long
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 27.11.2015
	 */
	public Long quantidadeEmpregadosByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException {
		List parametro = new ArrayList();

		StringBuilder sql = new StringBuilder();

		sql.append(" select count(idtempoatendimentoempregado) FROM "+getTableName()+" ");
		sql.append(" where idAcordoNivelServico = ? ");

		parametro.add(idAcordoNivelServico);

		List list = this.execSQL(sql.toString(), parametro.toArray());

		if (list != null && !list.isEmpty()) {
			Object[] quantidade = (Object[]) list.get(0);
			if (quantidade != null && quantidade.length > 0) {
				try{
					return new Long((long) quantidade[0]);
				} catch (ClassCastException cce) {
					return new Long((Integer) quantidade[0]);
				} catch (Exception e) {
					return new Long(0);
				}
			}
		}

		return new Long(0);
	}

	public ArrayList<TempoAtendimentoEmpregadoDTO> listEmpregadosByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		ArrayList<TempoAtendimentoEmpregadoDTO> result;
		final List listRetorno = new ArrayList<String>();
		final List parametro = new ArrayList();
		final StringBuilder sql = new StringBuilder();

		listRetorno.addAll(getListNamesFieldClass());
		listRetorno.add("nomeEmpregado");

		sql.append("SELECT ").append(this.getNamesFieldsStr("tae")).append(", emp.nome nomeEmpregado");
		sql.append(" FROM ").append(this.getTableName()).append(" tae");
		sql.append(" LEFT JOIN empregados emp ON emp.idempregado = tae.idempregado");
		sql.append(" WHERE tae.idacordonivelservico = ?");

		parametro.add(idAcordoNivelServico);

		try {
			List resp = new ArrayList<Object>();
			resp = this.execSQL(sql.toString(), parametro.toArray());
			result = (ArrayList<TempoAtendimentoEmpregadoDTO>) engine.listConvertion(TempoAtendimentoEmpregadoDTO.class, resp, listRetorno);
		} catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
		} catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
		return result == null || result.size() <= 0 ? new ArrayList<TempoAtendimentoEmpregadoDTO>() : result;
	}
}
