package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.TempoAtendimentoUnidadeDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

/**
 * @author rodrigo.guilherme
 * @since 19.11.2015
 */

@SuppressWarnings("unchecked")
public class TempoAtendimentoUnidadeDao extends CrudDaoDefaultImpl {
	public TempoAtendimentoUnidadeDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idtempoatendimentounidade", "idTempoAtendimentoUnidade", true, true, false, false));
		listFields.add(new Field("idacordonivelservico", "idAcordoNivelServico", false, false, false, false));
		listFields.add(new Field("idunidade", "idUnidade", false, false, false, false));
		listFields.add(new Field("prioridade", "prioridade", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "tempoatendimentounidade";
	}

	@SuppressWarnings("rawtypes")
	@Override
	public Class getBean() {
		return TempoAtendimentoUnidadeDTO.class;
	}

	/**
	 * Lista pelo id do acordo de nvel de servio
	 *
	 * @param Integer
	 * @return Collection<TempoAtendimentoUnidadeDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 19.11.2015
	 */
	public Collection<TempoAtendimentoUnidadeDTO> findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		Collection<TempoAtendimentoUnidadeDTO> listTempoAtendimentoUnidadeDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));

		listTempoAtendimentoUnidadeDto = this.findByCondition(condicao, null);

		return listTempoAtendimentoUnidadeDto;
	}

	public Collection<TempoAtendimentoUnidadeDTO> findByIdUnidade(Integer idUnidade) throws Exception {
		Collection<TempoAtendimentoUnidadeDTO> listTempoAtendimentoUnidadeDto = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idUnidade", "=", idUnidade));

		listTempoAtendimentoUnidadeDto = this.findByCondition(condicao, null);

		return listTempoAtendimentoUnidadeDto;
	}
	
	/**
	 * Retorna lista de unidades a partir de um id do acordo de nivel de servio
	 *
	 * @param Integer
	 * @return ArrayList<UnidadeDTO>
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 19.11.2015
	 */
	/*
	 * public ArrayList<UnidadeDTO> listUnidadesByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
	 * 
	 * Collection<TempoAtendimentoUnidadeDTO> listaTempoAtendimentoUnidadeDto = findByIdAcordoNivelServico(idAcordoNivelServico);
	 * 
	 * ArrayList<UnidadeDTO> arrayListUnidadeDto = new ArrayList<UnidadeDTO>(); UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
	 * 
	 * if (listaTempoAtendimentoUnidadeDto != null && !listaTempoAtendimentoUnidadeDto.isEmpty()) { for (TempoAtendimentoUnidadeDTO ansUidadesDto : listaTempoAtendimentoUnidadeDto) { if(ansUidadesDto!=null&&ansUidadesDto.getIdUnidade()!=null){
	 * UnidadeDTO unidadeDto = new UnidadeDTO(); unidadeDto.setIdUnidade(ansUidadesDto.getIdUnidade()); unidadeDto = unidadeService.restore(unidadeDto); arrayListUnidadeDto.add(unidadeDto); } } }
	 * 
	 * return arrayListUnidadeDto; }
	 */
	@SuppressWarnings("rawtypes")
	public ArrayList<TempoAtendimentoUnidadeDTO> listUnidadesByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		ArrayList<TempoAtendimentoUnidadeDTO> result;
		final List listRetorno = new ArrayList<String>();
		final List parametro = new ArrayList();
		final StringBuilder sql = new StringBuilder();
		
		listRetorno.addAll(getListNamesFieldClass());
		listRetorno.add("nomeUnidade");

		sql.append("SELECT ").append(this.getNamesFieldsStr("tau")).append(", uni.nome");
		sql.append(" FROM ").append(this.getTableName()).append(" tau");
		sql.append(" LEFT JOIN unidade uni ON uni.idunidade = tau.idunidade");
		sql.append(" WHERE tau.idacordonivelservico = ?");
		parametro.add(idAcordoNivelServico);

		try {
			List resp = new ArrayList<Object>();
			resp = this.execSQL(sql.toString(), parametro.toArray());
			result = (ArrayList<TempoAtendimentoUnidadeDTO>) engine.listConvertion(TempoAtendimentoUnidadeDTO.class, resp, listRetorno);
		} catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
		} catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
		return result == null || result.size() <= 0 ? new ArrayList<TempoAtendimentoUnidadeDTO>() : result;
	}

	public TempoAtendimentoUnidadeDTO restoreByIdAcordoNivelServico(final Integer idAcordoNivelServico) throws PersistenceException {
		final List<Order> ordem = new ArrayList<>();
		final TempoAtendimentoUnidadeDTO tempoAtendimentoUnidadeDTO = new TempoAtendimentoUnidadeDTO();
		tempoAtendimentoUnidadeDTO.setIdAcordoNivelServico(idAcordoNivelServico);
		final List<TempoAtendimentoUnidadeDTO> col = (List<TempoAtendimentoUnidadeDTO>) super.find(tempoAtendimentoUnidadeDTO, ordem);
		if (col == null || col.size() == 0) {
			return null;
		}
		return col.get(0);
	}

	@SuppressWarnings("rawtypes")
	public TempoAtendimentoUnidadeDTO restoreByIdUnidadeIdANS(final Integer idUnidade, final Integer idAcordoNivelServico) throws PersistenceException {
		ArrayList<TempoAtendimentoUnidadeDTO> result;
		final List listRetorno = new ArrayList<String>();
		final List parametro = new ArrayList();
		final StringBuilder sql = new StringBuilder();

		listRetorno.addAll(getFields());

		sql.append("SELECT ").append(this.getNamesFieldsStr("tau"));
		sql.append(" FROM ").append(this.getTableName()).append(" tau");

		sql.append(" WHERE tau.idacordonivelservico = ?");
		if (idAcordoNivelServico != null) {
			parametro.add(idAcordoNivelServico);
		} else {
			parametro.add(0);
		}

		sql.append(" AND tau.idUnidade = ?");
		if (idUnidade != null) {
			parametro.add(idUnidade);
		} else {
			parametro.add(0);
		}

		sql.append(" ORDER BY tau.prioridade ASC");

		List col = this.execSQL(sql.toString(), parametro.toArray());
		result = (ArrayList<TempoAtendimentoUnidadeDTO>) engine.listConvertion(TempoAtendimentoUnidadeDTO.class, col, listRetorno);

		if (result == null || result.size() == 0) {
			return null;
		}

		return result.get(0);
	}
}
