package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.TipoMudancaDTO;
import br.com.centralit.citcorpore.util.Enumerados.ChangeRequestPhase;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

public class TipoMudancaDAO extends CrudDaoDefaultImpl{

	public TipoMudancaDAO(){
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idTipoMudanca", "idTipoMudanca", true, true, false, false));
		listFields.add(new Field("nomeTipoMudanca", "nomeTipoMudanca", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		listFields.add(new Field("idTipoFluxo", "idTipoFluxo", false, false, false, false));
		listFields.add(new Field("idModeloEmailCriacao", "idModeloEmailCriacao", false, false, false, false));
		listFields.add(new Field("idModeloEmailFinalizacao", "idModeloEmailFinalizacao", false, false, false, false));
		listFields.add(new Field("idModeloEmailAcoes", "idModeloEmailAcoes", false, false, false, false));
		listFields.add(new Field("idGrupoExecutor", "idGrupoExecutor", false, false, false, false));
		listFields.add(new Field("idCalendario", "idCalendario", false, false, false, false));
		listFields.add(new Field("impacto", "impacto", false, false, false, false));
		listFields.add(new Field("urgencia", "urgencia", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "tipomudanca";
	}

	@Override
	@SuppressWarnings("unchecked")
	public Collection<TipoMudancaDTO> list() throws PersistenceException {
		List<Order> list = new ArrayList<Order>();
		list.add(new Order("nomeTipoMudanca"));
		return super.list(list);
	}

	@Override
	public Class<TipoMudancaDTO> getBean() {
		return TipoMudancaDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<TipoMudancaDTO> findByIdTipoMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idTipoMudanca", "=", parm));
		ordenacao.add(new Order("idTipoMudanca"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdTipoMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idTipoMudanca", "=", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public Collection<TipoMudancaDTO> findByNomeTipoMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("nomeTipoMudanca", "=", parm));
		ordenacao.add(new Order("nomeTipoMudanca"));
		condicao.add(new Condition(Condition.AND, "dataFim","is",null));
		return super.findByCondition(condicao, ordenacao);
	}

	@SuppressWarnings("unchecked")
	public Collection<TipoMudancaDTO> encontrarPorNomeTipoMudanca(TipoMudancaDTO tipoMudancaDTO) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("nomeTipoMudanca", "=", tipoMudancaDTO.getNomeTipoMudanca()));
		ordenacao.add(new Order("nomeTipoMudanca"));
		condicao.add(new Condition(Condition.AND, "dataFim","is",null));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByNomeTipoMudanca(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("nomeTipoMudanca", "=", parm));
		super.deleteByCondition(condicao);
	}

	/**
	 * Retorna lista de status de tipo mudana.
	 *
	 * @param obj
	 * @return
	 * @throws Exception
	 */
	public boolean verificarTipoMudancaAtivos(TipoMudancaDTO obj) throws PersistenceException {
		List<String> parametro = new ArrayList<String>();
		List<?> list = new ArrayList<>();
		String sql = "select idtipomudanca From " + getTableName() + "  where  nometipomudanca = ?   and dataFim is null ";

		if(obj.getIdTipoMudanca() != null){
			sql+=" and idtipomudanca <> "+ obj.getIdTipoMudanca();
		}

		parametro.add(obj.getNomeTipoMudanca());
		list = this.execSQL(sql, parametro.toArray());
		if (list != null && !list.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<TipoMudancaDTO> getAtivos() throws PersistenceException {
		List<Order> order = new ArrayList<Order>();
		List<Condition> condition = new ArrayList<Condition>();
		condition.add(new Condition("dataFim", "is",null));
		order.add(new Order("nomeTipoMudanca"));
		return super.findByCondition(condition, order);

	}

	/**
	 * @author euler.ramos
	 * @param idCalendario
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public ArrayList<TipoMudancaDTO> findByIdCalendario(Integer idCalendario) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idCalendario", "=", idCalendario));
		ordenacao.add(new Order("idTipoMudanca"));
		ArrayList<TipoMudancaDTO> result = (ArrayList<TipoMudancaDTO>) super.findByCondition(condicao, ordenacao);
		return result == null ? new ArrayList<TipoMudancaDTO>() : result;
	}

	/**
	 * Verifica se os parmetros de fluxo de mudana foram preenchidos.
	 *
	 * @param fluxoNormal
	 * @param fluxoPadrao
	 * @param fluxoEmergencial
	 * @throws LogicException
	 * @author douglas.japiassu
	 */
	protected void validarParametrosPreenchidos() throws LogicException {
		if (UtilStrings.isNullOrEmpty(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_NORMAL_MUDANCAS, null))) {
			throw new LogicException("parametroCitsmart.necessarioPreencherParametro279");
		}

		if (UtilStrings.isNullOrEmpty(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_PADRAO_MUDANCAS, null))) {
			throw new LogicException("parametroCitsmart.necessarioPreencherParametro47");
		}

		if (UtilStrings.isNullOrEmpty(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_EMERGENCIAL_MUDANCAS, null))) {
			throw new LogicException("parametroCitsmart.necessarioPreencherParametro280");
		}
	}

	/**
	 * Verifica se o tipo de mudanca passado possui o fluxo de mudana normal
	 *
	 * @author deborah.ferreira
	 * @since 10.06.2016
	 */
	public boolean isTipoMudancaComFluxoNormal(Integer idTipoMudanca) throws Exception {
		String fluxoNormal = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_NORMAL_MUDANCAS, null);

		validarParametrosPreenchidos();

		if (isTipoMudancaComFluxo(idTipoMudanca, Arrays.asList(fluxoNormal))) {
			return true;
		}

		return false;
	}

	/**
	 * Verifica se o tipo de mudanca passado possui o fluxo de mudana padro ou emergencial
	 *
	 * @author deborah.ferreira
	 * @since 10.06.2016
	 */
	public boolean isTipoMudancaComFluxoPadraoOuEmergencial(Integer idTipoMudanca) throws Exception {
		String fluxoPadrao = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_PADRAO_MUDANCAS, null);
		String fluxoEmergencial = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FLUXO_EMERGENCIAL_MUDANCAS, null);

		validarParametrosPreenchidos();

		if (isTipoMudancaComFluxo(idTipoMudanca, Arrays.asList(fluxoPadrao, fluxoEmergencial))) {
			return true;
		}

		return false;
	}

	public boolean isTipoMudancaComFaseProposta(Integer idTipoMudanca) throws Exception {
		validarParametrosPreenchidos();

		if (isTipoMudancaComFase(idTipoMudanca, Arrays.asList(ChangeRequestPhase.PROPOSAL))) {
			return true;
		}

		return false;
	}

	public boolean isTipoMudancaComFaseAprovacao(Integer idTipoMudanca) throws Exception {
		validarParametrosPreenchidos();

		if (isTipoMudancaComFase(idTipoMudanca, Arrays.asList(ChangeRequestPhase.APPROVAL))) {
			return true;
		}

		return false;
	}

	public boolean isTipoMudancaComFaseAprovacaoOuProposta(Integer idTipoMudanca) throws Exception {
		validarParametrosPreenchidos();

		if (isTipoMudancaComFase(idTipoMudanca, Arrays.asList(ChangeRequestPhase.APPROVAL, ChangeRequestPhase.PROPOSAL))) {
			return true;
		}

		return false;
	}

	/**
	 * Verifica se o tipo de mudanca passado possui o fluxo de mudana normal, padro ou emergencial
	 *
	 * @author deborah.ferreira
	 * @since 10.06.2016
	 */
	private boolean isTipoMudancaComFluxo(Integer idTipoMudanca, List<String> listNomeFluxo) throws PersistenceException {
		return isTipoMudancaComFluxoEFase(idTipoMudanca, listNomeFluxo, null);
	}

	/**
	 * Verifica se o tipo de mudanca passado possui em seu desenho a(s) fase(s) passadas.
	 *
	 * @author douglas.japiassu
	 * @since 03.08.2016
	 */
	private boolean isTipoMudancaComFase(Integer idTipoMudanca, List<ChangeRequestPhase> listChangeRequestPhase) throws PersistenceException {
		return isTipoMudancaComFluxoEFase(idTipoMudanca, null, listChangeRequestPhase);
	}

	/**
	 * Verifica se o tipo de mudanca passado possui o fluxo de mudana normal, padro ou emergencial e se tem em seu desenho, a fase passada.
	 *
	 * @author douglas.japiassu
	 * @since 02.08.2016
	 */
	@SuppressWarnings("unchecked")
	private boolean isTipoMudancaComFluxoEFase(Integer idTipoMudanca, List<String> listNomeFluxo, List<ChangeRequestPhase> listChangeRequestPhase) throws PersistenceException {
		List<Object> listResultado = new ArrayList<Object>();
		List<Object> listParametro = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("SELECT DISTINCT ");
		sqlBuilder.append("	tipoMudanca.idTipoMudanca ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("	bpm_tipofluxo tipoFluxo ");
		sqlBuilder.append("	INNER JOIN bpm_fluxo fluxo ON tipoFluxo.idTipoFluxo = fluxo.idTipoFluxo ");
		sqlBuilder.append("	INNER JOIN bpm_elementofluxo elementoFluxo ON fluxo.idFluxo = elementoFluxo.idFluxo ");
		sqlBuilder.append("	INNER JOIN tipoMudanca tipoMudanca ON tipoFluxo.idTipoFluxo = tipoMudanca.idTipoFluxo ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("	tipoMudanca.idTipoMudanca = ? ");
		listParametro.add(idTipoMudanca);
		sqlBuilder.append("	and fluxo.datafim is null ");

		if (listChangeRequestPhase != null) {
			sqlBuilder.append("	AND (upper(elementoFluxo.url) like upper('%idPhase=" + listChangeRequestPhase.get(0).getId() + "%') ");

			for (int i = 1, len = listChangeRequestPhase.size(); i < len; i++) {
				sqlBuilder.append("OR upper(elementoFluxo.url) like upper('%idPhase=" + listChangeRequestPhase.get(i).getId() + "%') ");
			}

			sqlBuilder.append(") ");
		}

		if (listNomeFluxo != null) {
			sqlBuilder.append("	AND (tipoFluxo.nomeFluxo = ? ");
			listParametro.add(listNomeFluxo.get(0));

			for (int i = 1, len = listNomeFluxo.size(); i < len; i++) {
				sqlBuilder.append("OR tipoFluxo.nomeFluxo = ? ");
				listParametro.add(listNomeFluxo.get(i));
			}

			sqlBuilder.append(")");
		}

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idTipoMudanca");

		List<TipoMudancaDTO> listaTipoMudanca = this.engine.listConvertion(TipoMudancaDTO.class, listResultado, listRetorno);

		if (listaTipoMudanca != null && !listaTipoMudanca.isEmpty()) {
			return true;
		}

		return false;
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

}

