package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.RelatorioTop10IncidentesRequisicoesDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.Top10IncidentesRequisicoesDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilNumbersAndDecimals;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class Top10IncidentesRequisicoesDAO extends CrudDaoDefaultImpl {

	public Top10IncidentesRequisicoesDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}
	
	public Top10IncidentesRequisicoesDAO(final String aliasDbReports) {
		super(aliasDbReports, null);
	}

	@Override
    public Collection find(final IDto obj) {
		return null;
	}

	@Override
    public Collection getFields() {
        final Collection listFields = new ArrayList();
		listFields.add(new Field("id", "id", true, true, false, false));
		listFields.add(new Field("descricao", "descricao", false, false, false, false));
		listFields.add(new Field("qtde", "qtde", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return null;
	}

	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return Top10IncidentesRequisicoesDTO.class;
	}
	
    public ArrayList<Top10IncidentesRequisicoesDTO> listSolicitantesMaisAbriramIncSol(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("id");
			listRetorno.add("descricao");
			listRetorno.add("qtde");
			
            final boolean seLimita = relatorioTop10IncidentesRequisicoesDTO.getTopList() != null && relatorioTop10IncidentesRequisicoesDTO.getTopList().intValue() > 0;
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ");
			
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				sql.append("TOP "+relatorioTop10IncidentesRequisicoesDTO.getTopList().toString()+" ");
			}
			
			sql.append("ss.idsolicitante id, e.nome descricao, count(ss.idsolicitacaoservico) qtde ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}			
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus= ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("join servico s on sc.idservico = s.idservico ");
			sql.append("join empregados e on ss.idsolicitante=idempregado ");
			
			/**
			 * A ordem em que  montada a query, no objeto StringBuilder sql, foi alterada, de forma que agora tambm  funcional para o BD Oracle.
			 * Ainda especificamente, no Oracle foi alterado o sql de forma que funcione com ROWNUM.
			 * Tambm foi alterado o if-else de forma a ser mais eficiente. 
			 * alterado por rcs (Rafael Csar Soyer) - Analista Desenvolvedor
			 * rafael.soyer@centrait.com.br
			 * data: 26/03/2015
			 */
			sql.append("group by ss.idsolicitante, e.nome ");
                        sql.append("order by qtde desc, descricao, idsolicitante");
            
            if (seLimita) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                    String sqlTudo = sql.toString();
                    sql.setLength(0);
                    sql.append("SELECT * FROM (" + sqlTudo + ") WHERE ROWNUM <= ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
				} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL)) {
                    sql.append(" LIMIT ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
                }
            }
            
            //fim rcs
			
            resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(this.getBean(), resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<Top10IncidentesRequisicoesDTO>) (result == null || result.size() <= 0 ? new ArrayList<Top10IncidentesRequisicoesDTO>() : result);
	}

	public Collection<SolicitacaoServicoDTO> listDetalheSolicitanteMaisAbriuIncSol(final Integer idSolicitante, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idSolicitacaoServico");
			listRetorno.add("nomeServico");
			listRetorno.add("idStatus");
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ss.idsolicitacaoservico, s.nomeservico, ss.idStatus ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and ss.idsolicitante = ? ");
			parametro.add(idSolicitante);
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}			
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			sql.append("join servico s on sc.idservico = s.idservico ");
			sql.append("order by ss.idsolicitacaoservico, s.nomeservico, ss.idStatus");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(SolicitacaoServicoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return result == null || result.size() <= 0 ? new ArrayList<SolicitacaoServicoDTO>() : result;
	}
	
    public ArrayList<Top10IncidentesRequisicoesDTO> listGruposMaisResolveramIncSol(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("id");
			listRetorno.add("descricao");
			listRetorno.add("qtde");
			
            final boolean seLimita = relatorioTop10IncidentesRequisicoesDTO.getTopList() != null && relatorioTop10IncidentesRequisicoesDTO.getTopList().intValue() > 0;
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ");
			
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				sql.append("TOP "+relatorioTop10IncidentesRequisicoesDTO.getTopList().toString()+" ");
			}
			
			sql.append("idgrupo id, nome descricao, count(idsolicitacaoservico) qtde ");
			sql.append("from ");
			sql.append("(select distinct bpm_atribuicaofluxo.idgrupo, grupo.nome, solicitacaoservico.idsolicitacaoservico, servico.nomeservico, bpm_instanciafluxo.idStatus,  empregados.nome responsavel ");
				 sql.append("from solicitacaoservico join execucaosolicitacao on ");
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
					sql.append("solicitacaoservico.idtipodemandaservico=? and ");
					parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
				 }
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
					sql.append("solicitacaoservico.idprioridade=? and ");
					parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
				 }
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
					sql.append("solicitacaoservico.idunidade=? and ");
					parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
				 }			
					
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("solicitacaoservico.idStatus = ? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
				 }
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
					sql.append("solicitacaoservico.idorigem=? and ");
					parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
				 }
				 
			sql.append("solicitacaoservico.idStatus = " + Enumerados.ServiceRequestStatus.CLOSED.getId() + " and solicitacaoservico.idsolicitacaoservico=execucaosolicitacao.idsolicitacaoservico ");
			sql.append("join bpm_instanciafluxo on  execucaosolicitacao.idinstanciafluxo = bpm_instanciafluxo.idinstancia and bpm_instanciafluxo.idStatus = " + br.com.centralit.bpm.util.Enumerated.INSTANCE_CLOSED + " ");
				                         sql.append("join bpm_itemtrabalhofluxo on ");
				                         											sql.append("(bpm_itemtrabalhofluxo.datahorafinalizacao between ? and ?) and ");
				                         											parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
				                         											parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
				                         											sql.append("execucaosolicitacao.idinstanciafluxo = bpm_itemtrabalhofluxo.idinstancia and (bpm_itemtrabalhofluxo.idresponsavelatual is not null) ");
			sql.append("join bpm_atribuicaofluxo on (bpm_atribuicaofluxo.idgrupo is not null) and bpm_itemtrabalhofluxo.iditemtrabalho = bpm_atribuicaofluxo.iditemtrabalho ");
			sql.append(" and bpm_atribuicaofluxo.idtype = ").append(br.com.centralit.bpm.util.Enumerated.AssignmentType.AUTOMATIC.getId());
				                         sql.append("join servicocontrato on ");
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				         					sql.append("servicocontrato.idcontrato=? and ");
				         					parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
				         				 }
            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				             				sql.append("servicocontrato.idservico=? and ");
				             				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
				             			 }
				                         sql.append("solicitacaoservico.idservicocontrato = servicocontrato.idservicocontrato ");
				                         sql.append("join servico on servicocontrato.idservico = servico.idservico ");
				                         sql.append("join usuario on bpm_itemtrabalhofluxo.idresponsavelatual = usuario.idusuario ");
				                         sql.append("join empregados on usuario.idempregado=empregados.idempregado ");
				                         sql.append("left join grupo on grupo.idgrupo = bpm_atribuicaofluxo.idgrupo ");
            if (!CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
		    	sql.append("order by bpm_atribuicaofluxo.idgrupo,solicitacaoservico.idsolicitacaoservico ");
            }
		    sql.append(") t ");
			sql.append("group by idgrupo, nome ");
			sql.append("order by qtde desc, descricao, id");
			
			if (seLimita) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                    String sqlTudo = sql.toString();
                    sql.setLength(0);
                    sql.append("SELECT * FROM (" + sqlTudo + ") WHERE ROWNUM <= ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
				} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL)) {
                    sql.append(" LIMIT ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
                }
            }
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(this.getBean(), resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<Top10IncidentesRequisicoesDTO>) (result == null || result.size() <= 0 ? new ArrayList<Top10IncidentesRequisicoesDTO>() : result);
	}
	
	public ArrayList<SolicitacaoServicoDTO> listDetalheGruposMaisResolveramIncSol(final Integer idGrupo, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idSolicitacaoServico");
			listRetorno.add("nomeServico");
			listRetorno.add("idStatus");
			listRetorno.add("responsavel");
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select distinct solicitacaoservico.idsolicitacaoservico, servico.nomeservico, bpm_instanciafluxo.idStatus,  empregados.nome responsavel ");
			sql.append("from solicitacaoservico join execucaosolicitacao on ");
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("solicitacaoservico.idtipodemandaservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("solicitacaoservico.idprioridade=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("solicitacaoservico.idunidade=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}			
					
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("solicitacaoservico.idStatus = ? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
					
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("solicitacaoservico.idorigem=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
				 
			sql.append("solicitacaoservico.idStatus = " + Enumerados.ServiceRequestStatus.CLOSED.getId() + " and solicitacaoservico.idsolicitacaoservico=execucaosolicitacao.idsolicitacaoservico ");
			sql.append("join bpm_instanciafluxo on  execucaosolicitacao.idinstanciafluxo = bpm_instanciafluxo.idinstancia and bpm_instanciafluxo.idStatus = " + br.com.centralit.bpm.util.Enumerated.INSTANCE_CLOSED + " ");
				sql.append("join bpm_itemtrabalhofluxo on ");
														sql.append("(bpm_itemtrabalhofluxo.datahorafinalizacao between ? and ?) and ");
														parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
														parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
														sql.append("execucaosolicitacao.idinstanciafluxo = bpm_itemtrabalhofluxo.idinstancia and (bpm_itemtrabalhofluxo.idresponsavelatual is not null) ");
            sql.append("join bpm_atribuicaofluxo on (bpm_atribuicaofluxo.idgrupo = ?) and bpm_itemtrabalhofluxo.iditemtrabalho = bpm_atribuicaofluxo.iditemtrabalho and bpm_atribuicaofluxo.idtype = ? ");
            	parametro.add(idGrupo);
            	parametro.add(br.com.centralit.bpm.util.Enumerated.AssignmentType.AUTOMATIC.getId());
				sql.append("join servicocontrato on ");
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
								sql.append("servicocontrato.idcontrato=? and ");
								parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
							}
            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				   				sql.append("servicocontrato.idservico=? and ");
				   				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
				   		    }
				            sql.append("solicitacaoservico.idservicocontrato = servicocontrato.idservicocontrato ");
				            sql.append("join servico on servicocontrato.idservico = servico.idservico ");
				            sql.append("join usuario on bpm_itemtrabalhofluxo.idresponsavelatual = usuario.idusuario ");
	                        sql.append("join empregados on usuario.idempregado=empregados.idempregado ");
			sql.append("order by idsolicitacaoservico, nomeservico, idStatus, responsavel");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(SolicitacaoServicoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<SolicitacaoServicoDTO>) (result == null || result.size() <= 0 ? new ArrayList<SolicitacaoServicoDTO>() : result);
	}
	
    public ArrayList<Top10IncidentesRequisicoesDTO> listReqIncMaisSolicitados(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("id");
			listRetorno.add("descricao");
			listRetorno.add("idServico");
			listRetorno.add("nomeServico");
			listRetorno.add("qtde");
			listRetorno.add("servicoNegocio");
			
            final boolean seLimita = relatorioTop10IncidentesRequisicoesDTO.getTopList() != null && relatorioTop10IncidentesRequisicoesDTO.getTopList().intValue() > 0;
			
            final StringBuilder sql = new StringBuilder();
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                sql.append("select * from(");
            }
			sql.append("select ");
			
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				sql.append("TOP "+relatorioTop10IncidentesRequisicoesDTO.getTopList().toString()+" ");
			}
			
			sql.append("ss.idtipodemandaservico id, t.nometipodemandaservico descricao, s.idservico idServico, s.nomeservico nomeServico, count(ss.idsolicitacaoservico) qtde, ");
			sql.append(" servrelacionado.nomeservico servicoNegocio from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante() != null && relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante().intValue() > 0) {
				sql.append("ss.idsolicitante=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}			
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append(" join servico s on sc.idservico = s.idservico ");
			sql.append(" join empregados e on ss.idsolicitante=idempregado ");
			sql.append(" join tipodemandaservico t on ss.idtipodemandaservico = t.idtipodemandaservico ");
			sql.append(" join servicoautorelacionamento auto on s.idservico = auto.idservico  ");
			sql.append(" join servico servrelacionado on auto.idservicorelacionado = servrelacionado.idservico ");
			
			sql.append("group by ss.idtipodemandaservico, t.nometipodemandaservico, s.idservico, s.nomeservico, servrelacionado.nomeServico ");
			sql.append("order by qtde desc,nometipodemandaservico,s.nomeservico");
			
			if (seLimita && (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL))) {
				sql.append(" LIMIT ?");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
			}
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                sql.append(") WHERE ROWNUM <= ? ");
                parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
            }
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(this.getBean(), resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<Top10IncidentesRequisicoesDTO>) (result == null || result.size() <= 0 ? new ArrayList<Top10IncidentesRequisicoesDTO>() : result);
	}

	public ArrayList<SolicitacaoServicoDTO> listDetalheReqIncMaisSolicitados(final Integer idTipoDemanda, final Integer idServico, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idSolicitacaoServico");
			listRetorno.add("nomeServico");
			listRetorno.add("idStatus");
			listRetorno.add("nomeSolicitante");
			listRetorno.add("nomeGrupo");
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, e.nome nomesolicitante, grupo.nome nomegrupo ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
			sql.append("sc.idservico=? and ");
			parametro.add(idServico);
			
			sql.append("ss.idtipodemandaservico=? and ");
			parametro.add(idTipoDemanda);
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante() != null && relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante().intValue() > 0) {
				sql.append("ss.idsolicitante=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdSolicitante());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}			
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("join servico s on sc.idservico = s.idservico ");
			sql.append("join empregados e on ss.idsolicitante=idempregado ");
			sql.append("join tipodemandaservico t on ss.idtipodemandaservico = t.idtipodemandaservico ");
			sql.append("left join grupo on grupo.idgrupo = ss.idgrupoatual ");
			
			sql.append("order by ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, e.nome, grupo.nome");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(SolicitacaoServicoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<SolicitacaoServicoDTO>) (result == null || result.size() <= 0 ? new ArrayList<SolicitacaoServicoDTO>() : result);
	}
	
    public ArrayList<Top10IncidentesRequisicoesDTO> listUnidadesMaisAbriramReqInc(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("id");
			listRetorno.add("descricao");
			listRetorno.add("qtde");
			
            final boolean seLimita = relatorioTop10IncidentesRequisicoesDTO.getTopList() != null && relatorioTop10IncidentesRequisicoesDTO.getTopList().intValue() > 0;
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ");
			
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				sql.append("TOP "+relatorioTop10IncidentesRequisicoesDTO.getTopList().toString()+" ");
			}
			
			sql.append("ss.idunidade id, unidade.nome descricao, count(ss.idsolicitacaoservico) qtde ");
			
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("join servico s on sc.idservico = s.idservico ");
			sql.append("join empregados e on ss.idsolicitante=idempregado ");
			sql.append("join tipodemandaservico t on ss.idtipodemandaservico = t.idtipodemandaservico ");
			sql.append("join unidade on unidade.idunidade=ss.idunidade ");
			
			sql.append("group by ss.idunidade, unidade.nome ");
			sql.append("order by qtde desc, descricao");
			
			if (seLimita) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                    String sqlTudo = sql.toString();
                    sql.setLength(0);
                    sql.append("SELECT * FROM (" + sqlTudo + ") WHERE ROWNUM <= ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
				} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL)) {
                    sql.append(" LIMIT ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
                }
            }
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(this.getBean(), resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<Top10IncidentesRequisicoesDTO>) (result == null || result.size() <= 0 ? new ArrayList<Top10IncidentesRequisicoesDTO>() : result);
	}

	public ArrayList<SolicitacaoServicoDTO> listDetalheUnidadesMaisAbriramReqInc(final Integer idUnidade, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idSolicitacaoServico");
			listRetorno.add("nomeServico");
			listRetorno.add("idStatus");
			listRetorno.add("nomeTipoDemandaServico");
			listRetorno.add("nomeGrupo");
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, t.nometipodemandaservico, grupo.nome nomegrupo ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
			sql.append("ss.idunidade=? and ");
			parametro.add(idUnidade);
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("join servico s on sc.idservico = s.idservico ");
			sql.append("join empregados e on ss.idsolicitante=idempregado ");
			sql.append("join tipodemandaservico t on ss.idtipodemandaservico = t.idtipodemandaservico ");
			sql.append("join unidade on unidade.idunidade=ss.idunidade ");
			sql.append("left join grupo on grupo.idgrupo = ss.idgrupoatual ");
			sql.append("order by ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, t.nometipodemandaservico, grupo.nome");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(SolicitacaoServicoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<SolicitacaoServicoDTO>) (result == null || result.size() <= 0 ? new ArrayList<SolicitacaoServicoDTO>() : result);
	}

    public ArrayList<Top10IncidentesRequisicoesDTO> listLocMaisAbriramReqInc(final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("id");
			listRetorno.add("descricao");
			listRetorno.add("qtde");
			
            final boolean seLimita = relatorioTop10IncidentesRequisicoesDTO.getTopList() != null && relatorioTop10IncidentesRequisicoesDTO.getTopList().intValue() > 0;
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ");
			
            if (seLimita && CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				sql.append("TOP "+relatorioTop10IncidentesRequisicoesDTO.getTopList().toString()+" ");
			}
			
			sql.append("localidade.idlocalidade id, localidade.nomelocalidade descricao, count(ss.idsolicitacaoservico) qtde ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}		
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("left join contatosolicitacaoservico on contatosolicitacaoservico.idcontatosolicitacaoservico = ss.idcontatosolicitacaoservico ");
			sql.append("left join localidade on contatosolicitacaoservico.idlocalidade = localidade.idlocalidade ");
			sql.append("group by localidade.idlocalidade, localidade.nomelocalidade ");
			sql.append("order by qtde desc, descricao");
			
			if (seLimita) {
                if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
                    String sqlTudo = sql.toString();
                    sql.setLength(0);
                    sql.append("SELECT * FROM (" + sqlTudo + ") WHERE ROWNUM <= ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
				} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL)) {
                    sql.append(" LIMIT ?");
                    parametro.add(relatorioTop10IncidentesRequisicoesDTO.getTopList());
                }
            }
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(this.getBean(), resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return (ArrayList<Top10IncidentesRequisicoesDTO>) (result == null || result.size() <= 0 ? new ArrayList<Top10IncidentesRequisicoesDTO>() : result);
	}
	
	public Collection<SolicitacaoServicoDTO> listDetalheLocMaisAbriramReqInc(final Integer idLocalidade, final RelatorioTop10IncidentesRequisicoesDTO relatorioTop10IncidentesRequisicoesDTO) {
		List result;
		try {
			List resp = new ArrayList();
            final List parametro = new ArrayList();
            final List listRetorno = new ArrayList();
			
			listRetorno.add("idSolicitacaoServico");
			listRetorno.add("nomeServico");
			listRetorno.add("idStatus");
			listRetorno.add("nomeTipoDemandaServico");
			listRetorno.add("nomeGrupo");
			
            final StringBuilder sql = new StringBuilder();
			sql.append("select ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, t.nometipodemandaservico, grupo.nome nomeGrupo ");
			sql.append("from servicocontrato sc join solicitacaoservico ss on ");
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdContrato() != null && relatorioTop10IncidentesRequisicoesDTO.getIdContrato().intValue() > 0) {
				sql.append("sc.idcontrato=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdContrato());
			}

            if (relatorioTop10IncidentesRequisicoesDTO.getIdServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdServico().intValue() > 0) {
				sql.append("sc.idservico=? and ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdServico());
			}			
			
			sql.append("sc.idservicocontrato = ss.idservicocontrato ");
			sql.append("and (ss.datahorasolicitacao between ? and ?) ");
			parametro.add(UtilDatas.getSqlDate(relatorioTop10IncidentesRequisicoesDTO.getDataInicial()));
			parametro.add(UtilDatas.getTimeStampComUltimaHoraDoDia(relatorioTop10IncidentesRequisicoesDTO.getDataFinal()));
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico() != null && relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico().intValue() > 0) {
				sql.append("and ss.idtipodemandaservico=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdTipoDemandaServico());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade().intValue() > 0) {
				sql.append("and ss.idprioridade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdPrioridade());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdUnidade() != null && relatorioTop10IncidentesRequisicoesDTO.getIdUnidade().intValue() > 0) {
				sql.append("and ss.idunidade=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdUnidade());
			}		
			
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(relatorioTop10IncidentesRequisicoesDTO.getIdStatus())) {
				sql.append("and ss.idStatus = ? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdStatus());
			}
			
            if (relatorioTop10IncidentesRequisicoesDTO.getIdOrigem() != null && relatorioTop10IncidentesRequisicoesDTO.getIdOrigem().intValue() > 0) {
				sql.append("and ss.idorigem=? ");
				parametro.add(relatorioTop10IncidentesRequisicoesDTO.getIdOrigem());
			}
			
			sql.append("left join servico s on sc.idservico = s.idservico ");
			sql.append("left join tipodemandaservico t on ss.idtipodemandaservico = t.idtipodemandaservico ");
			sql.append("left join contatosolicitacaoservico on contatosolicitacaoservico.idcontatosolicitacaoservico = ss.idcontatosolicitacaoservico ");
			
			sql.append("left join localidade on contatosolicitacaoservico.idlocalidade = localidade.idlocalidade ");
			sql.append("left join grupo on grupo.idgrupo = ss.idgrupoatual ");
			
			sql.append("where ");
			if (idLocalidade==null) {
				sql.append("(contatosolicitacaoservico.idlocalidade is null) ");
			} else {
				sql.append("contatosolicitacaoservico.idlocalidade=? ");
				parametro.add(idLocalidade);
			}
			sql.append("order by ss.idsolicitacaoservico, s.nomeservico, ss.idStatus, t.nometipodemandaservico, grupo.nome");
			
			resp = this.execSQL(sql.toString(), parametro.toArray());
            result = engine.listConvertion(SolicitacaoServicoDTO.class, resp, listRetorno);
        } catch (final PersistenceException e) {
			e.printStackTrace();
			result = null;
        } catch (final Exception e) {
			e.printStackTrace();
			result = null;
		}
        return result == null || result.size() <= 0 ? new ArrayList<SolicitacaoServicoDTO>() : result;
	}

}
