package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.List;

import br.com.centralit.citcorpore.bean.TratativaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class TratativaDao extends CrudDaoDefaultImpl {

	public TratativaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("idtratativa", "idTratativa", true, true, false, false));
		listFields.add(new Field("nometratativa", "nomeTratativa", false, false, false, false));
		listFields.add(new Field("datainicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "tratativa";
	}

	@Override
	public Class<TratativaDTO> getBean() {
		return TratativaDTO.class;
	}

	public void updateNotNull(TratativaDTO tratativaDTO) throws PersistenceException {
		super.updateNotNull(tratativaDTO);
	}
}
